/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.equipment.api.ISettlementApi;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.service.IPurchaseSettlementService;
import com.ejianc.business.material.vo.ContractExportVO;
import com.ejianc.business.material.vo.MaterialContractDetailSubVO;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.sub.api.ISubReportApi;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceReceiveRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/materialContract/"})
public class MaterialContractController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static volatile HttpServletRequest request;
    @Autowired
    private IMaterialContractService materialContractService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi iProjectApi;
    @Autowired
    private IInvoiceApi iInvoiceApi;
    @Autowired
    private IPayContractApi payContractApi;
    @Autowired
    private ISettlementApi settlementApi;
    @Autowired
    private ISubReportApi subReportApi;
    @Autowired
    private IPurchaseSettlementService purchaseSettlementService;
    @Value(value="${common.env.base-host}")
    public String BASE_HOST;

    @PostMapping(value={"checkParams/{isJc}"})
    public CommonResponse<ParamsCheckVO> checkParams(@PathVariable(name="isJc") Integer isJc, @RequestBody MaterialPriceVO vo) {
        ParamsCheckVO paramsCheckVO = this.materialContractService.checkParams(isJc, vo.getContractId(), vo);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    @PostMapping(value={"queryPrice/{isJc}"})
    public CommonResponse<List<MaterialPriceVO>> queryPrice(@PathVariable(name="isJc") Integer isJc, @RequestBody MaterialPriceVO vo) {
        this.materialContractService.queryPrice(isJc, null, vo);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo.getDetail());
    }

    @PostMapping(value={"pageList"})
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        JSONObject resp = new JSONObject();
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("supplierName");
        queryParam.getFuzzyFields().add("purchaseOrgName");
        queryParam.getFuzzyFields().add("projectCode");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
        queryParam.getComplexParams().add(this.getPageQueryParam(null));
        IPage pageData = this.materialContractService.queryPage(queryParam, false);
        Map<String, Object> contractAmountMap = this.materialContractService.countContractAmount(queryParam);
        resp.put("records", (Object)pageData.getRecords());
        resp.put("total", (Object)pageData.getTotal());
        resp.put("size", (Object)pageData.getSize());
        resp.put("current", (Object)pageData.getCurrent());
        resp.put("pages", (Object)pageData.getPages());
        resp.put("materialCount", contractAmountMap);
        return CommonResponse.success((String)"\u5408\u540c\u5206\u9875\u5217\u8868\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    public ComplexParam getPageQueryParam(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        if (null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(orgId);
        CommonResponse parentOrgResp = this.orgApi.findParentsByOrgId(orgId);
        if (!childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            throw new BusinessException("\u5408\u540c\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList parentOrgIds = new ArrayList();
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        parentOrgIds.addAll(((List)parentOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        parentOrgIds.remove(orgId);
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("purchase_org_id", new Parameter("in", childIds));
        c1.getComplexParams().add(c2);
        if (CollectionUtils.isNotEmpty(parentOrgIds)) {
            ComplexParam c3 = new ComplexParam();
            c3.setLogic("or");
            c3.getParams().put("depend_on_project", new Parameter("eq", (Object)"0"));
            c3.getParams().put("purchase_org_id", new Parameter("in", parentOrgIds));
            c1.getComplexParams().add(c3);
            c3.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        }
        if (CollectionUtils.isNotEmpty(parentOrgIds)) {
            ComplexParam c4 = new ComplexParam();
            c4.setLogic("or");
            c4.getParams().put("depend_on_project", new Parameter("eq", (Object)"1"));
            c4.getParams().put("replace_sign_flag", new Parameter("eq", (Object)1));
            c4.getParams().put("purchase_org_id", new Parameter("in", parentOrgIds));
            c4.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
            c1.getComplexParams().add(c4);
        }
        return c1;
    }

    @PostMapping(value={"saveOrUpdate"})
    public CommonResponse<MaterialContractVO> save(@RequestBody MaterialContractVO materialContractVO) {
        boolean checkResult = this.materialContractService.codeCheck(materialContractVO.getId(), materialContractVO.getCode());
        if (!checkResult) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5408\u540c\u7f16\u7801\u91cd\u590d");
        }
        MaterialContractVO resp = this.materialContractService.save(materialContractVO);
        this.queryMaterialPrice(resp);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        JSONObject resp = new JSONObject();
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("supplierName");
        queryParam.getFuzzyFields().add("purchaseOrgName");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(-1);
        queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
        queryParam.getComplexParams().add(this.getPageQueryParam(null));
        IPage pageData = this.materialContractService.queryPage(queryParam, false);
        HashMap beans = new HashMap();
        ArrayList list = new ArrayList();
        List data = pageData.getRecords();
        if (CollectionUtils.isNotEmpty((Collection)data)) {
            data.forEach(contract -> {
                ContractExportVO vo = (ContractExportVO)BeanMapper.map((Object)contract, ContractExportVO.class);
                vo.setCreateTime(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)contract.getCreateTime()));
                vo.setSignDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)contract.getSignDate()));
                vo.setChangeStateName(contract.getChangeState().equals(MaterialContractVO.CONTRACT_CHANGE_STATE_UNCHANGED) ? "\u672a\u53d8\u66f4" : (contract.getChangeState().equals(MaterialContractVO.CONTRACT_CHANGE_STATE_CHANGING) ? "\u53d8\u66f4\u4e2d" : "\u5df2\u53d8\u66f4"));
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)contract.getBillState()).getDescription());
                list.add(vo);
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("contract-export.xlsx", beans, response);
    }

    @PostMapping(value={"delete"})
    public CommonResponse<String> delete(@RequestBody List<MaterialContractVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            this.materialContractService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @GetMapping(value={"queryDetail"})
    public CommonResponse<MaterialContractVO> queryDetail(@RequestParam(value="id") Long id) {
        MaterialContractVO vo = null;
        MaterialContractEntity dbEntity = (MaterialContractEntity)((Object)this.materialContractService.selectById(id));
        if (null != dbEntity) {
            vo = (MaterialContractVO)BeanMapper.map((Object)((Object)dbEntity), MaterialContractVO.class);
            this.queryMaterialPrice(vo);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u7269\u8d44\u5408\u540c\u8be6\u60c5\u6210\u529f\uff01", vo);
    }

    @GetMapping(value={"queryDetailAndPrice"})
    public CommonResponse<MaterialContractVO> queryDetailAndPrice(@RequestParam(value="id") Long id) {
        MaterialContractVO vo = null;
        MaterialContractEntity dbEntity = (MaterialContractEntity)((Object)this.materialContractService.selectById(id));
        if (null != dbEntity) {
            vo = (MaterialContractVO)BeanMapper.map((Object)((Object)dbEntity), MaterialContractVO.class);
            this.queryMaterialPrice(vo);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u7269\u8d44\u5408\u540c\u8be6\u60c5\u6210\u529f\uff01", vo);
    }

    private void queryMaterialPrice(MaterialContractVO vo) {
        if (CollectionUtils.isNotEmpty((Collection)vo.getMaterialDetailList())) {
            for (MaterialContractDetailSubVO event : vo.getMaterialDetailList()) {
                if (!StringUtils.isEmpty((CharSequence)event.getMaterialId())) continue;
                return;
            }
        } else {
            return;
        }
        List materialDetailList = vo.getMaterialDetailList();
        if (CollectionUtils.isNotEmpty((Collection)materialDetailList)) {
            MaterialPriceVO priceVO = new MaterialPriceVO(vo.getProjectId());
            ArrayList detail = new ArrayList();
            materialDetailList.forEach(item -> {
                MaterialPriceVO materialPriceVO = new MaterialPriceVO();
                materialPriceVO.setMaterialId(Long.valueOf(item.getMaterialId()));
                detail.add(materialPriceVO);
            });
            priceVO.setDetail(detail);
            Integer isJc = "1".equals(vo.getPurchaseMode()) ? 1 : 0;
            MaterialPriceVO materialPriceVO = this.materialContractService.queryPrice(isJc, vo.getId(), priceVO);
            List dd = materialPriceVO.getDetail();
            if (CollectionUtils.isNotEmpty((Collection)dd)) {
                Map<Long, MaterialPriceVO> priceVOMap = dd.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account, (v1, v2) -> v2));
                for (MaterialContractDetailSubVO v : materialDetailList) {
                    String materialId = v.getMaterialId();
                    MaterialPriceVO p = priceVOMap.get(Long.valueOf(materialId));
                    if (null == p) continue;
                    v.setPlanNum(p.getPlanNum());
                    v.setPlanPrice(p.getPlanPrice());
                    v.setMinPrice(p.getMinPrice());
                    v.setMaxPrice(p.getMaxPrice());
                    v.setPriceArea(p.getPriceArea());
                }
            }
        }
    }

    @GetMapping(value={"contractListRefer"})
    public CommonResponse<IPage<MaterialContractEntity>> contractListRefer(@RequestParam(required=false) String condition, @RequestParam(required=false) String searchText, @RequestParam int pageSize, @RequestParam int pageNumber, @RequestParam(required=false) String searchObject) {
        Map conditionMap;
        QueryParam queryParam = new QueryParam();
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("supplier_name");
        queryParam.getOrderMap().put("effective_date", "desc");
        if (StringUtils.isNotBlank((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("settlementType")) {
            Integer settlementType = Integer.valueOf(conditionMap.get("settlementType").toString());
            queryParam.getParams().put("settlementType", new Parameter("ne", (Object)settlementType));
        }
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state", new Parameter("in", billStateList));
        queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            queryParam.setSearchText(searchText);
        }
        Long orgId = InvocationInfoProxy.getOrgId();
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap2 = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap2.get("mobileLeave")) {
                if (null != conditionMap2.get("orgId")) {
                    orgId = Long.valueOf(conditionMap2.get("orgId").toString());
                    queryParam.getComplexParams().add(this.getPageQueryParam(orgId));
                } else {
                    queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
                    queryParam.getParams().put("dependOnProject", new Parameter("eq", (Object)"0"));
                }
            } else {
                if (null != conditionMap2.get("orgId")) {
                    orgId = Long.valueOf(conditionMap2.get("orgId").toString());
                }
                if (null != conditionMap2.get("supplierId")) {
                    queryParam.getParams().put("supplier_id", new Parameter("eq", (Object)Long.valueOf(conditionMap2.get("supplierId").toString())));
                }
                if (StringUtils.isNotBlank((CharSequence)searchObject)) {
                    JSONObject search = JSONObject.parseObject((String)searchObject);
                    for (String key : search.keySet()) {
                        queryParam.getParams().put(key, new Parameter("like", (Object)search.get((Object)key).toString()));
                    }
                }
                queryParam.getComplexParams().add(this.getPageQueryParam(orgId));
            }
            if (null != conditionMap2.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap2.get("projectId").toString());
                queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)searchObject)) {
                JSONObject search = JSONObject.parseObject((String)searchObject);
                for (String key : search.keySet()) {
                    queryParam.getParams().put(key, new Parameter("like", (Object)search.get((Object)key).toString()));
                }
            }
            queryParam.getComplexParams().add(this.getPageQueryParam(orgId));
        }
        IPage pageData = this.materialContractService.queryPage(queryParam, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5408\u540c\u5217\u8868\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"changeState"})
    public CommonResponse<String> changeState(@RequestBody MaterialContractVO materialContractVO) {
        MaterialContractEntity contract = (MaterialContractEntity)((Object)this.materialContractService.selectById(materialContractVO.getId()));
        contract.setState(materialContractVO.getState());
        contract.setStateName(materialContractVO.getStateName());
        this.materialContractService.saveOrUpdate((Object)contract, false);
        return CommonResponse.success((String)"\u4fee\u6539\u5408\u540c\u72b6\u6001\u6210\u529f\uff01");
    }

    @PostMapping(value={"codeCheck"})
    public CommonResponse<String> checkContractCode(@RequestBody MaterialContractVO contract) {
        boolean result = this.materialContractService.codeCheck(contract.getId(), contract.getCode());
        if (!result) {
            return CommonResponse.error((String)"\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        return CommonResponse.success((String)"\u7f16\u7801\u53ef\u4ee5\u4f7f\u7528\uff01");
    }

    @RequestMapping(value={"invoiceRecRecords"})
    public CommonResponse<JSONObject> queryContractInvoiceRecRecords(@RequestParam(value="id") Long id) {
        JSONObject data = new JSONObject();
        BigDecimal totalPayAmount = BigDecimal.ZERO.setScale(8);
        CommonResponse payResp = this.payContractApi.getSumPayMnyVOList(id, InvocationInfoProxy.getOrgId());
        if (!payResp.isSuccess()) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5408\u540c\u6536\u7968\u8bb0\u5f55\u5931\u8d25\uff0c\u83b7\u5408\u540c\u4ed8\u6b3e\u4fe1\u606f\u5931\u8d25\uff01");
        }
        SumPayMnyVO payRecords = (SumPayMnyVO)payResp.getData();
        if (null != payRecords.getSumPayMny()) {
            totalPayAmount = payRecords.getSumPayMny();
        }
        BigDecimal totalSettlementAmount = this.getTotalSettleAmount(id);
        BigDecimal dueInInvoiceAmount = null;
        CommonResponse records = this.iInvoiceApi.getInvoiceReceiveRecord(id);
        if (!records.isSuccess()) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5408\u540c\u6536\u7968\u7edf\u8ba1\u8bb0\u5f55\u5931\u8d25\uff01");
        }
        InvoiceReceiveRecordVO irr = (InvoiceReceiveRecordVO)records.getData();
        dueInInvoiceAmount = totalSettlementAmount.subtract(totalPayAmount);
        if (dueInInvoiceAmount.compareTo(BigDecimal.ZERO.setScale(8, 4)) < 0) {
            dueInInvoiceAmount = BigDecimal.ZERO;
        }
        data.put("contractId", (Object)id);
        data.put("totalTaxAmount", (Object)irr.getTaxMny());
        data.put("totalInvoiceRecTaxAmount", (Object)irr.getInvoiceTaxMny());
        data.put("totalInvoiceRecAmount", (Object)irr.getInvoiceMny());
        data.put("invoiceRecRecords", (Object)irr.getInvoiceReceiveVOList());
        data.put("cumulativePayAmount", (Object)totalSettlementAmount);
        data.put("totalPayAmount", (Object)totalPayAmount);
        data.put("dueInInvoiceAmount", (Object)dueInInvoiceAmount);
        return CommonResponse.success((String)"\u67e5\u8be2\u5408\u540c\u6536\u7968\u8bb0\u5f55\u6210\u529f\uff01", (Object)data);
    }

    @GetMapping(value={"paymentRecords"})
    public CommonResponse<JSONObject> queryPaymentRecords(@RequestParam(value="id") Long id) {
        JSONObject data = new JSONObject();
        MaterialContractEntity contractEntity = (MaterialContractEntity)((Object)this.materialContractService.selectById(id));
        BigDecimal totalPayAmount = BigDecimal.ZERO.setScale(8);
        CommonResponse payResp = this.payContractApi.getSumPayMnyVOList(id, InvocationInfoProxy.getOrgId());
        if (!payResp.isSuccess()) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5408\u540c\u4ed8\u6b3e\u8bb0\u5f55\u5931\u8d25\uff0c\u83b7\u5408\u540c\u4ed8\u6b3e\u4fe1\u606f\u5931\u8d25\uff01");
        }
        SumPayMnyVO payRecords = (SumPayMnyVO)payResp.getData();
        if (null != payRecords.getSumPayMny()) {
            totalPayAmount = payRecords.getSumPayMny();
        }
        BigDecimal totalSettlementAmount = this.getTotalSettleAmount(id);
        data.put("contractId", (Object)id);
        data.put("totalPayAmount", (Object)totalPayAmount);
        data.put("totalSettlementAmount", (Object)totalSettlementAmount);
        data.put("aggreedPaymentRatio", (Object)contractEntity.getAggreedPaymentRatio());
        data.put("aggreedPaymentAmount", (Object)totalSettlementAmount.multiply(new BigDecimal((null != contractEntity.getAggreedPaymentRatio() ? contractEntity.getAggreedPaymentRatio() : 100.0) / 100.0).setScale(8, 4)));
        Double totalPayRatio = 0.0;
        if (totalSettlementAmount.compareTo(BigDecimal.ZERO.setScale(8)) != 0) {
            totalPayRatio = totalPayAmount.divide(totalSettlementAmount, 8, 4).multiply(new BigDecimal(100).setScale(8)).doubleValue();
        }
        data.put("totalPayRatio", (Object)totalPayRatio);
        data.put("payRecords", (Object)payRecords.getContractVOList());
        return CommonResponse.success((String)"\u67e5\u8be2\u5408\u540c\u4ed8\u6b3e\u8bb0\u5f55\u6210\u529f\uff01", (Object)data);
    }

    private BigDecimal getTotalSettleAmount(Long contractId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        MaterialContractEntity contract = (MaterialContractEntity)((Object)this.materialContractService.selectById(contractId));
        if (!"1".equals(contract.getDependOnProject())) {
            Long orgId = InvocationInfoProxy.getOrgId();
            CommonResponse orgResp = this.orgApi.findChildrenByParentId(orgId);
            if (!orgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u5408\u540c\u6536\u7968\u8bb0\u5f55\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u4fe1\u606f\u5931\u8d25\uff01");
            }
            List orgIds = ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
            queryParam.getParams().put("orgId", new Parameter("in", orgIds));
        }
        return this.purchaseSettlementService.calculateTotalSettlement(queryParam);
    }

    @GetMapping(value={"getOutContractTotalAmount"})
    public CommonResponse<JSONObject> getOutContractTotalAmount(@RequestParam Integer type, @RequestParam(value="orgId", required=false) Long orgId, HttpServletRequest req) {
        request = req;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        ArrayList newIds = new ArrayList();
        if (orgId != null) {
            queryParam.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            queryParam.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List contractEntities = this.materialContractService.queryList(queryParam, false);
        queryParam.getParams().remove("supplement_flag");
        queryParam.getParams().remove("dependOnProject");
        List settlementEntities = this.purchaseSettlementService.queryList(queryParam, false);
        BigDecimal contract = new BigDecimal("0.00");
        BigDecimal settle = new BigDecimal("0.00");
        BigDecimal invoiceTaxMny = new BigDecimal("0.00");
        BigDecimal payApplyAmount = new BigDecimal("0.00");
        if (ListUtil.isNotEmpty((List)contractEntities)) {
            for (BaseEntity c : contractEntities) {
                contract = contract.add(c.getAmountWithTax() == null ? new BigDecimal("0.00") : c.getAmountWithTax());
            }
        }
        if (ListUtil.isNotEmpty((List)settlementEntities)) {
            for (BaseEntity c : settlementEntities) {
                settle = settle.add(c.getCurrentSettlementAmountTax() == null ? new BigDecimal("0.00") : c.getCurrentSettlementAmountTax());
            }
        }
        this.logger.info("\u79fb\u52a8\u9996\u9875\uff0c\u67e5\u8be2\u652f\u51fa\u7ed3\u7b97\uff0c\u7269\u8d44\u7ed3\u7b97\uff1a{}\uff0c\u7269\u8d44\u5408\u540c\uff1a{}", (Object)settle, (Object)contract);
        JSONObject back = this.getOtherContractAmount(orgId);
        contract = contract.add(back.getBigDecimal("contract")).divide(new BigDecimal("10000")).setScale(2, 4);
        settle = settle.add(back.getBigDecimal("settle")).divide(new BigDecimal("10000")).setScale(2, 4);
        invoiceTaxMny = invoiceTaxMny.add(back.getBigDecimal("invoiceTaxMny")).divide(new BigDecimal("10000")).setScale(2, 4);
        payApplyAmount = payApplyAmount.add(back.getBigDecimal("payApplyAmount")).divide(new BigDecimal("10000")).setScale(2, 4);
        back = new JSONObject();
        back.put("contract", (Object)contract);
        back.put("settle", (Object)settle);
        back.put("invoiceTaxMny", (Object)invoiceTaxMny);
        back.put("payApplyAmount", (Object)payApplyAmount);
        return CommonResponse.success((Object)back);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject getOtherContractAmount(Long orgId) {
        ExecutorService threadPool = Executors.newFixedThreadPool(6);
        BigDecimal contract = new BigDecimal("0.00");
        BigDecimal settle = new BigDecimal("0.00");
        BigDecimal invoiceTaxMny = new BigDecimal("0.00");
        BigDecimal payApplyAmount = new BigDecimal("0.00");
        PostDataCallable equipmentContractAmountNum = new PostDataCallable(this.BASE_HOST + "ejc-equipment-web/purchaseContract/getEquipmentContractTotalAmount", orgId);
        Future<JSONObject> future1 = threadPool.submit(equipmentContractAmountNum);
        PostDataCallable subContractAmountNum = new PostDataCallable(this.BASE_HOST + "ejc-sub-web/contract/getSubContractTotalAmount", orgId);
        Future<JSONObject> future2 = threadPool.submit(subContractAmountNum);
        PostDataCallable tax = new PostDataCallable(this.BASE_HOST + "ejc-tax-web/invoiceReceive/getTotalInvoiceTaxMnyByProjectIds", orgId);
        Future<JSONObject> future3 = threadPool.submit(tax);
        PostDataCallable finance = new PostDataCallable(this.BASE_HOST + "ejc-finance-web/payContract/getTotalPayApplyAmountByProjectIds", orgId);
        Future<JSONObject> future4 = threadPool.submit(finance);
        PostDataCallable rmat = new PostDataCallable(this.BASE_HOST + "ejc-rmat-web/rentContract/getRmatContractTotalAmount", orgId);
        Future<JSONObject> future5 = threadPool.submit(rmat);
        PostDataCallable other = new PostDataCallable(this.BASE_HOST + "ejc-other-web/otherContract/getOtherContractTotalAmount", orgId);
        Future<JSONObject> future6 = threadPool.submit(other);
        try {
            JSONObject c1 = future1.get();
            if (c1.getInteger("code") == 0) {
                JSONObject data = c1.getJSONObject("data");
                contract = contract.add(data.getBigDecimal("contract"));
                settle = settle.add(data.getBigDecimal("settle"));
                this.logger.info("\u79fb\u52a8\u9996\u9875\uff0c\u67e5\u8be2\u652f\u51fa\u7ed3\u7b97\uff0c\u8bbe\u5907\u7ed3\u7b97c1\uff1a{}\uff0c\u8bbe\u5907\u5408\u540c\uff1a{}", (Object)data.getBigDecimal("settle"), (Object)data.getBigDecimal("contract"));
            } else {
                this.logger.info("\u79fb\u52a8\u9996\u9875\uff0c\u67e5\u8be2\u652f\u51fa\u7d2f\u8ba1\u5408\u540c\u4ed8\u6b3e\u51fa\u9519c1\uff1a{} ", (Object)c1);
            }
            JSONObject c2 = future2.get();
            if (c2.getInteger("code") == 0) {
                JSONObject data = c2.getJSONObject("data");
                contract = contract.add(data.getBigDecimal("contract"));
                settle = settle.add(data.getBigDecimal("settle"));
                this.logger.info("\u79fb\u52a8\u9996\u9875\uff0c\u67e5\u8be2\u652f\u51fa\u7ed3\u7b97\uff0c\u5206\u5305\u7ed3\u7b97c2\uff1a{}\uff0c\u8bbe\u5907\u5408\u540c\uff1a{}", (Object)data.getBigDecimal("settle"), (Object)data.getBigDecimal("contract"));
            } else {
                this.logger.info("\u79fb\u52a8\u9996\u9875\uff0c\u67e5\u8be2\u652f\u51fa\u7d2f\u8ba1\u5408\u540c\u4ed8\u6b3e\u51fa\u9519c2\uff1a{} ", (Object)c2);
            }
            JSONObject c5 = future5.get();
            if (c5.getInteger("code") == 0) {
                JSONObject data = c5.getJSONObject("data");
                contract = contract.add(data.getBigDecimal("contract"));
                settle = settle.add(data.getBigDecimal("settle"));
                this.logger.info("\u79fb\u52a8\u9996\u9875\uff0c\u67e5\u8be2\u652f\u51fa\u7ed3\u7b97\uff0c\u5468\u8f6c\u6750\u7ed3\u7b97c5\uff1a{}\uff0c\u8bbe\u5907\u5408\u540c\uff1a{}", (Object)data.getBigDecimal("settle"), (Object)data.getBigDecimal("contract"));
            } else {
                this.logger.info("\u79fb\u52a8\u9996\u9875\uff0c\u67e5\u8be2\u652f\u51fa\u7d2f\u8ba1\u5408\u540c\u4ed8\u6b3e\u51fa\u9519c5\uff1a{} ", (Object)c5);
            }
            JSONObject c6 = future6.get();
            if (c6.getInteger("code") == 0) {
                JSONObject data = c6.getJSONObject("data");
                contract = contract.add(data.getBigDecimal("contract"));
                settle = settle.add(data.getBigDecimal("settle"));
                this.logger.info("\u79fb\u52a8\u9996\u9875\uff0c\u67e5\u8be2\u652f\u51fa\u7ed3\u7b97\uff0c\u5176\u4ed6\u5408\u540c\u7ed3\u7b97c6\uff1a{}\uff0c\u8bbe\u5907\u5408\u540c\uff1a{}", (Object)data.getBigDecimal("settle"), (Object)data.getBigDecimal("contract"));
            } else {
                this.logger.info("\u79fb\u52a8\u9996\u9875\uff0c\u67e5\u8be2\u652f\u51fa\u7d2f\u8ba1\u5408\u540c\u4ed8\u6b3e\u51fa\u9519c6\uff1a{} ", (Object)c6);
            }
            JSONObject c3 = future3.get();
            if (c3.getInteger("code") == 0) {
                JSONObject data = c3.getJSONObject("data");
                invoiceTaxMny = invoiceTaxMny.add(data.getBigDecimal("invoiceTaxMny"));
                this.logger.info("\u79fb\u52a8\u9996\u9875\uff0c\u67e5\u8be2\u652f\u51fa\u5408\u540c\u6536\u7968c3\uff1a{} ", (Object)data.getBigDecimal("invoiceTaxMny"));
            } else {
                this.logger.info("\u79fb\u52a8\u9996\u9875\uff0c\u67e5\u8be2\u652f\u51fa\u7d2f\u8ba1\u5408\u540c\u4ed8\u6b3e\u51fa\u9519c3\uff1a{} ", (Object)c3);
            }
            JSONObject c4 = future4.get();
            if (c4.getInteger("code") == 0) {
                JSONObject data = c4.getJSONObject("data");
                payApplyAmount = payApplyAmount.add(data.getBigDecimal("payApplyAmount"));
                this.logger.info("\u79fb\u52a8\u9996\u9875\uff0c\u67e5\u8be2\u652f\u51fa\u7d2f\u8ba1\u5408\u540c\u4ed8\u6b3ec4\uff1a{} ", (Object)data.getBigDecimal("payApplyAmount"));
            } else {
                this.logger.info("\u79fb\u52a8\u9996\u9875\uff0c\u67e5\u8be2\u652f\u51fa\u7d2f\u8ba1\u5408\u540c\u4ed8\u6b3e\u51fa\u9519c4\uff1a{} ", (Object)c4);
            }
        }
        catch (Exception e) {
            this.logger.error("\u79fb\u52a8\u9996\u9875\uff0c\u67e5\u8be2\u652f\u51fa\u5408\u540c\u7edf\u8ba1\u51fa\u9519\uff1a{} ", (Object)e.getMessage());
            e.printStackTrace();
        }
        finally {
            threadPool.shutdown();
        }
        JSONObject back = new JSONObject();
        back.put("contract", (Object)contract);
        back.put("settle", (Object)settle);
        back.put("invoiceTaxMny", (Object)invoiceTaxMny);
        back.put("payApplyAmount", (Object)payApplyAmount);
        return back;
    }

    @PostMapping(value={"analysisContract"})
    public CommonResponse<BigDecimal> analysisContract(@RequestBody Map<String, Object> param) {
        Map<String, Object> result;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("dr", new Parameter("eq", (Object)BaseVO.DR_UNDELETE));
        queryParam.getParams().put("dependOnProject", new Parameter("eq", (Object)1));
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        if (null != param && null != param.get("projectIds") && CollectionUtils.isNotEmpty((Collection)((List)param.get("projectIds")))) {
            queryParam.getParams().put("projectId", new Parameter("in", param.get("projectIds")));
        }
        String dataStr = null != (result = this.materialContractService.countContractAmount(queryParam)).get("curAmount") ? result.get("curAmount").toString() : "0";
        BigDecimal total = new BigDecimal(dataStr);
        return CommonResponse.success((Object)total.divide(new BigDecimal(10000), 2, 4));
    }

    class PostDataCallable
    implements Callable<JSONObject> {
        private String url;
        private Object data;

        public PostDataCallable(String url, Object data) {
            this.data = data;
            this.url = url;
        }

        @Override
        public JSONObject call() throws Exception {
            System.out.println(InvocationInfoProxy.getTenantid());
            String responseStr = ReferHttpClientUtils.postByJson((String)this.url, (String)JSON.toJSONString((Object)this.data), (HttpServletRequest)request);
            System.out.println(responseStr);
            return JSONObject.parseObject((String)responseStr);
        }
    }
}

