package com.ejianc.business.material.service.impl;

import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.service.IMaterialContractDetailSubService;
import com.ejianc.business.material.service.IMaterialContractOtherCostSubService;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.service.IMaterialSupplementService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Service("materialSupplement")
public class MaterialSupplementBpmServiceImpl implements ICommonBusinessService {


    @Autowired
    IMaterialSupplementService materialSupplementService;


    @Autowired
    IMaterialContractService contractService;

    @Autowired
    IMaterialContractDetailSubService materialContractDetailSubService;

    @Autowired
    IMaterialContractOtherCostSubService materialContractOtherCostSubService;


    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;


    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        MaterialSupplementEntity supplementEntity = materialSupplementService.selectById(billId);
        MaterialContractEntity contractEntity = contractService.selectById(supplementEntity.getMainContractId());

        BigDecimal contractMny = contractEntity.getAmountWithTax() == null ? BigDecimal.ZERO : contractEntity.getAmountWithTax();
        BigDecimal contractTaxMny = contractEntity.getAmountWithoutTax() == null ? BigDecimal.ZERO : contractEntity.getAmountWithoutTax();
        BigDecimal supplementcontractMny = supplementEntity.getAmountWithTax() == null ? BigDecimal.ZERO : supplementEntity.getAmountWithTax();
        BigDecimal supplementcontractTaxMny = supplementEntity.getAmountWithoutTax() == null ? BigDecimal.ZERO : supplementEntity.getAmountWithoutTax();
        contractEntity.setAmountWithTax(contractMny.add(supplementcontractMny));
        contractEntity.setAmountWithoutTax(contractTaxMny.add(supplementcontractTaxMny));
        contractEntity.setTaxFee(contractEntity.getAmountWithTax().subtract(contractEntity.getAmountWithoutTax()));
        contractService.updateById(contractEntity);

        List<MaterialSupplementDetailSubEntity> listdetail = supplementEntity.getMaterialDetailList();

        //复制补充协议的子表到 合同子表   只涉及有金额的子表
        if (CollectionUtils.isNotEmpty(listdetail)) {
            List<MaterialContractDetailSubEntity> rentdetails = new ArrayList<>();
            listdetail.forEach(e -> {
                MaterialContractDetailSubEntity detailEntity = BeanMapper.map(e, MaterialContractDetailSubEntity.class);
                detailEntity.setSrcSupplementFlag(1);
                detailEntity.setSrcSupplementDetailId(e.getId());
                detailEntity.setSrcSupplementId(billId);
                detailEntity.setMaterialContractId(supplementEntity.getMainContractId());
                detailEntity.setId(null);
                detailEntity.setCreateUserCode(null);
                detailEntity.setCreateTime(null);
                detailEntity.setUpdateTime(null);
                detailEntity.setUpdateUserCode(null);
                rentdetails.add(detailEntity);
            });
            materialContractDetailSubService.saveBatch(rentdetails);
        }

        List<MaterialSupplementOtherCostSubEntity> otherCostList = supplementEntity.getOtherCostList();
        if (CollectionUtils.isNotEmpty(otherCostList)) {
            List<MaterialContractOtherCostSubEntity> feeetail = new ArrayList<>();
            otherCostList.forEach(e -> {
                MaterialContractOtherCostSubEntity feeEntity = BeanMapper.map(e, MaterialContractOtherCostSubEntity.class);
                feeEntity.setSrcSupplementFlag(1);
                feeEntity.setSrcSupplementDetailId(e.getId());
                feeEntity.setSrcSupplementId(billId);
                feeEntity.setMaterialContractId(supplementEntity.getMainContractId());
                feeEntity.setId(null);
                feeEntity.setCreateUserCode(null);
                feeEntity.setCreateTime(null);
                feeEntity.setUpdateTime(null);
                feeEntity.setUpdateUserCode(null);
                feeetail.add(feeEntity);
            });
            materialContractOtherCostSubService.saveBatch(feeetail);
        }
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error("补充协议暂不支持回退功能!");
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
