/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.pub.vo.PubWarnQueryVO;
import com.ejianc.business.finance.vo.PayMnyWarnVO;
import com.ejianc.business.material.controller.SqlParam;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceMnyWarnVO;
import com.ejianc.business.tax.vo.InvoicePubWarnQueryVO;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/materialContractWarn/"})
public class MaterialContractWarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PC_URL = "/ejc-material-frontend/#/materialContract/cards?id=";
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private ITenantApi tenantApi;
    @Autowired
    private IMaterialContractService materialContractService;
    @Autowired
    private IPayContractApi payContractApi;
    @Autowired
    private IInvoiceApi invoiceApi;

    @PostMapping(value={"execute"})
    public CommonResponse<String> execute(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList ignoreTenantIds = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray((String)jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        this.logger.info("\u5ffd\u7565\u79df\u6237\u5217\u8868\uff1a{}", ignoreTenantIds);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        CommonResponse tenantResp = this.tenantApi.getAllValidTenantId();
        if (!tenantResp.isSuccess()) {
            this.logger.error("\u6267\u884c\u7269\u8d44\u5408\u540c\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff1a{}", (Object)tenantResp.getMsg());
            return CommonResponse.error((String)"\u6267\u884c\u7269\u8d44\u5408\u540c\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff01");
        }
        List tenantIds = (List)tenantResp.getData();
        if (CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u7269\u8d44\u5408\u540c\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        tenantIds.removeAll(ignoreTenantIds);
        if (CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u7269\u8d44\u5408\u540c\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<SqlParam> sqlParamList = new ArrayList<SqlParam>();
        Object warnInfo = null;
        List warnParamList = null;
        ArrayList<Long> customTenantIds = new ArrayList<Long>();
        for (Object param : billParams) {
            if (ignoreTenantIds.contains(Long.valueOf(param.getString("tenantId")))) continue;
            warnParamList = BeanMapper.mapList((Iterable)param.getJSONArray("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(param.getString("warnLevel"));
                p.setTenantId(Long.valueOf(param.getString("tenantId")));
                p.setValue(p.getValue() / 100.0);
                sqlParamList.add(p);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }
        tenantIds.removeAll(customTenantIds);
        Object defaultParam = null;
        for (Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray((String)defaultWarnInfo.getString("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);
                p.setValue(p.getValue() / 100.0);
                sqlParamList.add(p);
            }
        }
        List<Map<String, Object>> result = this.materialContractService.queryAllWarnContracts(sqlParamList);
        if (CollectionUtils.isEmpty(result)) {
            this.logger.error("\u6267\u884c\u7269\u8d44\u5408\u540c\u9884\u8b66\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5408\u540c\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        return this.sendWarnToTask(this.transToWarnVO(result, defaultWarnInfo), defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"executeInvoicePayWarn"})
    public CommonResponse<String> executeInvoicePayWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList ignoreTenantIds = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray((String)jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        this.logger.info("\u5ffd\u7565\u79df\u6237\u5217\u8868\uff1a{}", ignoreTenantIds);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        CommonResponse tenantResp = this.tenantApi.getAllValidTenantId();
        if (!tenantResp.isSuccess()) {
            this.logger.error("\u6267\u884c\u7269\u8d44\u5408\u540c\u4ed8\u6b3e\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff1a{}", (Object)tenantResp.getMsg());
            return CommonResponse.error((String)"\u6267\u884c\u7269\u8d44\u5408\u540c\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff01");
        }
        List tenantIds = (List)tenantResp.getData();
        if (CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u7269\u8d44\u5408\u540c\u4ed8\u6b3e\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        tenantIds.removeAll(ignoreTenantIds);
        if (CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u7269\u8d44\u5408\u540c\u4ed8\u6b3e\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<Object> sqlParamList = new ArrayList<Object>();
        Object warnInfo = null;
        List warnParamList = null;
        ArrayList<Long> customTenantIds = new ArrayList<Long>();
        for (Object param : billParams) {
            if (ignoreTenantIds.contains(Long.valueOf(param.getString("tenantId")))) continue;
            warnParamList = BeanMapper.mapList((Iterable)param.getJSONArray("parameters"), SqlParam.class);
            for (Object p : warnParamList) {
                ((SqlParam)p).setWarnLevel(param.getString("warnLevel"));
                ((SqlParam)p).setTenantId(Long.valueOf(param.getString("tenantId")));
                ((SqlParam)p).setValue(((SqlParam)p).getValue() / 100.0);
                sqlParamList.add(p);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }
        tenantIds.removeAll(customTenantIds);
        Object defaultParam = null;
        for (Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray((String)defaultWarnInfo.getString("parameters"), SqlParam.class);
            for (Object p : warnParamList) {
                ((SqlParam)p).setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                ((SqlParam)p).setTenantId(tenantId);
                ((SqlParam)p).setValue(((SqlParam)p).getValue() / 100.0);
                sqlParamList.add(p);
            }
        }
        ArrayList<EarlyWarnTransVO> warnTransVOS = new ArrayList<EarlyWarnTransVO>();
        HashMap<Long, SqlParam> paramMap = new HashMap<Long, SqlParam>();
        ArrayList<Long> tenantidList = new ArrayList<Long>();
        for (SqlParam sqlParam : sqlParamList) {
            paramMap.put(sqlParam.getTenantId(), sqlParam);
            tenantidList.add(sqlParam.getTenantId());
        }
        PubWarnQueryVO pubWarnQueryVO = new PubWarnQueryVO();
        pubWarnQueryVO.setContractType(Integer.valueOf(4));
        pubWarnQueryVO.setTenantIds(tenantidList);
        CommonResponse commonResponse = this.payContractApi.warnPayMny(pubWarnQueryVO);
        if (commonResponse.isSuccess() && !((Map)commonResponse.getData()).isEmpty()) {
            Map payMap = (Map)commonResponse.getData();
            InvoicePubWarnQueryVO invoicePubWarnQueryVO = new InvoicePubWarnQueryVO();
            invoicePubWarnQueryVO.setContractType(Integer.valueOf(4));
            invoicePubWarnQueryVO.setTenantIds(tenantidList);
            CommonResponse invoiceResponse = this.invoiceApi.getWarnInvoiceMny(invoicePubWarnQueryVO);
            Map invoiceMap = (Map)invoiceResponse.getData();
            for (String key : payMap.keySet()) {
                BigDecimal overMny;
                PayMnyWarnVO payWarnVO = (PayMnyWarnVO)payMap.get(key);
                SqlParam param = (SqlParam)paramMap.get(payWarnVO.getTenantId());
                BigDecimal invoiceMny = BigDecimal.ZERO;
                if (null != invoiceMap && invoiceMap.containsKey(key)) {
                    invoiceMny = ((InvoiceMnyWarnVO)invoiceMap.get(key)).getSumInvoiceMny();
                }
                if ((overMny = payWarnVO.getSumPayMny().multiply(new BigDecimal(param.getValue())).subtract(invoiceMny)).compareTo(BigDecimal.ZERO) < 0) continue;
                warnTransVOS.add(this.margeInvoicePayToWarnVO(payWarnVO, invoiceMny, payWarnVO.getSumPayMny().multiply(new BigDecimal(param.getValue())), param, defaultWarnInfo));
            }
        }
        return this.sendWarnToTask(warnTransVOS, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"executePayWarn"})
    public CommonResponse<String> executePayWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList ignoreTenantIds = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray((String)jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        this.logger.info("\u5ffd\u7565\u79df\u6237\u5217\u8868\uff1a{}", ignoreTenantIds);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        CommonResponse tenantResp = this.tenantApi.getAllValidTenantId();
        if (!tenantResp.isSuccess()) {
            this.logger.error("\u6267\u884c\u7269\u8d44\u5408\u540c\u4ed8\u6b3e\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff1a{}", (Object)tenantResp.getMsg());
            return CommonResponse.error((String)"\u6267\u884c\u7269\u8d44\u5408\u540c\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff01");
        }
        List tenantIds = (List)tenantResp.getData();
        if (CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u7269\u8d44\u5408\u540c\u4ed8\u6b3e\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        tenantIds.removeAll(ignoreTenantIds);
        if (CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u7269\u8d44\u5408\u540c\u4ed8\u6b3e\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<SqlParam> sqlParamList = new ArrayList<SqlParam>();
        Object warnInfo = null;
        List warnParamList = null;
        ArrayList<Long> customTenantIds = new ArrayList<Long>();
        for (Object param : billParams) {
            if (ignoreTenantIds.contains(Long.valueOf(param.getString("tenantId")))) continue;
            warnParamList = BeanMapper.mapList((Iterable)param.getJSONArray("parameters"), SqlParam.class);
            for (SqlParam sqlParam : warnParamList) {
                sqlParam.setWarnLevel(param.getString("warnLevel"));
                sqlParam.setTenantId(Long.valueOf(param.getString("tenantId")));
                sqlParam.setValue(sqlParam.getValue() / 100.0);
                sqlParamList.add(sqlParam);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }
        tenantIds.removeAll(customTenantIds);
        Object defaultParam = null;
        for (Object tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray((String)defaultWarnInfo.getString("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId((Long)tenantId);
                p.setValue(p.getValue() / 100.0);
                sqlParamList.add(p);
            }
        }
        ArrayList<Long> tenantAllIds = new ArrayList<Long>();
        for (SqlParam sqlParam : sqlParamList) {
            tenantAllIds.add(sqlParam.getTenantId());
        }
        List<MaterialContractVO> result = this.materialContractService.queryWarnContracts(tenantAllIds);
        if (CollectionUtils.isEmpty(result)) {
            this.logger.error("\u6267\u884c\u7269\u8d44\u5408\u540c\u4ed8\u6b3e\u5927\u4e8e\u5408\u540c\u91d1\u989d\u9884\u8b66\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5408\u540c\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<EarlyWarnTransVO> arrayList = new ArrayList<EarlyWarnTransVO>();
        HashMap<Long, SqlParam> paramMap = new HashMap<Long, SqlParam>();
        ArrayList<Long> tenantidList = new ArrayList<Long>();
        for (SqlParam sqlParam : sqlParamList) {
            paramMap.put(sqlParam.getTenantId(), sqlParam);
            tenantidList.add(sqlParam.getTenantId());
        }
        PubWarnQueryVO pubWarnQueryVO = new PubWarnQueryVO();
        pubWarnQueryVO.setContractType(Integer.valueOf(4));
        pubWarnQueryVO.setTenantIds(tenantidList);
        CommonResponse commonResponse = this.payContractApi.warnMaterialPayMny(pubWarnQueryVO);
        if (commonResponse.isSuccess() && !((Map)commonResponse.getData()).isEmpty()) {
            Map payMap = (Map)commonResponse.getData();
            for (MaterialContractVO materialContractVO : result) {
                for (String key : payMap.keySet()) {
                    if (!(materialContractVO.getTenantId() + "@" + materialContractVO.getId()).equals(key)) continue;
                    BigDecimal amountWithTax = materialContractVO.getAmountWithTax();
                    PayMnyWarnVO payMnyWarnVO = (PayMnyWarnVO)payMap.get(key);
                    SqlParam param = (SqlParam)paramMap.get(materialContractVO.getTenantId());
                    BigDecimal sumPayMny = payMnyWarnVO.getSumPayMny();
                    BigDecimal overMny = sumPayMny.subtract(amountWithTax.multiply(new BigDecimal(param.getValue())));
                    if (overMny.compareTo(BigDecimal.ZERO) < 0) continue;
                    arrayList.add(this.margePrePayToWarnVO(payMnyWarnVO, sumPayMny, amountWithTax.multiply(new BigDecimal(param.getValue())), param, defaultWarnInfo, materialContractVO.getAmountWithTax(), materialContractVO.getOrgId(), materialContractVO.getOrgName()));
                }
            }
        }
        return this.sendWarnToTask(arrayList, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"executePrePayWarn"})
    public CommonResponse<String> executePrePayWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList ignoreTenantIds = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray((String)jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        this.logger.info("\u5ffd\u7565\u79df\u6237\u5217\u8868\uff1a{}", ignoreTenantIds);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        CommonResponse tenantResp = this.tenantApi.getAllValidTenantId();
        if (!tenantResp.isSuccess()) {
            this.logger.error("\u6267\u884c\u7269\u8d44\u5408\u540c\u4ed8\u6b3e\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff1a{}", (Object)tenantResp.getMsg());
            return CommonResponse.error((String)"\u6267\u884c\u7269\u8d44\u5408\u540c\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff01");
        }
        List tenantIds = (List)tenantResp.getData();
        if (CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u7269\u8d44\u5408\u540c\u4ed8\u6b3e\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        tenantIds.removeAll(ignoreTenantIds);
        if (CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u7269\u8d44\u5408\u540c\u4ed8\u6b3e\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<SqlParam> sqlParamList = new ArrayList<SqlParam>();
        Object warnInfo = null;
        List warnParamList = null;
        ArrayList<Long> customTenantIds = new ArrayList<Long>();
        for (Object param : billParams) {
            if (ignoreTenantIds.contains(Long.valueOf(param.getString("tenantId")))) continue;
            warnParamList = BeanMapper.mapList((Iterable)param.getJSONArray("parameters"), SqlParam.class);
            for (SqlParam sqlParam : warnParamList) {
                sqlParam.setWarnLevel(param.getString("warnLevel"));
                sqlParam.setTenantId(Long.valueOf(param.getString("tenantId")));
                sqlParam.setValue(sqlParam.getValue() / 100.0);
                sqlParamList.add(sqlParam);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }
        tenantIds.removeAll(customTenantIds);
        Object defaultParam = null;
        for (Object tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray((String)defaultWarnInfo.getString("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId((Long)tenantId);
                p.setValue(p.getValue() / 100.0);
                sqlParamList.add(p);
            }
        }
        ArrayList<Long> tenantAllIds = new ArrayList<Long>();
        for (SqlParam sqlParam : sqlParamList) {
            tenantAllIds.add(sqlParam.getTenantId());
        }
        List<MaterialContractVO> result = this.materialContractService.queryWarnPrePayContracts(tenantAllIds);
        if (CollectionUtils.isEmpty(result)) {
            this.logger.error("\u6267\u884c\u7269\u8d44\u5408\u540c\u4ed8\u6b3e\u5927\u4e8e\u5408\u540c\u91d1\u989d\u9884\u8b66\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5408\u540c\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<EarlyWarnTransVO> arrayList = new ArrayList<EarlyWarnTransVO>();
        HashMap<Long, SqlParam> paramMap = new HashMap<Long, SqlParam>();
        ArrayList<Long> tenantidList = new ArrayList<Long>();
        for (SqlParam sqlParam : sqlParamList) {
            paramMap.put(sqlParam.getTenantId(), sqlParam);
            tenantidList.add(sqlParam.getTenantId());
        }
        PubWarnQueryVO pubWarnQueryVO = new PubWarnQueryVO();
        pubWarnQueryVO.setContractType(Integer.valueOf(4));
        pubWarnQueryVO.setTenantIds(tenantidList);
        CommonResponse commonResponse = this.payContractApi.warnMaterialPrePayMny(pubWarnQueryVO);
        if (commonResponse.isSuccess() && !((Map)commonResponse.getData()).isEmpty()) {
            Map payMap = (Map)commonResponse.getData();
            for (MaterialContractVO materialContractVO : result) {
                for (String key : payMap.keySet()) {
                    if (!(materialContractVO.getTenantId() + "@" + materialContractVO.getId()).equals(key)) continue;
                    BigDecimal amountWithTax = materialContractVO.getAmountWithTax();
                    PayMnyWarnVO payMnyWarnVO = (PayMnyWarnVO)payMap.get(key);
                    BigDecimal offSetMny = materialContractVO.getOffSetMny();
                    SqlParam param = (SqlParam)paramMap.get(materialContractVO.getTenantId());
                    BigDecimal sumPayMny = payMnyWarnVO.getSumPayMny();
                    BigDecimal subtractMny = sumPayMny.subtract(offSetMny);
                    BigDecimal overMny = subtractMny.subtract(amountWithTax.multiply(new BigDecimal(param.getValue())));
                    if (overMny.compareTo(BigDecimal.ZERO) < 0) continue;
                    arrayList.add(this.margePrePayToWarnVO(payMnyWarnVO, subtractMny, amountWithTax.multiply(new BigDecimal(param.getValue())), param, defaultWarnInfo, materialContractVO.getAmountWithTax(), materialContractVO.getOrgId(), materialContractVO.getOrgName()));
                }
            }
        }
        return this.sendWarnToTask(arrayList, defaultWarnInfo.getLong("warnSetId"));
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenter(warnList, warnId);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    private List<EarlyWarnTransVO> transToWarnVO(List<Map<String, Object>> result, JSONObject defaultWarnInfo) {
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for (Map<String, Object> m : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName((null != defaultWarnInfo.get((Object)"categoryName") ? defaultWarnInfo.get((Object)"categoryName").toString() + " - " : "") + m.get("contractCode").toString());
            vo.setPcTitle("\u7269\u8d44\u5408\u540c");
            vo.setPcUrl(PC_URL + m.get("contractId").toString());
            vo.setOrgId(Long.valueOf(m.get("orgId").toString()));
            vo.setOrgName(m.get("orgName").toString());
            vo.setSourceId(m.get("contractId").toString());
            vo.setTenantId(Long.valueOf(m.get("tenantId").toString()));
            vo.setWarnLevel(m.get("warnLevel").toString());
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", m.get("contractName").toString()).replaceAll("#contractSettlementAmt#", df.format(new BigDecimal(m.get("contractSettlementAmt").toString()))).replaceAll("#contractAmt#", df.format(new BigDecimal(m.get("contractAmt").toString()))).replaceAll("#percent#", m.get("percent").toString()).replaceAll("#overAmt#", df.format(new BigDecimal(m.get("overAmt").toString()))));
            resp.add(vo);
        }
        this.logger.info("\u53d1\u9001\u9884\u8b66\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(resp));
        return resp;
    }

    private EarlyWarnTransVO margeInvoicePayToWarnVO(PayMnyWarnVO payWarnVO, BigDecimal invoiceMny, BigDecimal overMny, SqlParam param, JSONObject defaultWarnInfo) {
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName((null != defaultWarnInfo.get((Object)"categoryName") ? defaultWarnInfo.get((Object)"categoryName").toString() + " - " : "") + payWarnVO.getContractCode());
        vo.setPcTitle("\u7269\u8d44\u91c7\u8d2d\u5408\u540c");
        vo.setPcUrl(PC_URL + payWarnVO.getContractId().toString());
        vo.setOrgId(payWarnVO.getOrgId());
        vo.setOrgName(payWarnVO.getOrgName());
        vo.setSourceId(payWarnVO.getContractId().toString());
        vo.setTenantId(payWarnVO.getTenantId());
        vo.setWarnLevel(param.getWarnLevel());
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#orgName#", payWarnVO.getOrgName()).replaceAll("#contractName#", payWarnVO.getContractName()).replaceAll("#sumInvoiceTaxMny#", df.format(invoiceMny)).replaceAll("#sumPayMny#", df.format(payWarnVO.getSumPayMny())).replaceAll("#percent#", String.valueOf(param.getValue() * 100.0)).replaceAll("#overMny#", df.format(overMny)));
        return vo;
    }

    private EarlyWarnTransVO margePrePayToWarnVO(PayMnyWarnVO payWarnVO, BigDecimal invoiceMny, BigDecimal overMny, SqlParam param, JSONObject defaultWarnInfo, BigDecimal contractMny, Long orgId, String orgName) {
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName((null != defaultWarnInfo.get((Object)"categoryName") ? defaultWarnInfo.get((Object)"categoryName").toString() + " - " : "") + payWarnVO.getContractCode());
        vo.setPcTitle("\u7269\u8d44\u91c7\u8d2d\u5408\u540c");
        vo.setPcUrl(PC_URL + payWarnVO.getContractId().toString());
        vo.setOrgId(orgId);
        vo.setOrgName(orgName);
        vo.setSourceId(payWarnVO.getContractId().toString());
        vo.setTenantId(payWarnVO.getTenantId());
        vo.setWarnLevel(param.getWarnLevel());
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", payWarnVO.getContractName()).replaceAll("#contractPayAmt#", df.format(payWarnVO.getSumPayMny())).replaceAll("#contractAmt#", df.format(contractMny)).replaceAll("#percent#", String.valueOf(param.getValue() * 100.0)).replaceAll("#overAmt#", df.format(overMny)));
        return vo;
    }

    private BigDecimal getBigDecimal(Object obj) {
        return null == obj ? BigDecimal.ZERO : new BigDecimal(obj.toString());
    }
}

