package com.ejianc.business.plan.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.bean.ContractChangeEntity;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.business.plan.bean.*;
import com.ejianc.business.plan.service.IMaterialMasterPlanService;
import com.ejianc.business.plan.service.IMaterialMasterPlanSubService;
import com.ejianc.business.plan.service.IPlanChangeHisService;
import com.ejianc.business.plan.service.IPlanChangeService;
import com.ejianc.business.plan.vo.MaterialMasterPlanVO;
import com.ejianc.business.plan.vo.PlanChangeSubVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2021/3/6 14:57
 */
@Service("planChange")
public class PlanChangeBpmCallbackServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPlanChangeService planChangeService;

    @Autowired
    private IPlanChangeHisService planChangeHisService;

    @Autowired
    private IMaterialMasterPlanService materialMasterPlanService;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IMaterialMasterPlanSubService materialMasterPlanSubService;

    @Autowired
    private SessionManager sessionManager;

    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("总计划变更提交审批回调--billId:{}, state: {}", billId, state);

        //此处billId即为单据Id
        PlanChangeEntity entity = planChangeService.selectById(billId);
        UserContext userContext = sessionManager.getUserContext();
        //设置提交人信息
        entity.setCommitDate(new Date());
        entity.setCommitUserCode(userContext.getUserCode());
        entity.setCommitUserName(userContext.getUserName());

        planChangeService.saveOrUpdate(entity, false);

        return CommonResponse.success("总计划变更提交审批回调成功！");
    }

    /**
     * 审批完成回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("总计划变更审批完成回调处理：billId: {}, state: {}", billId, state);

        PlanChangeEntity planChange = planChangeService.selectById(billId);
        MaterialMasterPlanEntity newPlanEntity = null;
        MaterialMasterPlanEntity oldPlan = materialMasterPlanService.selectById(planChange.getSourcePlanId());

        if(state == BillStateEnum.COMMITED_STATE.getBillStateCode()) {
            //直审时记录
            UserContext userContext = sessionManager.getUserContext();
            //设置提交人信息
            planChange.setCommitDate(new Date());
            planChange.setCommitUserCode(userContext.getUserCode());
            planChange.setCommitUserName(userContext.getUserName());
        }
        //设置总计划变更单据生效时间
        planChange.setEffectiveDate(new Date());

      //1、复制合同信息到合同记录
        PlanChangeHisEntity recordEntity = BeanMapper.map(oldPlan, PlanChangeHisEntity.class);
        logger.info("总计划变更审批完成回调, 总计划变更信息：【{}】, 变更前总计划信息: 【{}】", JSON.toJSONString(planChange), JSON.toJSONString(oldPlan));

        //设置总计划Id
        recordEntity.setSourcePlanId(oldPlan.getId());
        //Id置为空
        recordEntity.setId(null);
        if(CollectionUtils.isNotEmpty(recordEntity.getMaterialSubList())) {
            recordEntity.getMaterialSubList().stream().forEach(detail -> {
                detail.setTargetId(detail.getId());
                detail.setId(null);
            });
        }

        //设置编制人等信息
        recordEntity.setCreateUserCode(planChange.getCreateUserCode());
        recordEntity.setCreateTime(planChange.getCreateTime());
        recordEntity.setCreateUserName(planChange.getCreateUserName());
        recordEntity.setModifyUserName(planChange.getModifyUserName());
        recordEntity.setUpdateTime(planChange.getUpdateTime());
        recordEntity.setUpdateUserCode(planChange.getUpdateUserCode());
        recordEntity.setCommitDate(planChange.getCommitDate());
        recordEntity.setCommitUserCode(planChange.getCommitUserCode());
        recordEntity.setCommitUserName(planChange.getCommitUserName());
        recordEntity.setEffectiveDate(planChange.getEffectiveDate());

        recordEntity.setOriginalPlanAmt(oldPlan.getTotalPlanAmt());
        recordEntity.setTotalPlanAmt(planChange.getTotalPlanAmt());
        recordEntity.setChangePlanId(oldPlan.getCurChangingPlanId());

        recordEntity.setChangeUserName(planChange.getChangeUserName());
        recordEntity.setChangeReason(planChange.getChangeReason());
        if(null == recordEntity.getTotalPlanAmt()) {
            recordEntity.setTotalPlanAmt(BigDecimal.ZERO.setScale(8));
        }
        if(null == recordEntity.getOriginalPlanAmt()) {
            recordEntity.setOriginalPlanAmt(BigDecimal.ZERO.setScale(8));
        }
        recordEntity.setChangeAmount(recordEntity.getTotalPlanAmt().subtract(recordEntity.getOriginalPlanAmt()));
        if(recordEntity.getOriginalPlanAmt().compareTo(BigDecimal.ZERO) == 0) {
            recordEntity.setChangeRatio(0d);
        } else {
            recordEntity.setChangeRatio(recordEntity.getChangeAmount().divide(recordEntity.getOriginalPlanAmt(), 8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue());
        }

        //总计划变更记录保存
        planChangeHisService.saveOrUpdate(recordEntity, false);

        planChangeService.saveOrUpdate(planChange, false);

        //修改总计划字段
        newPlanEntity = BeanMapper.map(planChange, MaterialMasterPlanEntity.class);
        //变更状态-已变更
        newPlanEntity.setChangeState(MaterialMasterPlanVO.PLAN_CHANGE_STATE_CHANGED);

        //清空当前变更计划id
        newPlanEntity.setCurChangingPlanId(null);
        //合同初始创建信息
        newPlanEntity.setCreateUserName(oldPlan.getCreateUserName());
        newPlanEntity.setCreateUserCode(oldPlan.getCreateUserCode());
        newPlanEntity.setCreateTime(oldPlan.getCreateTime());
        newPlanEntity.setId(oldPlan.getId());
        newPlanEntity.setVersion(oldPlan.getVersion());
        newPlanEntity.setChangeVersion(planChange.getChangeVersion());

        //子表信息设置
        List<Long> delDetailIds = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(planChange.getMaterialSubList())) {
            List<MaterialMasterPlanSubEntity> list = new ArrayList<>();
            MaterialMasterPlanSubEntity tmp = null;
            Map<Long, Integer> map = oldPlan.getMaterialSubList().stream().collect(Collectors.toMap(MaterialMasterPlanSubEntity::getId, MaterialMasterPlanSubEntity::getVersion));

            for(PlanChangeSubEntity detail : planChange.getMaterialSubList()) {
                tmp = BeanMapper.map(detail, MaterialMasterPlanSubEntity.class);
                if(null != detail.getTargetId()) {
                    tmp.setId(detail.getTargetId());
                    tmp.setVersion(map.get(detail.getTargetId()));
                    if(PlanChangeSubVO.CHANGE_TYPE_DEL.equals(detail.getChangeType())) {
                        //终止项删除
                        delDetailIds.add(detail.getTargetId());
                    } else {
                        tmp.setRowState("update");
                        list.add(tmp);
                    }
                } else {
                    tmp.setRowState("add");
                    list.add(tmp);
                }
            }

            newPlanEntity.setMaterialSubList(list);
        }

        //删除已有子表
        if(CollectionUtils.isNotEmpty(delDetailIds)) {
            materialMasterPlanSubService.delByPlanIdAndDetailIds(delDetailIds, oldPlan.getId());
        }

        if(materialMasterPlanService.saveOrUpdate(newPlanEntity, false)) {
            return CommonResponse.success("回调业务处理成功！");
        }
        return CommonResponse.success("回调业务处理失败！");
    }

    /**
     * 弃审
     *
     * @param billId
     * @param state
     * @param billTypeCode
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("总计划变更弃审回调处理：billId: {}, state: {}", billId, state);
        PlanChangeEntity planChange = planChangeService.selectById(billId);

        //清空总计划变更提交人信息
        planChange.setCommitUserName(null);
        planChange.setCommitUserCode(null);
        planChange.setCommitDate(null);

        QueryWrapper<PlanChangeHisEntity> hisQuery = new QueryWrapper<>();
        hisQuery.eq("change_plan_id", billId);
        PlanChangeHisEntity hisEntity = planChangeHisService.getOne(hisQuery);

        if(null != hisEntity) {
            //数据恢复至审批完成前的数据状态
            MaterialMasterPlanEntity newPlanEntity = null;
            MaterialMasterPlanEntity oldPlan = materialMasterPlanService.selectById(planChange.getSourcePlanId());

            logger.info("总计划执行弃审数据恢复逻辑，当前数据【{}】，待恢复数据【{}】", oldPlan, hisEntity);
            //数据恢复
            newPlanEntity = BeanMapper.map(hisEntity, MaterialMasterPlanEntity.class);
            newPlanEntity.setCurChangingPlanId(hisEntity.getChangePlanId());
            //恢复创建人等信息
            newPlanEntity.setCreateUserName(oldPlan.getCreateUserName());
            newPlanEntity.setCreateUserCode(oldPlan.getCreateUserCode());
            newPlanEntity.setCreateTime(oldPlan.getCreateTime());
            newPlanEntity.setId(oldPlan.getId());
            newPlanEntity.setVersion(oldPlan.getVersion());
            newPlanEntity.setChangeVersion(planChange.getChangeVersion());

            //变更状态-变更中
            newPlanEntity.setChangeState(MaterialMasterPlanVO.PLAN_CHANGE_STATE_CHANGING);
            //总计划金额
            newPlanEntity.setTotalPlanAmt(hisEntity.getOriginalPlanAmt());
            newPlanEntity.setChangeVersion(planChange.getChangeVersion() - 1);

            //子表信息设置
            List<Long> delDetailIds = new ArrayList<>();
            if(CollectionUtils.isNotEmpty(planChange.getMaterialSubList())) {
                List<MaterialMasterPlanSubEntity> list = new ArrayList<>();
                MaterialMasterPlanSubEntity tmp = null;
                Map<Long, Integer> map = oldPlan.getMaterialSubList().stream().collect(Collectors.toMap(MaterialMasterPlanSubEntity::getId, MaterialMasterPlanSubEntity::getVersion));

                for(PlanChangeSubEntity detail : planChange.getMaterialSubList()) {
                    tmp = BeanMapper.map(detail, MaterialMasterPlanSubEntity.class);

                    if(null != detail.getTargetId()) {
                        tmp.setVersion(map.get(detail.getTargetId()));
                        tmp.setId(detail.getTargetId());
                        if(detail.getChangeType().equals(PlanChangeSubVO.CHANGE_TYPE_ADD)) {
                            //删除新增项
                            delDetailIds.add(detail.getId());
                        } else {
                            list.add(tmp);
                        }
                    } else {
                        //删除新增项
                        delDetailIds.add(detail.getId());
                    }
                }

                newPlanEntity.setMaterialSubList(list);
            }

            //删除已有子表
            if(CollectionUtils.isNotEmpty(delDetailIds)) {
                materialMasterPlanSubService.delByPlanIdAndDetailIds(delDetailIds, oldPlan.getId());
            }

            //删除变更记录
            planChangeHisService.removeById(hisEntity.getId(), false);

            materialMasterPlanService.saveOrUpdate(newPlanEntity, false);
        }

        if(planChangeService.saveOrUpdate(planChange, false)) {
            return CommonResponse.success("回调业务处理成功！");
        }
        return CommonResponse.success("总计划变更弃审回调处理成功！");
    }

    /**
     *
     * @param billId
     * @param state
     * @return
     */
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        if(state != BillStateEnum.COMMITED_STATE.getBillStateCode()) {
            CommonResponse.success("有审批流程的变更总计划无法执行该操作！");
        }
        return CommonResponse.success("总计划变更弃审回调处理成功！");
    }

    /**
     * 撤回
     *
     * @param billId
     * @param state
     * @param billTypeCode
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        logger.info("总计划变更撤回回调处理：billId: {}, state: {}", billId, state);
        PlanChangeEntity planChange = planChangeService.selectById(billId);

        //清空总计划变更提交人信息
        planChange.setCommitUserName(null);
        planChange.setCommitUserCode(null);
        planChange.setCommitDate(null);

        planChangeService.saveOrUpdate(planChange, false);

        return CommonResponse.success("总计划变更撤回回调处理成功！");
    }
}
