package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * @author CJ
 * @Description: 物资合同-其他费用
 * @date 2020/6/9 14:30
 */
@TableName(value = "ejc_material_materialcontract_othercost")
public class MaterialContractOtherCostSubEntity extends BaseEntity {

    private static final long serialVersionUID = -4824971671199442366L;
    /**
     * 费用名称
     */
    @TableField(value = "cost_name")
    private String costName;

    /**
     * 金额
     */
    @TableField(value = "cost_amount")
    private BigDecimal costAmount;
    /**
     * 金额(含税)
     */
    @TableField(value = "tax_cost_amount")
    private BigDecimal taxCostAmount;
    /**
     * 税率
     */
    @TableField(value = "tax_othercost_rate")
    private BigDecimal taxOthercostRate;
    /**
     * 税额
     */
    @TableField(value = "tax_othercost")
    private BigDecimal taxOthercost;

    /**
     * 备注
     */
    @TableField(value = "cost_remark")
    private String costRemark;

    /**
     * 物资合同Id
     */
    @TableField(value = "material_contract_id")
    private Long materialContractId;

    @TableField(value="src_supplement_flag")
    private java.lang.Integer srcSupplementFlag; // 是否来源补充协议(1:是，0：否)
    @TableField(value="src_supplement_id")
    private java.lang.Long srcSupplementId; // 来源补充协议主表ID
    @TableField(value="src_supplement_detail_id")
    private java.lang.Long srcSupplementDetailId; // 来源补充协议明细ID

    public BigDecimal getTaxCostAmount() {
        return taxCostAmount;
    }

    public void setTaxCostAmount(BigDecimal taxCostAmount) {
        this.taxCostAmount = taxCostAmount;
    }

    public BigDecimal getTaxOthercostRate() {
        return taxOthercostRate;
    }

    public void setTaxOthercostRate(BigDecimal taxOthercostRate) {
        this.taxOthercostRate = taxOthercostRate;
    }

    public BigDecimal getTaxOthercost() {
        return taxOthercost;
    }

    public void setTaxOthercost(BigDecimal taxOthercost) {
        this.taxOthercost = taxOthercost;
    }

    public Integer getSrcSupplementFlag() {
        return srcSupplementFlag;
    }

    public void setSrcSupplementFlag(Integer srcSupplementFlag) {
        this.srcSupplementFlag = srcSupplementFlag;
    }

    public Long getSrcSupplementId() {
        return srcSupplementId;
    }

    public void setSrcSupplementId(Long srcSupplementId) {
        this.srcSupplementId = srcSupplementId;
    }

    public Long getSrcSupplementDetailId() {
        return srcSupplementDetailId;
    }

    public void setSrcSupplementDetailId(Long srcSupplementDetailId) {
        this.srcSupplementDetailId = srcSupplementDetailId;
    }

    public String getCostName() {
        return costName;
    }

    public void setCostName(String costName) {
        this.costName = costName;
    }

    public BigDecimal getCostAmount() {
        return costAmount;
    }

    public void setCostAmount(BigDecimal costAmount) {
        this.costAmount = costAmount;
    }

    public String getCostRemark() {
        return costRemark;
    }

    public void setCostRemark(String costRemark) {
        this.costRemark = costRemark;
    }

    public Long getMaterialContractId() {
        return materialContractId;
    }

    public void setMaterialContractId(Long materialContractId) {
        this.materialContractId = materialContractId;
    }
}

