package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.UseApplyEntity;
import com.ejianc.business.material.bean.UseApplySubEntity;
import com.ejianc.business.material.service.IUseApplyService;
import com.ejianc.business.material.service.IUseApplySubService;
import com.ejianc.business.material.vo.UseApplyExportVO;
import com.ejianc.business.material.vo.UseApplySubVO;
import com.ejianc.business.material.vo.UseApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.ReferVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/6 用料申请控制器
 * @Description UseApplyController
 */

@Controller
@RequestMapping("/apply/")
public class UseApplyController   implements Serializable {

    private static final long serialVersionUID = 2779265683203439571L;
    private static final String BILL_CODE = "materialUseApply";

    @Autowired
    IUseApplyService iUseApplyService;
    @Autowired
    IUseApplySubService iUseApplySubService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/1  保存修改
     * @Description saveOrUpdate
     * @Param [vo]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.UseApplyVO>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<UseApplyVO> saveOrUpdate(@RequestBody UseApplyVO vo) {
        UseApplyEntity entity = BeanMapper.map(vo, UseApplyEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        iUseApplyService.saveOrUpdate(entity,false);
        UseApplyVO backVo = BeanMapper.map(entity, UseApplyVO.class);
        return CommonResponse.success("保存或修改单据成功！",backVo);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/2 查询详情
     * @Description queryDetail
     * @Param [id]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.UseApplyVO>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<UseApplyVO> queryDetail(Long id) {
        UseApplyEntity entity = iUseApplyService.selectById(id);
        UseApplyVO vo = BeanMapper.map(entity, UseApplyVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<UseApplyVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("applyPerson");
        /** 数据隔离 本下 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        return CommonResponse.success("查询列表数据成功！",iUseApplyService.queryForList(param,false));
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/2 查询打印数据
     * @Description queryPrint
     * @Param [id]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
     */
    @RequestMapping(value = "/queryPrint", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("UseApply",iUseApplyService.selectById(id));
        return CommonResponse.success("查询打印数据成功！",json);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/2 删除
     * @Description delete
     * @Param [vos]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<UseApplyVO> vos) {
        iUseApplyService.removeByIds(vos.stream().map(UseApplyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    /**
     * @Author mrsir_wxp
     * @Date 2020/6/2 导出
     * @Description excelExport
     * @Param [queryParam, response]
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.setPageIndex(0);
        queryParam.setPageSize(10000);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("applyPerson");

        /** 数据隔离 本下 */
        queryParam.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<UseApplyVO>  voPage = iUseApplyService.queryForList(queryParam,false);
        List<UseApplyVO> list = voPage.getRecords();
        List<UseApplyExportVO> exportVOS = new ArrayList<>();
        list.forEach(vo -> {
            UseApplyExportVO exportVO = BeanMapper.map(vo, UseApplyExportVO.class);
            exportVO.setCreateTime(DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss",vo.getCreateTime()));
            if(vo.getPlanEnterDate()!=null){
                exportVO.setPlanEnterDate(DateFormatUtil.formatDate("yyyy-MM-dd",vo.getPlanEnterDate()));
            }
            exportVOS.add(exportVO);
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", exportVOS);
        ExcelExport.getInstance().export("useApplyListExport.xlsx", beans, response);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/12  用料申请参照树
     * @Description referTree
     * @Param [pageNumber, pageSize]
     * @Return java.util.List<java.util.Map<java.lang.String,java.lang.Object>>
     */
    @RequestMapping(value = "/referTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> referTree(@RequestParam Integer pageNumber,@RequestParam Integer pageSize,
                                               @RequestParam String condition
                                               ) {
        if(StringUtils.isEmpty(condition) || !condition.contains("orgId")){
            throw new BusinessException("查询参数不正确！");
        }
        JSONObject conditionJson = JSONObject.parseObject(condition);
        Long orgId = conditionJson.getLong("orgId");
        Long projectId = conditionJson.getLong("projectId");
        QueryParam queryParam = new QueryParam();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("createTime", "desc");
        if(null != projectId) {
            queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        }
        queryParam.setOrderMap(orderMap);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("applyPerson");
        /** 数据隔离 参数组织orgId本下 */
        queryParam.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 已提交的数据 或者 审批通过的数据 */
        queryParam.getParams().put("billState",new Parameter(QueryParam.IN,Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode())));
        List<UseApplyEntity> dataList = iUseApplyService.queryList(queryParam, false);
        List<Map> resultMapList = new ArrayList<>();
        Map map = null;
        for(UseApplyEntity entity:dataList) {
            map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", entity.getId());
            map.put("name", entity.getName());
            map.put("code", entity.getBillCode());
            map.put("parentId", null);
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }


    /**
     * @Author mrsir_wxp
     * @Date 2020/6/12 用料申请子表参照数据
     * @Description refdata
     * @Param [pageNumber, pageSize, relyCondition, relyNode, searchText]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage<com.ejianc.business.material.vo.UseApplySubVO>>
     */
    @RequestMapping(value = "/refSubData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<UseApplySubVO>> refdata(@RequestParam Integer pageNumber,
                                                  @RequestParam Integer pageSize,
                                                  String relyCondition,
                                                  String relyNode ,
                                                  String searchText,
                                                  @RequestParam(required = false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("model");
        fuzzyFields.add("unit");
        Map<String, Parameter>  param = queryParam.getParams();
        if(!StringUtils.isEmpty(relyCondition)){
            param.put("pid",new Parameter(QueryParam.EQ,relyCondition.split("=")[1]));
        }else {
            throw new BusinessException("请选择申请单！");
        }

    	if(StringUtils.isNotBlank(searchObject)){
    		JSONObject search = JSONObject.parseObject(searchObject);
    		for(String key : search.keySet()){
    			queryParam.getParams().put(key,new Parameter(QueryParam.LIKE,search.get(key).toString()));
    		}
    		/*if(search.get("materialTypeName")!=null){
    			queryParam.getParams().put("materialTypeName",new Parameter(QueryParam.LIKE,search.get("materialTypeName").toString()));
    		}
    		if(search.get("materialName")!=null){
    			queryParam.getParams().put("materialName",new Parameter(QueryParam.LIKE,search.get("materialName").toString()));
    		}
    		if(search.get("model")!=null){
    			queryParam.getParams().put("model",new Parameter(QueryParam.LIKE,search.get("model").toString()));
    		}
    		if(search.get("unit")!=null){
    			queryParam.getParams().put("unit",new Parameter(QueryParam.LIKE,search.get("unit").toString()));
    		}*/
    	}
        IPage<UseApplySubEntity> pageData = iUseApplySubService.queryPage(queryParam, false);
        IPage<UseApplySubVO> voPage = null;
        if(pageData!=null){
            voPage = new Page<>();
            voPage.setCurrent(pageData.getCurrent());
            voPage.setPages(pageData.getPages());
            voPage.setTotal(pageData.getTotal());
            voPage.setSize(queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList(pageData.getRecords(),UseApplySubVO.class));
        }
        return CommonResponse.success("查询数表参照成功", voPage);
    }

}
