package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.bean.OutStoreEntity;
import com.ejianc.business.material.bean.PurchaseSettlementEntity;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.service.IPurchaseSettlementService;
import com.ejianc.business.qdsz.nc.vo.ApBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.ApBillVO;
import com.ejianc.business.utils.NCUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@Service("purchaseSettlement")
public class PurchaseSettlementBpmService implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IPurchaseSettlementService iPurchaseSettlementService;
    @Autowired
    IInstoreService iInstoreService;
    @Autowired
    IOutStoreService iOutStoreService;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private ICostDetailApi iCostDetailApi;

    @Autowired
    private NCUtil ncUtil;
    
    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("结算 提交前回调 billId="+ billId+" state="+ state+" billTypeCode="+  billTypeCode);
        return CommonResponse.success();
    }

    /**
     * 提交完回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("结算 提交完回调 billId="+ billId+" state="+ state+" billTypeCode="+  billTypeCode);
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("结算 终审审核前回调 billId="+ billId+" state="+ state+" billTypeCode="+  billTypeCode);
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    @Transactional
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("结算 终审审核完回调 billId="+ billId+" state="+ state+" billTypeCode="+  billTypeCode);
        PurchaseSettlementEntity purchaseSettlementEntity = iPurchaseSettlementService.selectById(billId);
        if(purchaseSettlementEntity==null){
            return CommonResponse.error("没有找到相关结算单！");
        }
        if(ListUtil.isNotEmpty(purchaseSettlementEntity.getMaterialDetails())){
            List<String> outStoreIds = new ArrayList<>();
            List<String> inStoreIds = new ArrayList<>();
            purchaseSettlementEntity.getMaterialDetails().forEach(p->{
                //入库单
                if(Objects.equals("2",p.getSourceType())){
                    if(!inStoreIds.contains(p.getSourceMainId())){
                        inStoreIds.add(p.getSourceMainId());
                    }
                }
                //出库单
                if(Objects.equals("4",p.getSourceType())){
                    if(!outStoreIds.contains(p.getSourceMainId())){
                        outStoreIds.add(p.getSourceMainId());
                    }
                }
            });
            StringBuffer msg = new StringBuffer("");
            inStoreIds.forEach(s -> {
                InstoreEntity entity = iInstoreService.selectById(Long.parseLong(s));
                if(entity!=null){
                    entity.setSettlementFlag(1);
                    iInstoreService.saveOrUpdate(entity,false);
                }else {
                    msg.append("1");
                }
            });
            if(msg.length()>0){
                 return CommonResponse.error("没有找到结算单中入库单信息！");
            }
            StringBuffer msg1 = new StringBuffer("");
            outStoreIds.forEach(s -> {
                OutStoreEntity entity = iOutStoreService.selectById(Long.parseLong(s));
                if(entity!=null){
                    entity.setSettlementFlag(1);
                    iOutStoreService.saveOrUpdate(entity,false);
                }else {
                    msg1.append("1");
                }
            });
            if(msg1.length()>0){
                return CommonResponse.error("没有找到结算单中退货单信息！");
            }
        }
        if(purchaseSettlementEntity.getBillState()==BillStateEnum.COMMITED_STATE.getBillStateCode()||purchaseSettlementEntity.getBillState()==BillStateEnum.PASSED_STATE.getBillStateCode()){
            iPurchaseSettlementService.processCost(purchaseSettlementEntity);
        }
        iPurchaseSettlementService.saveOrUpdate(purchaseSettlementEntity);
        
        ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(purchaseSettlementEntity.getProjectId())).get(0);
        if (Objects.equals("1", project.getIndustryIntegrationFlag())) {
            // 推送NC传应付单凭证
            this.pushToNC(purchaseSettlementEntity);
        }
        
        return CommonResponse.success();
    }

    /**
     * 推送NC传应付单凭证
     * @param entity
     */
    private void pushToNC(PurchaseSettlementEntity entity) {
        ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        ApBillVO vo = this.transferToNCVO(entity, project); // 转换成NCVO

//        List<Long> orgIds = ncUtil.validateDaoQiaoOrg(project.getOrgId(), project.getInvoiceMainCategory());
        List<Long> orgIds = ncUtil.validateInvoiceMainOrg(project.getOrgId(), project.getMainOrgId());
        String sourceIds = "";
        for (Long orgId : orgIds) {
            OrgVO orgVO = ncUtil.queryOrgById(orgId);
            vo.setPk_org(orgVO.getCode());
            String sourceId = ncUtil.postByJson(JSONObject.toJSON(vo).toString()); // 调用NC传凭证接口
            sourceIds += sourceId + ",";
        }
        sourceIds = sourceIds.substring(0, sourceIds.length() - 1);
        
        LambdaUpdateWrapper<PurchaseSettlementEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.set(PurchaseSettlementEntity::getSourceId, sourceIds);// 保存来源主键
        wrapper.eq(PurchaseSettlementEntity::getId, entity.getId());
        iPurchaseSettlementService.update(wrapper);
    }

    /**
     * 转换成NCVO
     * @param entity
     * @return
     */
    private ApBillVO transferToNCVO(PurchaseSettlementEntity entity, ProjectRegisterVO project){
        logger.info("----应付单传凭证开始:");
//        ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        OrgVO orgVO = ncUtil.queryOrgById(project.getOrgId());
        SupplierVO supplierVO = ncUtil.querySupplierById(entity.getSupplierId());

        ApBillVO vo = new ApBillVO();
        vo.setBusitype("apbill"); // 业务标识(默认apbill)
        vo.setTradetype("F1-Cxx-001"); // 交易类型
        vo.setPk_project(String.valueOf(entity.getProjectId())); // 项目主键
        vo.setDef12(String.valueOf(entity.getId())); // PM单据主键
        vo.setDef19(entity.getBillCode()); // PM单据编码
        vo.setPk_org(orgVO.getCode()); // 财务组织编码
        vo.setDef1(false); // 是否有计量证书，必输，默认false
        vo.setDef2(ncUtil.getInvoiceMainDefCode(project.getInvoiceMainCategory())); // 开票主体分类 0-PMDA06001,1-PMDA06002
        vo.setDef3(ncUtil.getTaxWayDefCode(project.getTaxWay())); // 计税方式 0-01,1-02
        if (StringUtils.isEmpty(project.getAreaCode())) {
            throw new BusinessException("项目-区域不能为空！");
        }
        vo.setDef5(project.getAreaCode()); // 区域编码
        vo.setPk_supplier(String.valueOf(entity.getSupplierId()));// 供应商主键
//        vo.setPk_supplier(String.valueOf(supplierVO.getCategoryId()));// 供应商分类主键
        vo.setDef6(supplierVO.getInsideOrgId() != null);// 是否内部单位 true/false
        vo.setPk_dept(String.valueOf(project.getDeptId()));// 部门主键
        vo.setDef16(entity.getSettlementStatus()); // 结算状态
        vo.setDef7(ncUtil.getTaxRateDefCode(entity.getTaxRate())); // 税率
        vo.setDef13(project.getExcuteConstructState()); // 是否执行建造合同 0-否，1-是
        vo.setDef20(ncUtil.getWebSite("ejc-material-frontend/#/purchaseSettlement/card?id=" + entity.getId()));// 外部访问url
        vo.setDef21("BT200610000000004");// 单据类型

        List<ApBillDetailVO> detailVOS = new ArrayList<>();
        ApBillDetailVO detailVO = new ApBillDetailVO();
        detailVO.setPk_project(String.valueOf(entity.getProjectId()));
        detailVO.setNotaxmny(entity.getCurrentSettlementAmount());
        detailVO.setLocal_mny(entity.getCurrentSettlementAmountTax());
        detailVO.setTaxmny(entity.getTax());
        detailVOS.add(detailVO);

        vo.setDetail(detailVOS);
        return  vo;
    }
    
    
    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("结算 弃审前事件回调 billId="+ billId+" state="+ state+" billTypeCode="+  billTypeCode);
        PurchaseSettlementEntity purchaseSettlementEntity = iPurchaseSettlementService.selectById(billId);
        if(purchaseSettlementEntity==null){
            return CommonResponse.error("没有找到相关结算单！");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("contractId",new Parameter(QueryParam.EQ,purchaseSettlementEntity.getContractId()));
        param.getParams().put("orgId",new Parameter(QueryParam.EQ,purchaseSettlementEntity.getOrgId()));
        param.getParams().put("createTime",new Parameter(QueryParam.GT,purchaseSettlementEntity.getCreateTime()));
        List<PurchaseSettlementEntity> entities = iPurchaseSettlementService.queryList(param,false);
        if(ListUtil.isNotEmpty(entities)){
            return CommonResponse.error("该结算单结算之后存在单据编号为【"+entities.get(0).getBillCode()+"】的相同合同和组织的结算单，无法撤回！");
        }
        CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()) {
            logger.info("物资合同结算单据【billId-{}】,【billTypeCode-{}】执行撤回操作校验结束，未通过校验，原因：{}",billId,billTypeCode, resp.getMsg());
            return CommonResponse.error(resp.getMsg());
        }
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("结算 弃审后事件回调 billId="+ billId+" state="+ state+" billTypeCode="+  billTypeCode);
        PurchaseSettlementEntity purchaseSettlementEntity = iPurchaseSettlementService.selectById(billId);
        if(purchaseSettlementEntity==null){
            return CommonResponse.error("没有找到相关结算单！");
        }
        if(ListUtil.isNotEmpty(purchaseSettlementEntity.getMaterialDetails())){
            List<String> inStoreIds = new ArrayList<>();
            List<String> outStoreIds = new ArrayList<>();
            purchaseSettlementEntity.getMaterialDetails().forEach(p->{
                //入库单
                if(Objects.equals("2",p.getSourceType())){
                    if(!inStoreIds.contains(p.getSourceMainId())){
                        inStoreIds.add(p.getSourceMainId());
                    }
                }
                //出库单
                if(Objects.equals("4",p.getSourceType())){
                    if(!outStoreIds.contains(p.getSourceMainId())){
                        outStoreIds.add(p.getSourceMainId());
                    }
                }
            });
            StringBuffer msg = new StringBuffer("");
            inStoreIds.forEach(s -> {
                InstoreEntity entity = iInstoreService.selectById(Long.parseLong(s));
                if(entity!=null){
                    entity.setSettlementFlag(0);
                    iInstoreService.saveOrUpdate(entity,false);
                }else {
                    msg.append("1");
                }
            });
            if(msg.length()>0){
                return CommonResponse.error("没有找到结算单中入库单信息！");
            }
            StringBuffer msg1 = new StringBuffer("");
            outStoreIds.forEach(s -> {
                OutStoreEntity entity = iOutStoreService.selectById(Long.parseLong(s));
                if(entity!=null){
                    entity.setSettlementFlag(0);
                    iOutStoreService.saveOrUpdate(entity,false);
                }else {
                    msg1.append("1");
                }
            });
            if(msg1.length()>0){
                return CommonResponse.error("没有找到结算单中退货单信息！");
            }
        }
        iCostDetailApi.deleteSubject(purchaseSettlementEntity.getId());
        purchaseSettlementEntity.setRelationFlag("0");
        iPurchaseSettlementService.saveOrUpdate(purchaseSettlementEntity);

        if (StringUtils.isNotEmpty(purchaseSettlementEntity.getSourceId())) {
            String sourceId = purchaseSettlementEntity.getSourceId();
            String[] split = sourceId.split(",");
            for (String s : split) {
                JSONObject json = new JSONObject();
                json.put("busitype", "deleteapbill");
                json.put("pk_bill", s);
                ncUtil.postByJson(json.toJSONString());// 调用NC传凭证接口
            }

            // 清空来源主键
            LambdaUpdateWrapper<PurchaseSettlementEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.set(PurchaseSettlementEntity::getSourceId, null);
            wrapper.eq(PurchaseSettlementEntity::getId, billId);
            iPurchaseSettlementService.update(wrapper);
        }
        
        return CommonResponse.success();
    }
}
