/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSON;
import com.ejianc.business.material.bean.ContractChangeEntity;
import com.ejianc.business.material.bean.ContractDetailChangeEntity;
import com.ejianc.business.material.bean.ContractRecordEntity;
import com.ejianc.business.material.bean.MaterialContractDetailSubEntity;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.bean.MaterialContractItemEntity;
import com.ejianc.business.material.bean.MaterialContractOtherCostSubEntity;
import com.ejianc.business.material.bean.MaterialContractStageEntity;
import com.ejianc.business.material.service.IContractChangeService;
import com.ejianc.business.material.service.IContractRecordService;
import com.ejianc.business.material.service.IMaterialContractDetailSubService;
import com.ejianc.business.material.service.IMaterialContractItemService;
import com.ejianc.business.material.service.IMaterialContractOtherCostSubService;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.service.IMaterialContractStageService;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractChange")
public class ContractChangeBpmCallbackServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractChangeService contractChangeService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMaterialContractService materialContractService;
    @Autowired
    private IContractRecordService contractRecordService;
    @Autowired
    private IMaterialContractOtherCostSubService contractOtherCostSubService;
    @Autowired
    private IMaterialContractStageService contractStageService;
    @Autowired
    private IMaterialContractItemService materialContractItemService;
    @Autowired
    private IMaterialContractDetailSubService materialContractDetailSubService;
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5408\u540c\u53d8\u66f4\u63d0\u4ea4\u5ba1\u6279\u56de\u8c03--billId:{}, state: {}", (Object)billId, (Object)state);
        ContractChangeEntity entity = (ContractChangeEntity)((Object)this.contractChangeService.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        entity.setCommitDate(new Date());
        entity.setCommitUserCode(userContext.getUserCode());
        entity.setCommitUserName(userContext.getUserName());
        MaterialContractEntity contract = (MaterialContractEntity)((Object)this.materialContractService.selectById(entity.getMaterialContractId()));
        contract.setChangeBillState(state);
        this.contractChangeService.saveOrUpdate((Object)entity, false);
        this.materialContractService.saveOrUpdate((Object)contract, false);
        return CommonResponse.success((String)"\u5408\u540c\u63d0\u4ea4\u5ba1\u6279\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5408\u540c\u53d8\u66f4\u5ba1\u6279\u5b8c\u6210\u56de\u8c03\u5904\u7406\uff1abillId: {}, state: {}", (Object)billId, (Object)state);
        ContractChangeEntity changeEntity = (ContractChangeEntity)((Object)this.contractChangeService.selectById(billId));
        MaterialContractEntity newContractEntity = null;
        MaterialContractEntity contractEntity = (MaterialContractEntity)((Object)this.materialContractService.selectById(changeEntity.getMaterialContractId()));
        ContractRecordEntity recordEntity = (ContractRecordEntity)((Object)BeanMapper.map((Object)((Object)contractEntity), ContractRecordEntity.class));
        this.logger.info("\u5408\u540c\u53d8\u66f4\u5ba1\u6279\u5b8c\u6210\u56de\u8c03, \u5408\u540c\u53d8\u66f4\u4fe1\u606f\uff1a\u3010{}\u3011, \u53d8\u66f4\u524d\u5408\u540c\u4fe1\u606f: \u3010{}\u3011", (Object)JSON.toJSONString((Object)((Object)changeEntity)), (Object)JSON.toJSONString((Object)((Object)contractEntity)));
        recordEntity.setMaterialContractId(contractEntity.getId());
        recordEntity.setId(null);
        if (CollectionUtils.isNotEmpty(recordEntity.getMaterialDetailList())) {
            recordEntity.getMaterialDetailList().stream().forEach(detail -> {
                detail.setContractDetailId(detail.getId());
                detail.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getContractItemList())) {
            recordEntity.getContractItemList().stream().forEach(item -> {
                item.setContractItemId(item.getId());
                item.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getOtherCostList())) {
            recordEntity.getOtherCostList().stream().forEach(cost -> {
                cost.setContractOtherCostId(cost.getId());
                cost.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getStageList())) {
            recordEntity.getStageList().stream().forEach(s -> {
                s.setContractOtherCostId(s.getId());
                s.setId(null);
            });
        }
        recordEntity.setEffectiveDate(new Date());
        recordEntity.setCreateUserCode(changeEntity.getCreateUserCode());
        recordEntity.setCreateTime(changeEntity.getCreateTime());
        recordEntity.setCreateUserName(changeEntity.getCreateUserName());
        recordEntity.setModifyUserName(changeEntity.getModifyUserName());
        recordEntity.setUpdateTime(changeEntity.getUpdateTime());
        recordEntity.setUpdateUserCode(changeEntity.getUpdateUserCode());
        recordEntity.setCommitDate(changeEntity.getCommitDate());
        recordEntity.setCommitUserCode(changeEntity.getCommitUserCode());
        recordEntity.setCommitUserName(changeEntity.getCommitUserName());
        recordEntity.setChangeAmount(ComputeUtil.safeSub((BigDecimal)recordEntity.getChangingTaxMny(), (BigDecimal)recordEntity.getAmountWithTax()));
        recordEntity.setChangeRatio(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)recordEntity.getChangeAmount(), (BigDecimal)recordEntity.getAmountWithTax()), (BigDecimal)new BigDecimal("100")).doubleValue());
        recordEntity.setChangeReason(changeEntity.getChangeReason());
        this.contractRecordService.saveOrUpdate((Object)recordEntity, false);
        changeEntity.setEffectiveDate(new Date());
        this.contractChangeService.saveOrUpdate((Object)changeEntity, false);
        newContractEntity = (MaterialContractEntity)((Object)BeanMapper.map((Object)((Object)changeEntity), MaterialContractEntity.class));
        newContractEntity.setChangeState(MaterialContractVO.CONTRACT_CHANGE_STATE_CHANGED);
        newContractEntity.setBeforeChangeMny(newContractEntity.getAmountWithoutTax());
        newContractEntity.setBeforeChangeTaxMny(newContractEntity.getAmountWithTax());
        newContractEntity.setChangingTaxMny(null);
        newContractEntity.setChangingMny(null);
        newContractEntity.setChangeBillState(null);
        newContractEntity.setId(contractEntity.getId());
        newContractEntity.setVersion(contractEntity.getVersion());
        newContractEntity.setBillState(changeEntity.getBillState());
        newContractEntity.setCreateUserName(contractEntity.getCreateUserName());
        newContractEntity.setCreateUserCode(contractEntity.getCreateUserCode());
        newContractEntity.setCreateTime(contractEntity.getCreateTime());
        newContractEntity.setSupplementFlag(0);
        ArrayList<Long> delDetailIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(changeEntity.getMaterialDetailList())) {
            ArrayList<MaterialContractDetailSubEntity> list = new ArrayList<MaterialContractDetailSubEntity>();
            MaterialContractDetailSubEntity tmp = null;
            Map<Long, Integer> map = contractEntity.getMaterialDetailList().stream().collect(Collectors.toMap(BaseEntity::getId, BaseEntity::getVersion));
            for (ContractDetailChangeEntity detail2 : changeEntity.getMaterialDetailList()) {
                tmp = (MaterialContractDetailSubEntity)((Object)BeanMapper.map((Object)((Object)detail2), MaterialContractDetailSubEntity.class));
                if (null != detail2.getContractDetailId()) {
                    tmp.setId(detail2.getContractDetailId());
                    tmp.setVersion(map.get(detail2.getContractDetailId()));
                    if (detail2.getChangeType().equals("6")) {
                        delDetailIds.add(detail2.getContractDetailId());
                        continue;
                    }
                    list.add(tmp);
                    continue;
                }
                list.add(tmp);
            }
            newContractEntity.setMaterialDetailList(list);
        }
        if (CollectionUtils.isNotEmpty(changeEntity.getStageList())) {
            changeEntity.getStageList().stream().forEach(s -> s.setId(null));
            newContractEntity.setStageList(BeanMapper.mapList(changeEntity.getStageList(), MaterialContractStageEntity.class));
        }
        if (CollectionUtils.isNotEmpty(changeEntity.getOtherCostList())) {
            changeEntity.getOtherCostList().stream().forEach(cost -> cost.setId(null));
            newContractEntity.setOtherCostList(BeanMapper.mapList(changeEntity.getOtherCostList(), MaterialContractOtherCostSubEntity.class));
        }
        if (CollectionUtils.isNotEmpty(changeEntity.getContractItemList())) {
            Map<Long, Integer> map = contractEntity.getContractItemList().stream().collect(Collectors.toMap(BaseEntity::getId, BaseEntity::getVersion));
            changeEntity.getContractItemList().stream().filter(item -> null != item.getContractItemId()).forEach(item -> item.setId(null));
            newContractEntity.setContractItemList(BeanMapper.mapList(changeEntity.getContractItemList(), MaterialContractItemEntity.class));
        }
        this.contractStageService.deleteByContractId(changeEntity.getMaterialContractId());
        this.contractOtherCostSubService.deleteByContractId(changeEntity.getMaterialContractId());
        this.materialContractItemService.deleteByContractId(changeEntity.getMaterialContractId());
        if (CollectionUtils.isNotEmpty(delDetailIds)) {
            this.materialContractDetailSubService.removeByIds(delDetailIds);
        }
        if (this.materialContractService.saveOrUpdate((Object)newContractEntity, false)) {
            return CommonResponse.success((String)"\u56de\u8c03\u4e1a\u52a1\u5904\u7406\u6210\u529f\uff01");
        }
        return CommonResponse.success((String)"\u56de\u8c03\u4e1a\u52a1\u5904\u7406\u5931\u8d25\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7269\u8d44\u5408\u540c\u53d8\u66f4\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u64a4\u56de\u524d\u6821\u9a8c\uff01", (Object)billId, (Object)billTypeCode);
        ContractChangeEntity entity = (ContractChangeEntity)((Object)this.contractChangeService.selectById(billId));
        if (!BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode().equals(entity.getBillState())) {
            this.logger.info("\u7269\u8d44\u5408\u540c\u53d8\u66f4\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u64a4\u56de\u64cd\u4f5c\u6821\u9a8c\u7ed3\u675f\uff0c\u672a\u901a\u8fc7\u6821\u9a8c\uff0c\u539f\u56e0\uff1a\u5408\u540c\u53d8\u66f4\u5355\u636e\u53ea\u80fd\u5728\u63d0\u4ea4\u672a\u5ba1\u6279\u72b6\u6001\u4e0b\u624d\u80fd\u64a4\u56de\u6216\u5f03\u5ba1\uff01", (Object)billId, (Object)billTypeCode);
            return CommonResponse.error((String)"\u5408\u540c\u53d8\u66f4\u5355\u636e\u53ea\u80fd\u5728\u63d0\u4ea4\u672a\u5ba1\u6279\u72b6\u6001\u4e0b\u624d\u80fd\u6267\u884c\u6b64\u64cd\u4f5c\uff01");
        }
        return CommonResponse.success((String)"\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7269\u8d44\u5408\u540c\u53d8\u66f4\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u64a4\u56de\u64cd\u4f5c\uff01", (Object)billId, (Object)billTypeCode);
        ContractChangeEntity entity = (ContractChangeEntity)((Object)this.contractChangeService.selectById(billId));
        MaterialContractEntity contract = (MaterialContractEntity)((Object)this.materialContractService.selectById(entity.getMaterialContractId()));
        contract.setChangeBillState(state);
        this.materialContractService.saveOrUpdate((Object)contract, false);
        return CommonResponse.success((String)"\u5408\u540c\u63d0\u4ea4\u5ba1\u6279\u56de\u8c03\u6210\u529f\uff01");
    }
}

