package com.ejianc.business.material.vo;

import com.ejianc.business.material.bean.PurchaseSettlementInvoiceDetailEntity;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/10 采购结算单 主表
 * @Description PurchaseSettlementVO
 */
public class PurchaseSettlementRefVO extends BaseVO {
    /**
     * 单据状态
     */
    private Integer billState;

    /**
     * 结算编号
     */
    private String billCode;

    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 合同id
     */
    private Long contractId;

    /**
     * 合同采购方式
     */
    private String purchaseMethod;

    /**
     * 属于项目 ？ 1是，0不是
     */
    private String belongToProject;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 项目名称参照
     */
    private Long projectId;

    /**
     * 所属组织名称
     */
    private String orgName;

    /**
     * 所属组织参照
     */
    private Long orgId;

    /**
     * 结算日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settlementDate;

    /**
     * 本期结算金额（含税）
     */
    private BigDecimal currentSettlementAmountTax;

    /**
     * 累计预付款
     */
    private BigDecimal accumulatedAdvancePayment;

    /**
     * 本期冲抵金额
     */
    private BigDecimal offsetAmountInCurrentPeriod;

    /**
     * 剩余冲抵金额
     */
    private BigDecimal remainingOffsetAmount;

    /**
     * 备注
     */
    private String memo;

    /**
     * 编制人
     */
    private String creatorName;

    /**
     * 供应商id
     */
    private Long supplierId;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 合同金额
     */
    private BigDecimal contractAmount;

    /**
     * 税率
     */
    private BigDecimal taxRate;

    /**
     * 本期结算金额（不含税）
     */
    private BigDecimal currentSettlementAmount;

    /**
     * 税金
     */
    private BigDecimal tax;

    /**
     * 累计已结算金额
     */
    private BigDecimal settledAmount;

    /**
     * 已结算比例
     */
    private BigDecimal settledProportion;

    /**
     * 累计申请金额(资金返写)
     */
    private BigDecimal currentApplyAmount;

    /**
     * 剩余可以申请金额
     */
    private BigDecimal remainCanApplyAmount;

    /**
     * 已付金额(该合同截止到本期已付金额)
     */
    private BigDecimal currentPaidAmount;

    /**
     * 已付金额
     */
    private BigDecimal paidAmount;

    /**
     * 已付比例
     */
    private BigDecimal paidProportion;

    /**
     * 累计发票核销金额(无税)
     */
    private BigDecimal totalInvoiceVerifyMny;

    /**
     * 累计发票核销金额(含税)
     */
    private BigDecimal totalInvoiceVerifyTaxMny;
    
    /**
     * 已核销金额(无税)
     */
    private BigDecimal paidVerifyMny;

    /**
     * 已核销金额(含税)
     */
    private BigDecimal paidVerifyTaxMny;

    /**
     * 本次核销金额(无税)
     */
    private BigDecimal currentVerifyMny;

    /**
     * 本次核销金额(含税)
     */
    private BigDecimal currentVerifyTaxMny;
    
    /**
     * 税额
     */
    private BigDecimal verifyTaxMny;
    
    /**
     * 累计核销金额(无税)(含本次)
     */
    private BigDecimal currentTotalVerifyMny;

    /**
     * 累计核销金额(含税)(含本次)
     */
    private BigDecimal currentTotalVerifyTaxMny;
    
    private List<PurchaseSettlementMaterialDetailVO> materialDetails = new ArrayList<>();

    private List<PurchaseSettlementOtherFeeVO> feeEntities = new ArrayList<>();

    private List<PurchaseSettlementInvoiceDetailEntity> invoiceDetails = new ArrayList<>();
    
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @ReferSerialTransfer(referCode="materialContract")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getPurchaseMethod() {
        return purchaseMethod;
    }

    public void setPurchaseMethod(String purchaseMethod) {
        this.purchaseMethod = purchaseMethod;
    }

    public String getBelongToProject() {
        return belongToProject;
    }

    public void setBelongToProject(String belongToProject) {
        this.belongToProject = belongToProject;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Date getSettlementDate() {
        return settlementDate;
    }

    public void setSettlementDate(Date settlementDate) {
        this.settlementDate = settlementDate;
    }

    public BigDecimal getCurrentSettlementAmountTax() {
        return currentSettlementAmountTax;
    }

    public void setCurrentSettlementAmountTax(BigDecimal currentSettlementAmountTax) {
        this.currentSettlementAmountTax = currentSettlementAmountTax;
    }

    public BigDecimal getAccumulatedAdvancePayment() {
        return accumulatedAdvancePayment;
    }

    public void setAccumulatedAdvancePayment(BigDecimal accumulatedAdvancePayment) {
        this.accumulatedAdvancePayment = accumulatedAdvancePayment;
    }

    public BigDecimal getOffsetAmountInCurrentPeriod() {
        return offsetAmountInCurrentPeriod;
    }

    public void setOffsetAmountInCurrentPeriod(BigDecimal offsetAmountInCurrentPeriod) {
        this.offsetAmountInCurrentPeriod = offsetAmountInCurrentPeriod;
    }

    public BigDecimal getRemainingOffsetAmount() {
        return remainingOffsetAmount;
    }

    public void setRemainingOffsetAmount(BigDecimal remainingOffsetAmount) {
        this.remainingOffsetAmount = remainingOffsetAmount;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getCreatorName() {
        return creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BigDecimal getContractAmount() {
        return contractAmount;
    }

    public void setContractAmount(BigDecimal contractAmount) {
        this.contractAmount = contractAmount;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getCurrentSettlementAmount() {
        return currentSettlementAmount;
    }

    public void setCurrentSettlementAmount(BigDecimal currentSettlementAmount) {
        this.currentSettlementAmount = currentSettlementAmount;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public BigDecimal getSettledAmount() {
        return settledAmount;
    }

    public void setSettledAmount(BigDecimal settledAmount) {
        this.settledAmount = settledAmount;
    }

    public BigDecimal getSettledProportion() {
        return settledProportion;
    }

    public void setSettledProportion(BigDecimal settledProportion) {
        this.settledProportion = settledProportion;
    }

    public BigDecimal getCurrentApplyAmount() {
        return currentApplyAmount;
    }

    public void setCurrentApplyAmount(BigDecimal currentApplyAmount) {
        this.currentApplyAmount = currentApplyAmount;
    }

    public BigDecimal getRemainCanApplyAmount() {
        return remainCanApplyAmount;
    }

    public void setRemainCanApplyAmount(BigDecimal remainCanApplyAmount) {
        this.remainCanApplyAmount = remainCanApplyAmount;
    }

    public void setCurrentPaidAmount(BigDecimal currentPaidAmount) {
        this.currentPaidAmount = currentPaidAmount;
    }

    public void setPaidAmount(BigDecimal paidAmount) {
        this.paidAmount = paidAmount;
    }

    public void setPaidProportion(BigDecimal paidProportion) {
        this.paidProportion = paidProportion;
    }

    public BigDecimal getCurrentPaidAmount() {
        return currentPaidAmount;
    }

    public BigDecimal getPaidAmount() {
        return paidAmount;
    }

    public BigDecimal getPaidProportion() {
        return paidProportion;
    }

    public BigDecimal getTotalInvoiceVerifyMny() {
        return totalInvoiceVerifyMny;
    }

    public void setTotalInvoiceVerifyMny(BigDecimal totalInvoiceVerifyMny) {
        this.totalInvoiceVerifyMny = totalInvoiceVerifyMny;
    }

    public BigDecimal getTotalInvoiceVerifyTaxMny() {
        return totalInvoiceVerifyTaxMny;
    }

    public void setTotalInvoiceVerifyTaxMny(BigDecimal totalInvoiceVerifyTaxMny) {
        this.totalInvoiceVerifyTaxMny = totalInvoiceVerifyTaxMny;
    }

    public BigDecimal getPaidVerifyMny() {
        return paidVerifyMny;
    }

    public void setPaidVerifyMny(BigDecimal paidVerifyMny) {
        this.paidVerifyMny = paidVerifyMny;
    }

    public BigDecimal getPaidVerifyTaxMny() {
        return paidVerifyTaxMny;
    }

    public void setPaidVerifyTaxMny(BigDecimal paidVerifyTaxMny) {
        this.paidVerifyTaxMny = paidVerifyTaxMny;
    }

    public BigDecimal getCurrentVerifyMny() {
        return currentVerifyMny;
    }

    public void setCurrentVerifyMny(BigDecimal currentVerifyMny) {
        this.currentVerifyMny = currentVerifyMny;
    }

    public BigDecimal getCurrentVerifyTaxMny() {
        return currentVerifyTaxMny;
    }

    public void setCurrentVerifyTaxMny(BigDecimal currentVerifyTaxMny) {
        this.currentVerifyTaxMny = currentVerifyTaxMny;
    }

    public BigDecimal getVerifyTaxMny() {
        return verifyTaxMny;
    }

    public void setVerifyTaxMny(BigDecimal verifyTaxMny) {
        this.verifyTaxMny = verifyTaxMny;
    }

    public BigDecimal getCurrentTotalVerifyMny() {
        return currentTotalVerifyMny;
    }

    public void setCurrentTotalVerifyMny(BigDecimal currentTotalVerifyMny) {
        this.currentTotalVerifyMny = currentTotalVerifyMny;
    }

    public BigDecimal getCurrentTotalVerifyTaxMny() {
        return currentTotalVerifyTaxMny;
    }

    public void setCurrentTotalVerifyTaxMny(BigDecimal currentTotalVerifyTaxMny) {
        this.currentTotalVerifyTaxMny = currentTotalVerifyTaxMny;
    }

    public List<PurchaseSettlementMaterialDetailVO> getMaterialDetails() {
        return materialDetails;
    }

    public void setMaterialDetails(List<PurchaseSettlementMaterialDetailVO> materialDetails) {
        this.materialDetails = materialDetails;
    }

    public List<PurchaseSettlementOtherFeeVO> getFeeEntities() {
        return feeEntities;
    }

    public void setFeeEntities(List<PurchaseSettlementOtherFeeVO> feeEntities) {
        this.feeEntities = feeEntities;
    }

    public List<PurchaseSettlementInvoiceDetailEntity> getInvoiceDetails() {
        return invoiceDetails;
    }

    public void setInvoiceDetails(List<PurchaseSettlementInvoiceDetailEntity> invoiceDetails) {
        this.invoiceDetails = invoiceDetails;
    }

    public String getBillStateName() {
        return BillStateEnum.getEnumByStateCode(this.billState).getDescription();
    }

}
