package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/8 采购询比价 子表
 * @Description ComparePriceSubEntity
 */

@TableName("ejc_material_compare_price_sub")
public class ComparePriceSubEntity  extends BaseEntity {
    /**
     * 主表id
     */
    @TableField(value = "pid")
    private Long pid;

    /**
     * 物资分类名称
     */
    @TableField(value = "material_type_name")
    private String materialTypeName;


    /**
     * 物资分类id
     */
    @TableField(value = "material_type_id")
    private Long materialTypeId;

    /**
     * 物资名称
     */
    @TableField(value = "material_name")
    private String materialName;

    /**
     * 物资id
     */
    @TableField(value = "material_id")
    private Long materialId;

    /**
     * 规格型号
     */
    @TableField(value = "model")
    private String model;

    /**
     * 计量单位
     */
    @TableField(value = "unit")
    private String unit;

    /**
     * 数量
     */
    @TableField(value = "num")
    private BigDecimal num;


    @TableField(exist = false)
    private List<ComparePriceSelectedSupplierEntity> supplierEntities = new ArrayList<>();

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public List<ComparePriceSelectedSupplierEntity> getSupplierEntities() {
        return supplierEntities;
    }

    public void setSupplierEntities(List<ComparePriceSelectedSupplierEntity> supplierEntities) {
        this.supplierEntities = supplierEntities;
    }
}
