package com.ejianc.business.material.bean;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 物资合同补充协议-明细
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_materialcontract_detail")
public class MaterialSupplementDetailSubEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 物资分类Id
     */
    @TableField(value = "material_type_id")
    private Long materialTypeId;


    /**
     * 物资分类名称
     */
    @TableField(value = "material_type_name")
    private String materialTypeName;

    /**
     * 物资名称
     */
    @TableField(value = "material_name")
    private String materialName;

    /**
     * 规则/型号
     */
    @TableField(value = "spec")
    private String spec;

    /**
     * 计量单位
     */
    @TableField(value = "measure_unit")
    private String measureUnit;

    /**
     * 数量
     */
    @TableField(value = "count")
    private BigDecimal count;

    /**
     * 单价
     */
    @TableField(value = "unit_price")
    private BigDecimal unitPrice;
    /**
     * 单价(含税)
     */
    @TableField(value = "tax_unit_price")
    private BigDecimal taxUnitPrice;

    /**
     * 金额
     */
    @TableField(value = "total_amount")
    private BigDecimal totalAmount;
    /**
     * 金额(含税)
     */
    @TableField(value = "tax_total_amount")
    private BigDecimal taxTotalAmount;
    /**
     * 税额
     */
    @TableField(value = "tax_detail")
    private BigDecimal taxDetail;
    /**
     * 税率
     */
    @TableField(value = "tax_detail_rate")
    private BigDecimal taxDetailRate;

    /**
     * 备注
     */
    @TableField(value = "material_remark")
    private String materialRemark;

    /**
     * 物资来源类型：1-物料档案，2-用料申请，3-询价单
     */
    @TableField(value = "source_type")
    private String sourceType;

    /**
     * 物资来源单据Id
     */
    @TableField(value = "source_Id")
    private String sourceId;

    /**
     * 物资Id
     */
    @TableField(value = "material_id")
    private String materialId;

    /**
     * 物资合同Id
     */
    @TableField(value = "material_contract_id")
    private Long materialContractId;

    //其他字段
    /**
     * 变更项对应主表主键
     */
    @TableField(value = "change_id")
    private Long changeId;

    /**
     * 变更项子表主键Id
     */
    @TableField(value = "change_bid")
    private Long changBid;

    /**
     * 变更类型
     */
    @TableField(value = "change_type")
    private Integer changeType;

    @TableField(value="src_supplement_flag")
    private java.lang.Integer srcSupplementFlag; // 是否来源补充协议(1:是，0：否)
    @TableField(value="src_supplement_id")
    private java.lang.Long srcSupplementId; // 来源补充协议主表ID
    @TableField(value="src_supplement_detail_id")
    private java.lang.Long srcSupplementDetailId; // 来源补充协议明细ID

    public BigDecimal getTaxUnitPrice() {
        return taxUnitPrice;
    }

    public void setTaxUnitPrice(BigDecimal taxUnitPrice) {
        this.taxUnitPrice = taxUnitPrice;
    }

    public BigDecimal getTaxTotalAmount() {
        return taxTotalAmount;
    }

    public void setTaxTotalAmount(BigDecimal taxTotalAmount) {
        this.taxTotalAmount = taxTotalAmount;
    }

    public BigDecimal getTaxDetail() {
        return taxDetail;
    }

    public void setTaxDetail(BigDecimal taxDetail) {
        this.taxDetail = taxDetail;
    }

    public BigDecimal getTaxDetailRate() {
        return taxDetailRate;
    }

    public void setTaxDetailRate(BigDecimal taxDetailRate) {
        this.taxDetailRate = taxDetailRate;
    }

    public Integer getSrcSupplementFlag() {
        return srcSupplementFlag;
    }

    public void setSrcSupplementFlag(Integer srcSupplementFlag) {
        this.srcSupplementFlag = srcSupplementFlag;
    }

    public Long getSrcSupplementId() {
        return srcSupplementId;
    }

    public void setSrcSupplementId(Long srcSupplementId) {
        this.srcSupplementId = srcSupplementId;
    }

    public Long getSrcSupplementDetailId() {
        return srcSupplementDetailId;
    }

    public void setSrcSupplementDetailId(Long srcSupplementDetailId) {
        this.srcSupplementDetailId = srcSupplementDetailId;
    }

    public String getMaterialId() {
        return materialId;
    }

    public void setMaterialId(String materialId) {
        this.materialId = materialId;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getMeasureUnit() {
        return measureUnit;
    }

    public void setMeasureUnit(String measureUnit) {
        this.measureUnit = measureUnit;
    }

    public BigDecimal getCount() {
        return count;
    }

    public void setCount(BigDecimal count) {
        this.count = count;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getMaterialRemark() {
        return materialRemark;
    }

    public void setMaterialRemark(String materialRemark) {
        this.materialRemark = materialRemark;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Long getMaterialContractId() {
        return materialContractId;
    }

    public void setMaterialContractId(Long materialContractId) {
        this.materialContractId = materialContractId;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Long getChangBid() {
        return changBid;
    }

    public void setChangBid(Long changBid) {
        this.changBid = changBid;
    }

    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }
    
}
