package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/1  采购结算单 其他费用表
 * @Description PurchaseSettlementOtherFeeEntity
 */
@TableName("ejc_material_purchase_settlement_other_fee")
public class PurchaseSettlementOtherFeeEntity extends BaseEntity {

    private static final long serialVersionUID = 2779265683203439571L;

    /**
     * 主表id
     */
    @TableField(value = "pid")
    private Long pid;

    /**
     * 名称
     */
    @TableField(value = "name")
    private String name;

    /**
     * 金额
     */
    @TableField(value = "money")
    private BigDecimal money;

    /**
     * 备注
     */
    @TableField(value = "memo")
    private String memo;

    /**
     * 成本科目主键
     */
    @TableField(value = "fee_subject_id")
    private Long feeSubjectId;

    /**
     * 成本科目名称
     */
    @TableField(value = "fee_subject_name")
    private String feeSubjectName;

    /**
     * 成本科目集团主键
     */
    @TableField(value = "fee_org_subject_id")
    private Long feeOrgSubjectId;


    /**
     * 税率
     */
    @TableField(value = "tax_rate")
    private BigDecimal taxRate;
    /**
     * 税额
     */
    @TableField(value = "tax_fee")
    private BigDecimal taxFee;
    /**
     * 金额(含税)
     */
    @TableField(value = "tax_money")
    private BigDecimal taxMoney;

    /**
     * 核算对象主键
     */
    @TableField(value = "fee_accounting_id")
    private Long feeAccountingId;

    /**
     * 核算对象名称
     */
    @TableField(value = "fee_accounting_name")
    private String feeAccountingName;

    /**
     * 核算对象集团主键
     */
    @TableField(value = "fee_org_accounting_id")
    private Long feeOrgAccountingId;

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }

    public BigDecimal getTaxFee() {
        return taxFee;
    }

    public void setTaxFee(BigDecimal taxFee) {
        this.taxFee = taxFee;
    }



    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public Long getFeeSubjectId() {
        return feeSubjectId;
    }

    public void setFeeSubjectId(Long feeSubjectId) {
        this.feeSubjectId = feeSubjectId;
    }

    public String getFeeSubjectName() {
        return feeSubjectName;
    }

    public void setFeeSubjectName(String feeSubjectName) {
        this.feeSubjectName = feeSubjectName;
    }

    public Long getFeeOrgSubjectId() {
        return feeOrgSubjectId;
    }

    public void setFeeOrgSubjectId(Long feeOrgSubjectId) {
        this.feeOrgSubjectId = feeOrgSubjectId;
    }

    public Long getFeeAccountingId() {
        return feeAccountingId;
    }

    public void setFeeAccountingId(Long feeAccountingId) {
        this.feeAccountingId = feeAccountingId;
    }

    public String getFeeAccountingName() {
        return feeAccountingName;
    }

    public void setFeeAccountingName(String feeAccountingName) {
        this.feeAccountingName = feeAccountingName;
    }

    public Long getFeeOrgAccountingId() {
        return feeOrgAccountingId;
    }

    public void setFeeOrgAccountingId(Long feeOrgAccountingId) {
        this.feeOrgAccountingId = feeOrgAccountingId;
    }
}
