package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/1  用料申请主实体
 * @Description UseApplyEntity
 */

@TableName("ejc_material_apply")
public class UseApplyEntity extends BaseEntity {

    private static final long serialVersionUID = 2779265683203439571L;

    /**
     * 单据状态
     */
    @TableField(value = "bill_state")
    private Integer billState;

    /**
     * 申请单号
     */
    @TableField(value = "bill_code")
    private String billCode;

    /**
     * 申请单名称
     */
    @TableField(value = "name")
    private String name;

    /**
     * 项目名称
     */
    @TableField(value = "project_name")
    private String projectName;

    /**
     * 项目名称参照
     */
    @TableField(value = "project_id")
    private Long projectId;

    /**
     * 组织名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 组织参照
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 申请材料种类
     */
    @TableField(value = "material_type_name")
    private String materialTypeName;

    /**
     * 预估金额
     */
    @TableField(value = "estimate_money")
    private BigDecimal estimateMoney;

    /**
     * 计划进场日期
     */
    @TableField(value = "plan_enter_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planEnterDate;

    /**
     * 申请时间
     */
    @TableField(value = "apply_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate;

    /**
     * 申请人
     */
    @TableField(value = "apply_person")
    private String applyPerson;

    /**
     * 备注
     */
    @TableField(value = "memo")
    private String memo;

    /**
     * 编制日期  使用创建时间 createTime
     */

    /**
     * 子表
     */
    @TableField(exist = false)
    @SubEntity(serviceName = "useApplySubService")
    private List<UseApplySubEntity> useApplySubEntities = new ArrayList<>();

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public BigDecimal getEstimateMoney() {
        return estimateMoney;
    }

    public void setEstimateMoney(BigDecimal estimateMoney) {
        this.estimateMoney = estimateMoney;
    }

    public Date getPlanEnterDate() {
        return planEnterDate;
    }

    public void setPlanEnterDate(Date planEnterDate) {
        this.planEnterDate = planEnterDate;
    }

    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }

    public String getApplyPerson() {
        return applyPerson;
    }

    public void setApplyPerson(String applyPerson) {
        this.applyPerson = applyPerson;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<UseApplySubEntity> getUseApplySubEntities() {
        return useApplySubEntities;
    }

    public void setUseApplySubEntities(List<UseApplySubEntity> useApplySubEntities) {
        this.useApplySubEntities = useApplySubEntities;
    }
}
