package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.material.bean.OutStoreEntity;
import com.ejianc.business.material.bean.OutStoreSubEntity;
import com.ejianc.business.material.pub.MaterialAllocationState;
import com.ejianc.business.material.pub.MaterialStoreState;
import com.ejianc.business.material.pub.MaterialStoreType;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.service.IOutStoreSubService;
import com.ejianc.business.material.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/13 出库控制器
 * @Description OutStoreController
 */


@Controller
@RequestMapping("/outStore/")
public class OutStoreController {
    private static final String BILL_CODE = "MATERIAL-OUTSTORE";

    @Autowired
	IOutStoreService iOutStoreService;
    @Autowired
    IOutStoreSubService outStoreSubService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IOrgApi iOrgApi;

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/10  保存修改
     * @Description saveOrUpdate
     * @Param [vo]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.Sub.vo.OutStoreVO>
     */
    @RequestMapping(value = "saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutStoreVO> saveOrUpdate(@RequestBody OutStoreVO vo) {
		beforeSave(vo);
        OutStoreEntity entity = BeanMapper.map(vo, OutStoreEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        iOutStoreService.saveOrUpdate(entity,false);
        OutStoreVO backVo = BeanMapper.map(entity, OutStoreVO.class);
        return CommonResponse.success("保存或修改单据成功！",backVo);
    }

    public void beforeSave(OutStoreVO vo){
        BigDecimal totalAmountNoTax = new BigDecimal(0);
        if(!ListUtil.isEmpty(vo.getOutStoreSubEntities())){
    		for(OutStoreSubVO sub:vo.getOutStoreSubEntities()){
                if(!"del".equals(sub.getRowState())){
                    sub.setStoreId(vo.getStoreId());
                    sub.setStoreType(vo.getStoreType());
                    sub.setOutDate(vo.getOutDate());
                    /** 新增和修改 均为占用态 */
                    sub.setStoreState(MaterialStoreState.OCCUPY.getCode());
                    totalAmountNoTax = totalAmountNoTax.add(sub.getAmount()==null?new BigDecimal("0.00"):
                            sub.getAmount().divide(new BigDecimal("1.00").add(sub.getTaxRate()==null?new BigDecimal("0.00"):sub.getTaxRate().divide(new BigDecimal("100.00"),8,BigDecimal.ROUND_HALF_UP)),8,BigDecimal.ROUND_HALF_UP)
                            );
                }
			}
		}
        vo.setOutMoneyNoTax(totalAmountNoTax);
    }

    /***
     * @Author mrsir_wxp
     * @Date 2020/12/22 保存 关联 领料退库使用
     * @Description pushToCost
     * @Param [vo]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.InstoreVO>
     */
    @RequestMapping(value = "pushToCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutStoreVO> pushToCost(@RequestBody OutStoreVO vo) {
        beforeSave(vo);
        OutStoreEntity entity = BeanMapper.map(vo, OutStoreEntity.class);
        iOutStoreService.processCost(entity);
        iOutStoreService.saveOrUpdate(entity,false);
        OutStoreVO backVo = BeanMapper.map(entity, OutStoreVO.class);
        return CommonResponse.success("保存关联成功！",backVo);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/2 查询详情
     * @Description queryDetail
     * @Param [id]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.Sub.vo.OutStoreVO>
     */
    @RequestMapping(value = "queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutStoreVO> queryDetail(Long id) {
        OutStoreEntity entity = iOutStoreService.selectById(id);
        OutStoreVO vo = BeanMapper.map(entity, OutStoreVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @RequestMapping(value = "queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutStoreVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialNames");
        fuzzyFields.add("orgName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("useFor");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        /** 数据隔离 本下 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        return CommonResponse.success("查询列表数据成功！",iOutStoreService.queryForList(param,false));
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/10 查询打印数据
     * @Description queryPrint
     * @Param [id]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
     */
    @RequestMapping(value = "queryPrint", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("store",iOutStoreService.selectById(id));
        return CommonResponse.success("查询打印数据成功！",json);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/10 删除
     * @Description delete
     * @Param [vos]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutStoreVO> vos) {
    	iOutStoreService.removeByIds(vos.stream().map(OutStoreVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    /**
     * @Author mrsir_wxp
     * @Date 2020/6/10 导出
     * @Description excelExport
     * @Param [queryParam, response]
     * @Return void
     */
    @RequestMapping(value = "excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.setPageIndex(0);
        queryParam.setPageSize(10000);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialNames");
        fuzzyFields.add("orgName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("useFor");
        fuzzyFields.add("projectName");

        /** 数据隔离 本下 */
        queryParam.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<OutStoreVO>  voPage = iOutStoreService.queryForList(queryParam,false);
        List<OutStoreVO> list = voPage.getRecords();
        List<OutStoreExportVO> exportVOS = new ArrayList<>();
        if(ListUtil.isNotEmpty(list)){
            list.forEach(vo->{
                OutStoreExportVO exportVO = BeanMapper.map(vo,OutStoreExportVO.class);
                exportVO.setCreateTime(DateFormatUtil.formatDate("yyyy-MM-dd",vo.getCreateTime()));
                exportVO.setOutDate(DateFormatUtil.formatDate("yyyy-MM-dd",vo.getOutDate()));
                if(StringUtils.isNotBlank(vo.getReceiveState())){
                    exportVO.setReceiveState(MaterialAllocationState.TO_RECEIVING.getCode().equals(vo.getReceiveState())?"待收":
                            (MaterialAllocationState.RECEIVED.getCode().equals(vo.getReceiveState())?"已收":
                                    "已退回："+vo.getReturnReason()));
                }
                exportVO.setBillState(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                exportVOS.add(exportVO);
            });
        }
        
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", exportVOS);
        if(queryParam.getParams().get("storeType").getValue().equals(MaterialStoreType.ALLOCATION_OUT_STORE.getCode())){
            ExcelExport.getInstance().export("allocationOutExport.xlsx", beans, response);
        }else if(queryParam.getParams().get("storeType").getValue().equals(MaterialStoreType.PICKING_OUT_STORE.getCode())){
            ExcelExport.getInstance().export("pickingOutExport.xlsx", beans, response);
        }else if(queryParam.getParams().get("storeType").getValue().equals(MaterialStoreType.RETURN_GOODS_OUT_STORE.getCode())){
            ExcelExport.getInstance().export("returnGoodsListExport.xlsx", beans, response);
        }
    }
    
    /**
     * @Author liyongjai
     * @Date 2020/6/18 出库单参照
     * @Return 
     * 
     */
    @RequestMapping(value = "queryOutStoreMaterialList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutStoreSubVO>> queryOutStoreMaterialList(
    		@RequestParam(defaultValue = "1") int pageNumber, @RequestParam(defaultValue = "10") int pageSize,
    		@RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
    	
    	Long storeId = null;
    	String outDate = null;
    	if(StringUtils.isNotBlank(condition)){
    		JSONObject json = JSONObject.parseObject(condition);
    		if(json.get("storeId")!=null){
    			storeId = Long.parseLong(json.get("storeId").toString());
    		}else {
                return CommonResponse.error("condition条件缺少storeId（仓库id）！");
            }
    		if(json.get("outDate")!=null){
    			outDate = json.get("outDate").toString();
    		}else {
                return CommonResponse.error("condition条件缺少outDate(出库日期)！");
            }
    	}else {
    	    return CommonResponse.error("缺少condition条件");
        }
    	String storeType = "5,6";//领料出库,直接出库 
        return CommonResponse.success("查询列表数据成功！",outStoreSubService.queryOutStoreMaterialList(pageNumber,pageSize,storeId,outDate,storeType,searchText));
    }


    @RequestMapping(value = "queryRefNotSettlementList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutStoreVO>> queryRefNotSettlementList(
        @RequestParam(defaultValue = "1") int pageNumber, @RequestParam(defaultValue = "10") int pageSize,
        @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        if(StringUtils.isNotBlank(condition)){
            JSONObject json = JSONObject.parseObject(condition);
            if(json.get("orgId")!=null){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ,json.get("orgId")));
            }else {
                return CommonResponse.error("condition条件缺少orgId！");
            }
            if(json.get("contractId")!=null){
                param.getParams().put("contractId", new Parameter(QueryParam.EQ,json.get("contractId")));
            }
        }else {
            return CommonResponse.error("缺少condition条件");
        }
        param.getParams().put("storeType", new Parameter(QueryParam.EQ,"8"));
        param.getParams().put("billState", new Parameter(QueryParam.IN,"1,3"));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));

        param.getOrderMap().put("createTime",QueryParam.DESC);

        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);
        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("settlementFlag", new Parameter(QueryParam.EQ, "0"));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic(ComplexParam.OR);
        c3.getParams().put("settlementFlag", new Parameter(QueryParam.EQ, null));
        c1.getComplexParams().add(c3);

        param.getComplexParams().add(c1);

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("materialNames");
        IPage<OutStoreVO> page = iOutStoreService.queryForList(param,false);
        setType(page.getRecords());
        return CommonResponse.success("查询列表数据成功！",page);
    }
    public void setType(List< OutStoreVO > list){
        if(ListUtil.isNotEmpty(list)){
            list.forEach(l-> {
                OutStoreEntity entity = iOutStoreService.selectById(l.getId());
                if(ListUtil.isNotEmpty(entity.getOutStoreSubEntities())){
                    List<OutStoreSubEntity> entities = entity.getOutStoreSubEntities();
                    l.setOutStoreSubEntities(BeanMapper.mapList(entities, OutStoreSubVO.class));
                }
                l.setStoreTypeName(MaterialStoreType.getStoreTypeNameByCode(l.getStoreType()));
            });
        }
    }

    /**
     * @Author mrsir_wxp
     * @Date 2021/2/21 查询物资开累年累消耗top n
     * @Description queryMaterialCostTopN
     * @Param topN 消耗前几位
     * @Param type 1、开累，2、年累  默认年累top5
     * @Return com.ejianc.framework.core.response.CommonResponse<java.util.List<com.alibaba.fastjson.JSONObject>>
     */
    @RequestMapping(value = "queryMaterialCostTopN", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryMaterialCostTopN(@RequestParam(value = "topN",defaultValue = "5") Integer topN,@RequestParam(value = "type",defaultValue = "2") Integer type){
        return iOutStoreService.queryMaterialCostTopN(topN,type);
    }

}
