package com.ejianc.business.material.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import com.ejianc.business.material.bean.StoreEntity;
import com.ejianc.business.material.service.IStoreService;
import com.ejianc.business.material.vo.StoreVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;

@RestController
@RequestMapping("/api/store/")
public class StoreApi {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IStoreService storeService;

    /**
     * @Author liyongjia
     * @Date 2020/6/10  保存修改
     * @Description saveOrUpdate
     * @Param [vo]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.storeVO>
     */
	
    @RequestMapping(value = "saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<StoreVO> saveOrUpdate(@RequestBody StoreVO vo) {
        StoreEntity entity = BeanMapper.map(vo, StoreEntity.class);
        storeService.saveOrUpdate(entity,false);
        StoreVO backVo = BeanMapper.map(entity, StoreVO.class);
        return CommonResponse.success("保存或修改单据成功！",backVo);
    }

    @PostMapping(value = "delByProjectId")
    public CommonResponse<StoreVO> delByProjectId(@RequestBody Long projectId) {
        StoreVO resp = null;
        QueryWrapper<StoreEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", projectId);
        queryWrapper.eq("dr", BaseVO.DR_UNDELETE);

        StoreEntity e = storeService.getOne(queryWrapper);
        if(null != e) {
            boolean result = storeService.removeById(e.getId(), false);
            if(result) {
                //设置删除状态
                e.setDr(BaseVO.DR_DELETED);
                resp = BeanMapper.map(e, StoreVO.class);
            } else {
                return CommonResponse.error("删除失败！");
            }

        }

        return CommonResponse.success("删除成功！", resp);
    }

}
