package com.ejianc.business.material.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.bean.InstoreMaterialEntity;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

@Mapper
public interface InstoreMaterialMapper extends BaseCrudMapper<InstoreMaterialEntity> {

    Long queryStoreCanUseNumPageDataCount(@Param("searchText") String searchText,
                                          @Param("outDate") String outDate,
                                          @Param("storeId") Long storeId);

    InstoreMaterialVO censusStorematerial(@Param("storeId") Long storeId);

    List<InstoreMaterialVO> queryStoreCanUseNumPageData(@Param("searchText") String searchText,
                                                        @Param("outDate") String outDate,
                                                        @Param("storeId") Long storeId,
                                                        @Param("startLine") Integer startLine,
                                                        @Param("pageSize") Integer pageSize);

    Long countStorematerialList(@Param("storeId") Long storeId, @Param("searchText") String searchText);

    List<InstoreMaterialVO> storematerialList(@Param("storeId") Long storeId, @Param("searchText") String searchText,
                                              @Param("startLine") Integer startLine, @Param("pageSize") Integer pageSize);

    BigDecimal countAmount(@Param(Constants.WRAPPER) QueryWrapper<InstoreEntity> queryWrapper);

    Long queryUsableSubMaterialCount(@Param("searchText") String searchText,
                                     @Param("outDate") String outDate,
                                     @Param("storeId") Long storeId,
                                     @Param("materialIds") List<Long> materialIds);

    List<InstoreMaterialVO> queryUsableSubMaterialPageList(@Param("searchText") String searchText,
                                                           @Param("outDate") String outDate,
                                                           @Param("storeId") Long storeId,
                                                           @Param("startLine") Integer startLine,
                                                           @Param("pageSize") Integer pageSize,
                                                           @Param("materialIds") List<Long> materialIds);

    List<InstoreMaterialVO> querySubMaterialStoreInfo(@Param("storeId") Long storeId, @Param("outDate") Date outDate,
                                                      @Param("materialId") Long materialId, @Param("inventory") double inventory);

    Map<String, BigDecimal> queryStoreLeftMoneyAndMaterialTypeNumByProjectId(@Param("projectId") Long projectId);

    /**
     * @param projectId
     * @param materialIds
     * @description: 根据项目查询已经生效的入库数量
     * @return: java.util.List<com.ejianc.business.material.vo.MaterialPriceVO>
     * @author songlx
     * @date: 2021-05-27
     */
    List<MaterialPriceVO> queryMaterialInstoreCount(@Param(value = "projectId") Long projectId, @Param(value = "materialIds") List<Long> materialIds);

}
