package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * @author CJ
 * @Description: 合同审批回调类
 * @date 2020/6/10 16:05
 */
@Service("materialContract")
public class ContractApproveCallbackServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMaterialContractService materialContractService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IOrgApi orgApi;

    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        MaterialContractEntity e = materialContractService.selectById(billId);
        UserContext userContext = sessionManager.getUserContext();

        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        materialContractService.saveOrUpdate(e);

        return CommonResponse.success("回调处理成功！");
    }

    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        MaterialContractEntity e = materialContractService.selectById(billId);
        e.setEffectiveDate(new Date());
        materialContractService.saveOrUpdate(e, false);
        return CommonResponse.success("回调处理成功！");
    }

    /**
     * 弃审
     *
     * @param billId
     * @param state
     * @param billTypeCode
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        MaterialContractEntity e = materialContractService.selectById(billId);

        //代签合同+集采合同只能合同所属组织的本上级可撤回
        if(!e.getDependOnProject().equals(MaterialContractVO.CONTRACT_BELONG_PROJECT)) {
            CommonResponse<OrgVO> contractOrg = orgApi.getOneById(e.getPurchaseOrgId());
            if(!contractOrg.isSuccess()) {
                logger.error("弃审失败，获取合同【{}】所属组织信息失败: 【{}】", billId, contractOrg.getMsg());
                return CommonResponse.error("弃审失败，获取合同所属组织信息失败！");
            }
            CommonResponse<OrgVO> curOrg = orgApi.getOneById(InvocationInfoProxy.getOrgId());
            if(!curOrg.isSuccess()) {
                logger.error("弃审失败，获取获取当前用户【{}】所属组织信息失败: 【{}】", InvocationInfoProxy.getOrgId(), curOrg.getMsg());
                return CommonResponse.error("弃审失败，获取当前用户登录组织信息失败！");
            }
            if(!contractOrg.getData().getInnerCode().contains(curOrg.getData().getInnerCode())) {
                return CommonResponse.error("当前集采合同编制组织是【"+ e.getPurchaseOrgName() +"】, 不可弃审！");
            }
        }

        logger.info("物资合同单据【billId-{}】,【billTypeCode-{}】执行弃审前校验！", billId, billTypeCode);
        CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        logger.info("物资合同单据【billId-{}】,【billTypeCode-{}】校验被下游单据引用结果：{}", billId, billTypeCode, JSONObject.toJSONString(resp));
        if(!resp.isSuccess()) {
            logger.info("物资合同单据【billId-{}】,【billTypeCode-{}】执行弃审操作校验结束，未通过校验，原因：{}", resp.getMsg());
            return CommonResponse.error(resp.getMsg());
        }

        return CommonResponse.success("回调处理成功！");
    }
}
