package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.controller.SqlParam;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.business.material.service.CommonBillCodeService;
import com.ejianc.business.material.service.IContractChangeService;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.service.IMaterialSupplementService;
import com.ejianc.business.material.service.IPurchaseSettlementService;
import com.ejianc.business.material.vo.*;
import com.ejianc.business.material.vo.warn.MaterialWarnVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 物资合同数据处理服务
 *
 * @author CJ
 */
@Service("materialService")
public class MaterialContractServiceImpl extends BaseServiceImpl<MaterialContractMapper, MaterialContractEntity> implements IMaterialContractService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private final String DEFAULT_RULE_CODE = "materialContract";

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private MaterialContractMapper materialContractMapper;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IContractChangeService contractChangeService;
    @Autowired
    private IPurchaseSettlementService purchaseSettlementService;
    @Autowired
    private CommonBillCodeService commonBillCodeService;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IParamConfigApi paramConfigApi;
    
    @Autowired
    private IMaterialSupplementService materialSupplementService;
    
    //总计划量
    private static String PARAM_PLAN_COUNT = "P-8N9Au207";

    //总计划价
    private static String PARAM_PLAN_PRICE = "P-2Ux27w08";


    //总计划价
    private static String PARAM_PRICE_AREA = "P-126hYD10";

    @Override
    public MaterialContractVO save(MaterialContractVO materialContractVO) {
        MaterialContractEntity saveEntity = null;
        UserContext userContext = sessionManager.getUserContext();

        //设置合同初始化金额、变更前金额
        materialContractVO.setBaseMoney(materialContractVO.getAmountWithoutTax());
        materialContractVO.setBaseTaxMoney(materialContractVO.getAmountWithTax());
        materialContractVO.setBeforeChangeMny(materialContractVO.getAmountWithoutTax());
        materialContractVO.setBeforeChangeTaxMny(materialContractVO.getAmountWithTax());
        BigDecimal totalAmountWith = new BigDecimal(0).setScale(8, BigDecimal.ROUND_HALF_UP);

        if (null != materialContractVO.getId()) {
            MaterialContractEntity dbEntity = super.selectById(materialContractVO.getId());
            saveEntity = BeanMapper.map(materialContractVO, MaterialContractEntity.class);
            saveEntity.setCreateTime(dbEntity.getCreateTime());
            saveEntity.setCreateUserCode(dbEntity.getCreateUserCode());
            saveEntity.setCreateUserName(dbEntity.getCreateUserName());
            saveEntity.setModifyUserName(userContext.getUserName());

        } else {
            //创建人信息
            materialContractVO.setCreateUserName(userContext.getUserName());
            if (StringUtils.isBlank(materialContractVO.getCode())) {
                //自动生成编码
                //materialContractVO.setCode(getAutoCode());
                String code = commonBillCodeService.getCodeByOrgId(materialContractVO.getOrgId(),DEFAULT_RULE_CODE, materialContractVO);
                materialContractVO.setCode(code);
            }

            //设置初始变更版本号：1
            materialContractVO.setChangeVersion(1);
            //设置审批状态为自由态
            materialContractVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //设置合同变更状态：未变更
            materialContractVO.setChangeState(MaterialContractVO.CONTRACT_CHANGE_STATE_UNCHANGED);

            saveEntity = BeanMapper.map(materialContractVO, MaterialContractEntity.class);
        }
        //重新计算合同金额，税金
//        if (CollectionUtils.isNotEmpty(saveEntity.getMaterialDetailList())) {
//            totalAmountWith = totalAmountWith.add(saveEntity.getMaterialDetailList()
//                    .stream().filter(detail -> !"del".equals(detail.getRowState()) && (null != detail.getTotalAmount()))
//                    .map(MaterialContractDetailSubEntity::getTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
//        }
//        if (CollectionUtils.isNotEmpty(saveEntity.getOtherCostList())) {
//            totalAmountWith = totalAmountWith.add(saveEntity.getOtherCostList().stream()
//                    .filter(cost -> !"del".equals(cost.getRowState()) && (null != cost.getCostAmount()))
//                    .map(MaterialContractOtherCostSubEntity::getCostAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
//            saveEntity.getOtherCostList().stream().filter(cost -> null == cost.getCostAmount())
//                    .forEach(cost -> cost.setCostAmount(new BigDecimal(0)));
//        }
//        saveEntity.setAmountWithTax(totalAmountWith);
//        saveEntity.setAmountWithoutTax(totalAmountWith.divide(new BigDecimal(1 + saveEntity.getTaxRate() / 100), 8, BigDecimal.ROUND_HALF_UP));
//        saveEntity.setTaxFee(saveEntity.getAmountWithTax().subtract(saveEntity.getAmountWithoutTax()).setScale(8, BigDecimal.ROUND_HALF_UP));

        super.saveOrUpdate(saveEntity, false);
        return BeanMapper.map(saveEntity, MaterialContractVO.class);
    }

//    /**
//     * 获取自动生成编码并校验重复
//     *
//     * @return
//     */
//    private String getAutoCode() {
//        String code = null;
//
//        while (StringUtils.isBlank(code)) {
//            CommonResponse<String> resp = billCodeApi.getCodeBatchByRuleCode(DEFAULT_RULE_CODE, InvocationInfoProxy.getTenantid());
//            if (!resp.isSuccess()) {
//                throw new BusinessException("保存合同信息失败，自动生成编码失败！");
//            }
//            boolean checkResult = codeCheck(null, resp.getData());
//            if (checkResult) {
//                code = resp.getData();
//            }
//        }
//
//        return code;
//    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper<MaterialContractEntity> wrapper = super.changeToQueryWrapper(queryParam);
        wrapper.select("sum(base_tax_money) as originalAmount, sum(amount_with_tax) as curAmount");
        resp = super.getMap(wrapper);
        if (null == resp) {
            resp = new HashMap<>();
            resp.put("originalAmount", 0);
            resp.put("curAmount", 0);
        }

        return resp;
    }

    @Override
    public boolean codeCheck(Long id, String code) {
        QueryParam check = new QueryParam();
        check.getParams().put("id", new Parameter(QueryParam.NE, id));
        check.getParams().put("code", new Parameter(QueryParam.EQ, code));

        List<MaterialContractEntity> contractEntityList = super.queryList(check, false);
        if (CollectionUtils.isNotEmpty(contractEntityList)) {
            return false;
        }
        check.getParams().remove("id");
        check.getParams().put("material_contract_id", new Parameter(QueryParam.NE, id));
        check.getParams().put("bill_state", new Parameter(QueryParam.NE, BillStateEnum.PASSED_STATE.getBillStateCode()));

        List<ContractChangeEntity> changeList = contractChangeService.queryList(check, false);
        if (CollectionUtils.isNotEmpty(changeList)) {
            return false;
        }
        return true;
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/7/22  校验合同合法性
     * @Description checkContract
     * @Param [id]
     * @Return void
     */
    @Override
    public void checkContract(Long id) {
        MaterialContractEntity contractEntity = super.selectById(id);
        if (contractEntity == null) {
            throw new BusinessException("所选合同不存在！");
        }
        if (!(contractEntity.getBillState() == 1 || contractEntity.getBillState() == 3)) {
            throw new BusinessException("所选合同未生效！");
        }
    }

    @Override
    public List<Map<String, Object>> queryAllWarnContracts(List<SqlParam> sqlParamList) {
        return materialContractMapper.queryAllWarnContracts(sqlParamList);
    }

    @Override
    public List<MaterialWarnVo> materialProjectOutMny(List<Long> tenantIds) {
        return baseMapper.materialProjectOutMny(tenantIds);
    }

    @Override
    public List<MaterialReportVo> getMonthMaterialMny(Long projectId, Integer lastDay) {
        return baseMapper.getMonthMaterialMny(projectId, lastDay);
    }

    @Override
    public MaterialReportVo getMaterialContract(Long projectId) {
        BigDecimal mny = BigDecimal.ZERO;
        BigDecimal settleMny = BigDecimal.ZERO;
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper<MaterialContractEntity> lambda = Wrappers.<MaterialContractEntity>lambdaQuery();
        lambda.eq(MaterialContractEntity::getProjectId, projectId);
        lambda.eq(MaterialContractEntity::getDr, 0);
        lambda.eq(MaterialContractEntity::getSupplementFlag, 0);
        lambda.in(MaterialContractEntity::getBillState, billStatus);
        List<MaterialContractEntity> quoteEntities = super.list(lambda);
        for (MaterialContractEntity ce : quoteEntities) {
            mny = MathUtil.safeAdd(mny, ce.getAmountWithTax());
        }
        LambdaQueryWrapper<PurchaseSettlementEntity> lambda2 = Wrappers.<PurchaseSettlementEntity>lambdaQuery();
        lambda2.eq(PurchaseSettlementEntity::getProjectId, projectId);
        lambda2.eq(PurchaseSettlementEntity::getDr, 0);
        lambda2.in(PurchaseSettlementEntity::getBillState, billStatus);
        List<PurchaseSettlementEntity> purchaseSettlementEntities = purchaseSettlementService.list(lambda2);
        for (PurchaseSettlementEntity ce : purchaseSettlementEntities) {
            settleMny = MathUtil.safeAdd(settleMny, ce.getCurrentSettlementAmountTax());
        }
        MaterialReportVo vo = new MaterialReportVo();
        vo.setMny(mny);
        vo.setNum(quoteEntities.size());
        vo.setSettleMny(settleMny);
        return vo;
    }

    @Override
    public List<MaterialContractVO> queryWarnContracts(List<Long> tenantAllIds) {
        return materialContractMapper.queryWarnContracts(tenantAllIds);
    }

    @Override
    public List<MaterialContractVO> queryWarnPrePayContracts(List<Long> tenantAllIds) {
        return materialContractMapper.queryWarnPrePayContracts(tenantAllIds);
    }


    @Override
    public MaterialPriceVO queryPrice(Integer isJc, Long contractId, MaterialPriceVO vo) {
        Long projectId = vo.getProjectId();
        List<MaterialPriceVO> detail = vo.getDetail();
        if (CollectionUtils.isNotEmpty(detail)) {
            List<Long> materialIds = detail.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
            if (projectId != null && 1 != isJc) {
                List<MaterialPriceVO> materialPriceVOS = materialContractMapper.queryPlanPriceByProjectId(projectId, materialIds);
                if (CollectionUtils.isNotEmpty(materialPriceVOS)) {
                    Map<Long, MaterialPriceVO> priceVOMap = materialPriceVOS.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account,(v1, v2) -> v2));
                    for (MaterialPriceVO v : detail) {
                        Long materialId = v.getMaterialId();
                        MaterialPriceVO p = priceVOMap.get(materialId);
                        if (null != p) {
                            v.setPlanNum(p.getPlanNum());
                            v.setPlanPrice(p.getPlanPrice());
                        }
                    }
                }
            }
            //结算历史低价和高价只和租户有关
            List<MaterialPriceVO> materialPrices = materialContractMapper.querySettlePriceByTenantId(InvocationInfoProxy.getTenantid(), materialIds);
            if (CollectionUtils.isNotEmpty(materialPrices)) {
                Map<Long, MaterialPriceVO> priceVO = materialPrices.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account,(v1, v2) -> v2));
                for (MaterialPriceVO v : detail) {
                    Long materialId = v.getMaterialId();
                    MaterialPriceVO p = priceVO.get(materialId);
                    if (null != p) {
                        v.setMinPrice(p.getMinPrice());
                        v.setMaxPrice(p.getMaxPrice());
                        v.setPriceArea(p.getMinPrice().setScale(2,BigDecimal.ROUND_HALF_UP) + "~" + p.getMaxPrice().setScale(2,BigDecimal.ROUND_HALF_UP));

                    }
                }
            }
        }
        return vo;
    }


    // 【物资总计划量】控制【物资合同量】P-8N9Au207 集采不受控制
    // 总计划价格【物资总计划价】控制【物资合同价】P-2Ux27w08  集采不受控制
    // 结算历史价格区间【历史价】控制【物资合同价】P-126hYD10
    //控制方式 0：不控制，1、提醒，2、无法保存
    @Override
    public ParamsCheckVO checkParams(Integer isJc, Long contractId, MaterialPriceVO vo) {
        String[] paramsArray = {"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType(paramsArray[0]);
        List<MaterialPriceVO> detail = vo.getDetail();
        Integer controlType = 0;
        if (CollectionUtils.isNotEmpty(detail)) {
            List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
            if (isJc == 0) {
                // 【物资总计划量】控制【物资合同量】P-8N9Au207 集采不受控制
                CommonResponse<BillParamVO> countParamByCode = paramConfigApi.getBillParamByCode(PARAM_PLAN_COUNT);
                if (countParamByCode.isSuccess() && null != countParamByCode.getData()) {
                    BillParamVO billParamVO = countParamByCode.getData();
                    controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;
                    if (0 != billParamVO.getControlType()) {
                        List<Long> materialIds = detail.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
                        //获取已生效的量
                        List<MaterialPriceVO> vos = new ArrayList<>();
                        if(contractId != null){
                            vos = materialContractMapper.queryMaterialContractCount(contractId, vo.getProjectId(), materialIds);

                        }
                        Map<Long, BigDecimal> priceVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));

                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                        detail.forEach((d) -> {
                            BigDecimal num = d.getNum();
                            BigDecimal planNum = d.getPlanNum().multiply(divide);
                            BigDecimal hasNum = priceVOMap.get(d.getMaterialId()) != null ? priceVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                            BigDecimal allNum = hasNum.add(num);
                            if (allNum.compareTo(planNum) > 0) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "count");
                                paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : "" ));
                                paramsCheckDsVO.setWarnName("合同数量大于总计划数量");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("本次合同数量：").append(num.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("，已签订数量：").append(hasNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("，总计划数量*").append(roleValue).append("%: ").append(planNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("。超出数量：").append(allNum.subtract(planNum).setScale(2, BigDecimal.ROUND_HALF_UP));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                checkDsVOS.add(paramsCheckDsVO);
                            }
                        });
                    }
                } else {
                    logger.info(countParamByCode.getMsg());
                    throw new BusinessException("获取控制参数失败");
                }

                // 总计划价格【物资总计划价】控制【物资合同价】P-2Ux27w08  集采不受控制
                CommonResponse<BillParamVO> priceParamByCode = paramConfigApi.getBillParamByCode(PARAM_PLAN_PRICE);
                if (priceParamByCode.isSuccess() && null != priceParamByCode.getData()) {
                    BillParamVO billParamVO = priceParamByCode.getData();
                    controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                        detail.forEach((d) -> {
                            BigDecimal price = d.getPrice();
                            BigDecimal planPrice = d.getPlanPrice();
                            BigDecimal _planPrice = planPrice.multiply(divide);
                            if (price.compareTo(_planPrice) > 0) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "unitPrice");
                                paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : "" ));
                                paramsCheckDsVO.setWarnName("合同单价大于总计划单价");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("本次合同单价：").append(price.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("，总计划单价*").append(roleValue).append("%: ").append(_planPrice.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("。超出单价：").append(price.subtract(_planPrice).setScale(2, BigDecimal.ROUND_HALF_UP));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                checkDsVOS.add(paramsCheckDsVO);
                            }
                        });
                    }
                } else {
                    logger.info(priceParamByCode.getMsg());
                    throw new BusinessException("获取控制参数失败");
                }

            }


            // 结算历史价格区间【历史价】控制【物资合同价】P-126hYD10
            CommonResponse<BillParamVO> areaParamByCode = paramConfigApi.getBillParamByCode(PARAM_PRICE_AREA);
            if (areaParamByCode.isSuccess() && null != areaParamByCode.getData()) {
                BillParamVO billParamVO = areaParamByCode.getData();
                controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;
                if (0 != billParamVO.getControlType()) {
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                    detail.forEach((d) -> {
                        BigDecimal price = d.getPrice();
                        BigDecimal maxPrice = d.getMaxPrice() == null ? BigDecimal.ZERO : d.getMaxPrice();
                        BigDecimal minPrice = d.getMinPrice();
                        if (maxPrice.compareTo(BigDecimal.ZERO) > 0) {
                            BigDecimal _maxPrice = maxPrice.multiply(divide);
                            BigDecimal _minPrice = minPrice.multiply(divide);
                            if(price.compareTo(_maxPrice) > 0){
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "unitPrice");
                                paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : "" ));
                                paramsCheckDsVO.setWarnName("合同单价大于历史价");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("本次合同单价：").append(price.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("，物资历史价*").append(roleValue).append("%: ").append(_minPrice.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("~").append(_maxPrice.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("。超出最高价：").append(price.subtract(_maxPrice).setScale(2, BigDecimal.ROUND_HALF_UP));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                checkDsVOS.add(paramsCheckDsVO);
                            }

                        }
                    });
                }
            } else {
                logger.info(areaParamByCode.getMsg());
                throw new BusinessException("获取控制参数失败");
            }
            paramsCheckVO.setWarnType(paramsArray[controlType]);

            paramsCheckVO.setDataSource(checkDsVOS);

        }


        return paramsCheckVO;
    }

    @Override
    public void updateSettlementType(Long contractId, Integer settlementType) {
        materialContractMapper.updateSettlementType(contractId,settlementType);
    }

    @Override
    public List<MaterialSupplementEntity> querySupplement(Long mainContractId) {
        return materialContractMapper.querySupplement(mainContractId);
    }

    @Override
    public BigDecimal queryTotalOutMoney(Long orgId) {
        List<Long> orgIds = orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        Long tenantId = InvocationInfoProxy.getTenantid();
        BigDecimal totalOutMoney = materialContractMapper.totalOutMoney(1, null, orgIds, tenantId);

        return totalOutMoney;
    }
	@Override
	public void updateContractIsSupplementFlag(Long id) {
		MaterialContractEntity contractEntity = baseMapper.selectById(id);
        LambdaQueryWrapper<MaterialSupplementEntity> lambda = Wrappers.<MaterialSupplementEntity>lambdaQuery();
        lambda.eq(MaterialSupplementEntity::getMainContractId, id);
        lambda.orderByDesc(MaterialSupplementEntity::getSignDate);
        List<MaterialSupplementEntity> entities = materialSupplementService.list(lambda);
        if(entities.size()>0) {
        	contractEntity.setIsSupplement("1");
        }else {
        	contractEntity.setIsSupplement("0");
        }
        baseMapper.updateById(contractEntity);
	}
}
