package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.vo.MaterialSupplementVO;
import com.ejianc.business.material.vo.SupplementContractRecordVO;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.material.mapper.MaterialSupplementMapper;
import com.ejianc.business.material.bean.MaterialSupplementEntity;
import com.ejianc.business.material.service.IMaterialSupplementService;

import java.math.BigDecimal;
import java.util.List;

/**
 * 物资合同补充协议
 *
 * @author generator
 */
@Service("materialSupplementService")
public class MaterialSupplementServiceImpl extends BaseServiceImpl<MaterialSupplementMapper, MaterialSupplementEntity> implements IMaterialSupplementService {

    @Autowired
    private IMaterialContractService materialContractService;

    @Override
    public MaterialSupplementVO addConvertByConId(Long contractId) {
        MaterialContractEntity contractVO = materialContractService.selectById(contractId);
        MaterialSupplementVO supplementVO = new MaterialSupplementVO();
        supplementVO.setPurchaseType(contractVO.getPurchaseType());
        supplementVO.setPurchaseTypeName(contractVO.getPurchaseTypeName());
        supplementVO.setProjectId(contractVO.getProjectId());
        supplementVO.setProjectName(contractVO.getProjectName());
        supplementVO.setOrgId(contractVO.getOrgId());
        supplementVO.setOrgName(contractVO.getOrgName());
        supplementVO.setSupplierId(contractVO.getSupplierId());
        supplementVO.setSupplierName(contractVO.getSupplierName());
        supplementVO.setDependOnProject(contractVO.getDependOnProject());
        supplementVO.setContractorEnterpriseId(contractVO.getContractorEnterpriseId());
        supplementVO.setContractorEnterpriseName(contractVO.getContractorEnterpriseName());
        supplementVO.setTaxRate(contractVO.getTaxRate());
        supplementVO.setSupplementFlag(1);
        supplementVO.setState(contractVO.getState());
        supplementVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        supplementVO.setStateName(contractVO.getStateName());
        supplementVO.setChangeState(contractVO.getChangeState());
        supplementVO.setChangeBillState(contractVO.getChangeBillState());
        supplementVO.setPurchaseMode(contractVO.getPurchaseMode());
        supplementVO.setPurchaseModeName(contractVO.getPurchaseModeName());
        supplementVO.setPurchaseType(contractVO.getPurchaseType());
        supplementVO.setPurchaseTypeName(contractVO.getPurchaseTypeName());
        supplementVO.setMainContractId(contractVO.getId());
        supplementVO.setMainContractCode(contractVO.getCode());
        supplementVO.setMainContractName(contractVO.getName());
        supplementVO.setPurchaseOrgId(contractVO.getPurchaseOrgId());
        supplementVO.setPurchaseOrgName(contractVO.getPurchaseOrgName());
        supplementVO.setReplaceSignFlag(contractVO.getReplaceSignFlag());
        return supplementVO;
    }

    @Override
    public SupplementContractRecordVO queryDetailRecord(Long id) {
        MaterialContractEntity materialContractEntity = materialContractService.selectById(id);
        SupplementContractRecordVO recordVO = new SupplementContractRecordVO();
        BigDecimal contractTaxMny = materialContractEntity.getAmountWithTax() == null ? BigDecimal.ZERO : materialContractEntity.getAmountWithTax();
        BigDecimal noTaxMny = materialContractEntity.getAmountWithoutTax() == null ? BigDecimal.ZERO : materialContractEntity.getAmountWithoutTax();
        recordVO.setContractId(id);
        recordVO.setAmountWithTax(contractTaxMny);
        recordVO.setAmountWithoutTax(noTaxMny);
        recordVO.setSettlementType(materialContractEntity.getSettlementType());
        recordVO.setBaseTaxMoney(materialContractEntity.getBaseTaxMoney());
        recordVO.setChangingMny(materialContractEntity.getChangingMny());
        recordVO.setChangeState(materialContractEntity.getChangeState());
        recordVO.setOrgId(materialContractEntity.getPurchaseOrgId());
        LambdaQueryWrapper<MaterialSupplementEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(MaterialSupplementEntity::getMainContractId, id);
        lambda.orderByDesc(MaterialSupplementEntity::getSignDate);
        List<MaterialSupplementEntity> entities = super.list(lambda);
        recordVO.setSupplementRecord(BeanMapper.mapList(entities, MaterialSupplementVO.class));
        return recordVO;
    }
}
