package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.MaterialMasterPlanEntity;
import com.ejianc.business.plan.mapper.MaterialMasterPlanMapper;
import com.ejianc.business.plan.mapper.MaterialMasterPlanSubMapper;
import com.ejianc.business.plan.service.IMaterialMasterPlanService;
import com.ejianc.business.plan.vo.MaterialMasterPlanVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author CJ
 * @Description:
 * @date 2021/3/2 17:10
 */
@Service(value = "materialMasterPlanService")
public class MaterialMasterPlanServiceImpl extends BaseServiceImpl<MaterialMasterPlanMapper, MaterialMasterPlanEntity> implements IMaterialMasterPlanService {

    @Autowired
    private MaterialMasterPlanMapper materialMasterPlanMapper;

    @Autowired
    private MaterialMasterPlanSubMapper materialMasterPlanSubMapper;

    @Override
    public MaterialMasterPlanVO queryByCode(String planCode) {
        MaterialMasterPlanVO resp = null;
        QueryWrapper<MaterialMasterPlanEntity> query = new QueryWrapper<>();
        query.eq("plan_code", planCode);
        query.eq("dr", BaseVO.DR_UNDELETE);
        MaterialMasterPlanEntity entity = materialMasterPlanMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, MaterialMasterPlanVO.class);
        }
        return resp;
    }

    @Override
    public MaterialMasterPlanVO queryByProjectId(Long projectId) {
        MaterialMasterPlanVO resp = null;
        QueryWrapper<MaterialMasterPlanEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        MaterialMasterPlanEntity entity = materialMasterPlanMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, MaterialMasterPlanVO.class);
        }
        return resp;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public MaterialMasterPlanEntity saveOrUpdateMasterPlan(MaterialMasterPlanEntity saveEntity) {
        //更新子表信息
        if(null != saveEntity.getId()) {
            materialMasterPlanSubMapper.delByPlanId(saveEntity.getId());
        }
        super.saveOrUpdate(saveEntity, false);
        return saveEntity;
    }
}
