package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.mapper.ReportMapper;
import com.ejianc.business.material.service.IReportService;
import com.ejianc.business.material.vo.BuyPriceDetailVO;
import com.ejianc.business.material.vo.BuyPriceVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Service
public class ReportService implements IReportService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private ReportMapper reportMapper;


    /**
     * @param page
     * @param param
     * @description: 采购价格分析
     * * materialTypeId
     * * startDate
     * * endDate
     * * materialTypeName
     * * materialName
     * * model
     * * unit
     * @return: java.util.List<com.ejianc.business.material.vo.BuyPriceVO>
     * @author songlx
     * @date: 2021-04-08
     */
    @Override
    public List<BuyPriceVO> queryBuyPriceList(Page<BuyPriceVO> page, QueryParam param) {
        Map<String, Parameter> params = param.getParams();
        Parameter para = params.get("materialTypeIds");
        List<Long> materialTypeIds = para != null && para.getValue() != null ? castList(para.getValue()) : null;


        String startDate = getParamValue(params, "startDate") == null ? null : "'" + getParamValue(params, "startDate") + "'";
        String endDate = getParamValue(params, "endDate") == null ? null : "'" + getParamValue(params, "endDate") + "'";

        String materialTypeName = getParamValue(params, "materialTypeName");
        String materialName = getParamValue(params, "materialName");
        String model = getParamValue(params, "model");
        String unit = getParamValue(params, "unit");

        return reportMapper.queryBuyPrice(InvocationInfoProxy.getTenantid(), materialTypeIds, startDate, endDate, materialTypeName, materialName, model, unit);
    }


    public static List<Long> castList(Object obj) {
        List<Long> result = new ArrayList<>();
        if (obj instanceof List<?>) {
            for (Object o : (List<?>) obj) {
                result.add(Long.valueOf(o.toString()));
            }
            return result;
        }
        return null;
    }


    private String getParamValue(Map<String, Parameter> params, String paramKey) {
        if (params.get(paramKey) != null) {
            Object value = params.get(paramKey).getValue();
            return value != null ? String.valueOf(value) : null;
        }
        return null;
    }

    @Override
    public List<BuyPriceVO> queryBuyPriceList(QueryParam param) {
        Map<String, Parameter> params = param.getParams();
        Long tenantId = params.get("tenantId") != null ? Long.valueOf(String.valueOf(params.get("tenantId").getValue())) : null;
        return reportMapper.queryBuyPriceList(tenantId);
    }

    @Override
    public List<BuyPriceDetailVO> queryBuyPriceDetailList(QueryParam param) {
        Map<String, Parameter> params = param.getParams();
        Long tenantId = params.get("tenantId") != null ? Long.valueOf(String.valueOf(params.get("tenantId").getValue())) : null;

        return reportMapper.queryBuyPriceDetailList(tenantId);
    }
}
