package com.ejianc.business.material.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/1  采购结算单 其他费用表
 * @Description PurchaseSettlementOtherFeeVO
 */
public class PurchaseSettlementOtherFeeVO extends BaseVO {

    private static final long serialVersionUID = 2779265683203439571L;

    /**
     * 主表id
     */
    private Long pid;

    /**
     * 名称
     */
    private String name;

    /**
     * 金额
     */
    private BigDecimal money;

    /**
     * 备注
     */
    private String memo;

    /**
     * 成本科目主键
     */
    private Long feeSubjectId;

    /**
     * 成本科目名称
     */
    private String feeSubjectName;

    /**
     * 成本科目集团主键
     */
    private Long feeOrgSubjectId;

    /**
     * 税率
     */
    private BigDecimal taxRate;
    /**
     * 税额
     */
    private BigDecimal taxFee;
    /**
     * 金额(含税)
     */
    private BigDecimal taxMoney;

    /**
     * 核算对象主键
     */
    private Long feeAccountingId;

    /**
     * 核算对象名称
     */
    private String feeAccountingName;

    /**
     * 核算对象集团主键
     */
    private Long feeOrgAccountingId;

    public BigDecimal getTaxFee() {
        return taxFee;
    }

    public void setTaxFee(BigDecimal taxFee) {
        this.taxFee = taxFee;
    }

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    @ReferSerialTransfer(referCode="subject-project-ref")
    public Long getFeeSubjectId() {
        return feeSubjectId;
    }

    @ReferDeserialTransfer
    public void setFeeSubjectId(Long feeSubjectId) {
        this.feeSubjectId = feeSubjectId;
    }

    public String getFeeSubjectName() {
        return feeSubjectName;
    }

    public void setFeeSubjectName(String feeSubjectName) {
        this.feeSubjectName = feeSubjectName;
    }

    public Long getFeeOrgSubjectId() {
        return feeOrgSubjectId;
    }

    public void setFeeOrgSubjectId(Long feeOrgSubjectId) {
        this.feeOrgSubjectId = feeOrgSubjectId;
    }

    @ReferSerialTransfer(referCode="accounting-project-ref")
    public Long getFeeAccountingId() {
        return feeAccountingId;
    }

    @ReferDeserialTransfer
    public void setFeeAccountingId(Long feeAccountingId) {
        this.feeAccountingId = feeAccountingId;
    }

    public String getFeeAccountingName() {
        return feeAccountingName;
    }

    public void setFeeAccountingName(String feeAccountingName) {
        this.feeAccountingName = feeAccountingName;
    }

    public Long getFeeOrgAccountingId() {
        return feeOrgAccountingId;
    }

    public void setFeeOrgAccountingId(Long feeOrgAccountingId) {
        this.feeOrgAccountingId = feeOrgAccountingId;
    }
}

