package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/1  采购结算单 物资明细表
 * @Description PurchaseSettlementMaterialDetailEntity
 */
@TableName("ejc_material_purchase_settlement_material_detail")
public class PurchaseSettlementMaterialDetailEntity extends BaseEntity {

    private static final long serialVersionUID = 2779265683203439571L;

    /**
     * 主表id
     */
    @TableField(value = "pid")
    private Long pid;

    /**
     * 物资分类名称
     */
    @TableField(value = "material_type_name")
    private String materialTypeName;


    /**
     * 物资分类id
     */
    @TableField(value = "material_type_id")
    private Long materialTypeId;

    /**
     * 物资名称
     */
    @TableField(value = "material_name")
    private String materialName;

    /**
     * 物资id
     */
    @TableField(value = "material_id")
    private Long materialId;

    /**
     * 规格型号
     */
    @TableField(value = "model")
    private String model;

    /**
     * 计量单位
     */
    @TableField(value = "unit")
    private String unit;

    /**
     * 结算数量
     */
    @TableField(value = "num")
    private BigDecimal num;

    /**
     * 结算单价
     */
    @TableField(value = "price")
    private BigDecimal price;

    /**
     * 金额
     */
    @TableField(value = "money")
    private BigDecimal money;

    /**
     * 备注
     */
    @TableField(value = "memo")
    private String memo;

    /**
     * 数据来源类型
     */
    @TableField(value = "source_type")
    private String sourceType;

    /**
     * 数据来源类型名称
     */
    @TableField(value = "source_type_name")
    private String sourceTypeName;

    /**
     * 数据来源主表id
     */
    @TableField(value = "source_main_id")
    private String sourceMainId;

    /**
     * 数据来源子表id
     */
    @TableField(value = "source_sub_id")
    private String sourceSubId;

    /**
     * 成本科目主键
     */
    @TableField(value = "subject_id")
    private Long subjectId;

    /**
     * 成本科目名称
     */
    @TableField(value = "subject_name")
    private String subjectName;

    /**
     * 成本科目集团主键
     */
    @TableField(value = "org_subject_id")
    private Long orgSubjectId;

    /**
     * 税率
     */
    @TableField(value = "tax_rate")
    private BigDecimal taxRate;
    /**
     * 税额
     */
    @TableField(value = "tax_detail")
    private BigDecimal taxDetail;
    /**
     * 结算单价(含税)
     */
    @TableField(value = "tax_price")
    private BigDecimal taxPrice;
    /**
     * 金额(含税)
     */
    @TableField(value = "tax_money")
    private BigDecimal taxMoney;

    /**
     * 核算对象主键
     */
    @TableField(value = "accounting_id")
    private Long accountingId;

    /**
     * 核算对象名称
     */
    @TableField(value = "accounting_name")
    private String accountingName;

    /**
     * 核算对象集团主键
     */
    @TableField(value = "org_accounting_id")
    private Long orgAccountingId;
    
    
    /**
     * 累计结算数量
     */
    @TableField(value = "sum_num")
    private Long sumNum;

    public Long getSumNum() {
		return sumNum;
	}

	public void setSumNum(Long sumNum) {
		this.sumNum = sumNum;
	}

	public BigDecimal getTaxDetail() {
        return taxDetail;
    }

    public void setTaxDetail(BigDecimal taxDetail) {
        this.taxDetail = taxDetail;
    }

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceTypeName() {
        return sourceTypeName;
    }

    public void setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
    }

    public String getSourceMainId() {
        return sourceMainId;
    }

    public void setSourceMainId(String sourceMainId) {
        this.sourceMainId = sourceMainId;
    }

    public String getSourceSubId() {
        return sourceSubId;
    }

    public void setSourceSubId(String sourceSubId) {
        this.sourceSubId = sourceSubId;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public Long getAccountingId() {
        return accountingId;
    }

    public void setAccountingId(Long accountingId) {
        this.accountingId = accountingId;
    }

    public String getAccountingName() {
        return accountingName;
    }

    public void setAccountingName(String accountingName) {
        this.accountingName = accountingName;
    }

    public Long getOrgSubjectId() {
        return orgSubjectId;
    }

    public void setOrgSubjectId(Long orgSubjectId) {
        this.orgSubjectId = orgSubjectId;
    }

    public Long getOrgAccountingId() {
        return orgAccountingId;
    }

    public void setOrgAccountingId(Long orgAccountingId) {
        this.orgAccountingId = orgAccountingId;
    }
}
