package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.material.bean.MaterialContractDetailSubEntity;
import com.ejianc.business.material.service.IMaterialContractDetailSubService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2020/6/15 10:17
 */
@RestController
@RequestMapping("/contractMaterialDetail/")
public class ContractMaterialDetailController {

    @Autowired
    private IMaterialContractDetailSubService materialContractDetailSubService;

    /**
     * 物资合同物资列表参照
     *
     * @return
     */
    @GetMapping("contractMaterialDetailListRefer")
    public CommonResponse<IPage<MaterialContractDetailSubEntity>> contractMaterialDetailListRefer(@RequestParam(required = false) String condition,
		@RequestParam(required = false) String searchText, @RequestParam int pageSize,
		@RequestParam int pageNumber,@RequestParam(required = false) String searchObject ) {
        QueryParam queryParam = new QueryParam();
        queryParam.getFuzzyFields().add("material_name");
        queryParam.getFuzzyFields().add("spec");
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);

        if(StringUtils.isNotBlank(searchText)) {
            queryParam.setSearchText(searchText);
        }

    	if(StringUtils.isNotBlank(searchObject)){
    		JSONObject search = JSONObject.parseObject(searchObject);
    		if(search.get("materialTypeName")!=null){
    			queryParam.getParams().put("materialTypeName",new Parameter(QueryParam.LIKE,search.get("materialTypeName").toString()));
    		}
    		if(search.get("materialName")!=null){
    			queryParam.getParams().put("materialName",new Parameter(QueryParam.LIKE,search.get("materialName").toString()));
    		}
    		if(search.get("spec")!=null){
    			queryParam.getParams().put("spec",new Parameter(QueryParam.LIKE,search.get("spec").toString()));
    		}
    		if(search.get("measureUnit")!=null){
    			queryParam.getParams().put("measureUnit",new Parameter(QueryParam.LIKE,search.get("measureUnit").toString()));
    		}
    	}
        Long contractId = null;

        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("contractId")) {
                contractId = Long.valueOf(conditionMap.get("contractId").toString());
            }
        }
        if(null == contractId) {
            return CommonResponse.error("查询合同列表失败，合同主键为必传参数！");
        }
        queryParam.getParams().put("material_contract_id", new Parameter(QueryParam.EQ, contractId));

        IPage<MaterialContractDetailSubEntity> pageData = materialContractDetailSubService.queryPage(queryParam, false);
        
        for (MaterialContractDetailSubEntity entityTemp : pageData.getRecords()) {
        	MaterialContractDetailSubEntity entitySum= materialContractDetailSubService.querySettleDetail(entityTemp.getId());
        	entityTemp.setSumNum(entitySum.getCount());
		}
        

        return CommonResponse.success("查询合同列表成功！", pageData);
    }

}
