/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.ContractChangeEntity;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.bean.MaterialSupplementEntity;
import com.ejianc.business.material.service.IContractChangeService;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.service.IMaterialSupplementService;
import com.ejianc.business.material.vo.MaterialSupplementVO;
import com.ejianc.business.material.vo.SupplementContractRecordVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"materialSupplement"})
public class MaterialSupplementController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMaterialSupplementService service;
    @Autowired
    private IMaterialContractService materialContractService;
    @Autowired
    private IMaterialSupplementService materialSupplementService;
    @Autowired
    private IContractChangeService contractChangeService;
    private static final String SUPPLEMENT_BILL_CODE = "MATERIAL_SUPPLEMENT";
    @Autowired
    private IBillCodeApi billCodeApi;

    @RequestMapping(value={"/queryDetailRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplementContractRecordVO> queryDetailRecord(Long id) {
        SupplementContractRecordVO vo = this.materialSupplementService.queryDetailRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/addConvertByConId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialSupplementVO> addConvertByConId(Long contractId) {
        MaterialSupplementVO vo = this.service.addConvertByConId(contractId);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialSupplementVO> saveOrUpdate(@RequestBody MaterialSupplementVO saveorUpdateVO) {
        Long mainContractId = saveorUpdateVO.getMainContractId();
        if (mainContractId != null) {
            CommonResponse.error((String)"\u4e0d\u5b58\u5728\u4e3b\u5408\u540c\uff0c\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(BaseEntity::getId, (Object)mainContractId);
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambda.eq(MaterialContractEntity::getSettlementType, (Object)1);
        List list = this.materialContractService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u8be5\u5408\u540c\u5728\u76f8\u540c\u7ec4\u7ec7\u4e0b\u5df2\u7ecf\u5b8c\u5de5\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\uff01");
        }
        LambdaQueryWrapper lambdaQuery = new LambdaQueryWrapper();
        lambdaQuery.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdaQuery.eq(MaterialSupplementEntity::getMainContractId, (Object)mainContractId);
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            lambdaQuery.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
        }
        lambdaQuery.ne(MaterialSupplementEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdaQuery.ne(MaterialSupplementEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = this.materialSupplementService.count((Wrapper)lambdaQuery);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae!");
        }
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange.eq(ContractChangeEntity::getMaterialContractId, (Object)saveorUpdateVO.getMainContractId());
        lambdachange.ne(ContractChangeEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(ContractChangeEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int changeNum = this.contractChangeService.count((Wrapper)lambdachange);
        if (changeNum > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(SUPPLEMENT_BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                saveorUpdateVO.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (saveorUpdateVO.getId() == null) {
            saveorUpdateVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
        }
        MaterialSupplementEntity entity = (MaterialSupplementEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, MaterialSupplementEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        MaterialSupplementVO vo = (MaterialSupplementVO)BeanMapper.map((Object)((Object)entity), MaterialSupplementVO.class);
        this.materialContractService.updateContractIsSupplementFlag(entity.getMainContractId());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialSupplementVO> queryDetail(Long id) {
        MaterialSupplementEntity entity = (MaterialSupplementEntity)((Object)this.service.selectById(id));
        MaterialSupplementVO vo = (MaterialSupplementVO)BeanMapper.map((Object)((Object)entity), MaterialSupplementVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialSupplementVO> vos) {
        int i;
        Long[] ids = new Long[vos.size()];
        for (i = 0; i < ids.length; ++i) {
            MaterialSupplementEntity entity = (MaterialSupplementEntity)((Object)this.service.getById(vos.get(i).getId()));
            ids[i] = entity.getMainContractId();
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        for (i = 0; i < ids.length; ++i) {
            this.materialContractService.updateContractIsSupplementFlag(ids[i]);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialSupplementVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialSupplementVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

