package com.ejianc.business.material.controller.api;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.material.bean.PurchaseSettlementEntity;
import com.ejianc.business.material.service.IPurchaseSettlementService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.poi.xssf.usermodel.examples.BigGridDemo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static cn.hutool.json.XMLTokener.entity;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/24 物资采购结算api
 * @Description MaterialSettlementApi
 */

@RestController
@RequestMapping("/api/purchaseSettlement/")
public class MaterialSettlementApi {

    @Autowired
    IPurchaseSettlementService iPurchaseSettlementService;

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/24 更新结算单累计已申请金额，其中currentApplyAmount  本期申请金额  可正可负，正为审批通过后调用，负为逆操作调用
     * @Description updateSettlementBillAlreadyApplyAmount
     * @Param settlementBillId  结算单id
     * @Param currentApplyAmount  本期申请金额
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @GetMapping(value = "updateSettlementBillAlreadyApplyAmount")
    public CommonResponse<String> updateSettlementBillAlreadyApplyAmount(@RequestParam("settlementBillId") Long settlementBillId,@RequestParam("currentApplyAmount") BigDecimal currentApplyAmount){
        if(settlementBillId == null || currentApplyAmount == null){
            return CommonResponse.error("参数不能为空！");
        }
        PurchaseSettlementEntity entity = iPurchaseSettlementService.selectById(settlementBillId);
        if(entity == null){
            return CommonResponse.error("没有找到相应物资采购结算单！");
        }
        BigDecimal currentSettlementAmountTax = entity.getCurrentSettlementAmountTax();
        BigDecimal alreadyApplyAmount = entity.getCurrentApplyAmount();
        if(alreadyApplyAmount == null){
            alreadyApplyAmount = new BigDecimal("0.00");
        }
        alreadyApplyAmount = alreadyApplyAmount.add(currentApplyAmount).setScale(2,BigDecimal.ROUND_HALF_UP);
        entity.setCurrentApplyAmount(alreadyApplyAmount);
        if(currentSettlementAmountTax == null){
            currentSettlementAmountTax = new BigDecimal("0.00");
        }
        /**
         * 剩余可以申请金额 = 本期结算金额（含税）-累计已申请金额-本期抵扣金额
         */
        BigDecimal remainCanApplyAmount = currentSettlementAmountTax.subtract(alreadyApplyAmount).subtract(entity.getOffsetAmountInCurrentPeriod()).setScale(2,BigDecimal.ROUND_HALF_UP);
        entity.setRemainCanApplyAmount(remainCanApplyAmount);
        iPurchaseSettlementService.saveOrUpdate(entity,false);
        return CommonResponse.success("更新物资采购结算单累计已申请金额成功！");
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/24 更新结算单累计已付款金额，currentPaidAmount  本期已付款金额  可正可负，正为审批通过后调用，负为逆操作调用
     * @Description updateSettlementBillAlreadyApplyAmount
     * @Param settlementBillId  结算单id
     * @Param currentPaidAmount  本期已付款金额
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @GetMapping(value = "updateSettlementBillAlreadyPaidAmount")
    public CommonResponse<String> updateSettlementBillAlreadyPaidAmount(@RequestParam("settlementBillId") Long settlementBillId,@RequestParam("currentPaidAmount") BigDecimal currentPaidAmount){
        if(settlementBillId == null || currentPaidAmount == null){
            return CommonResponse.error("参数不能为空！");
        }
        PurchaseSettlementEntity entity = iPurchaseSettlementService.selectById(settlementBillId);
        if(entity == null){
            return CommonResponse.error("没有找到相应物资采购结算单！");
        }
        BigDecimal alreadyPaidAmount = entity.getCurrentPaidAmount();
        if(alreadyPaidAmount == null){
            alreadyPaidAmount = new BigDecimal("0.00");
        }
        alreadyPaidAmount = alreadyPaidAmount.add(currentPaidAmount).setScale(2,BigDecimal.ROUND_HALF_UP);
        entity.setCurrentPaidAmount(alreadyPaidAmount);
        iPurchaseSettlementService.saveOrUpdate(entity,false);
        return CommonResponse.success("更新物资采购结算单累计已付款金额成功！");
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/7/14 根据合同id和组织id查询累计冲抵金额
     * @Description getTotalOffsetAmountByContractIdAndOrgId
     * @Param [contractId, orgId]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.math.BigDecimal>
     */
    @GetMapping(value = "getTotalOffsetAmountByContractIdAndOrgId")
    public CommonResponse<BigDecimal> getTotalOffsetAmountByContractIdAndOrgId(@RequestParam("contractId") Long contractId, @RequestParam("orgId") Long orgId){
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId",new Parameter(QueryParam.EQ,contractId));
        queryParam.getParams().put("orgId",new Parameter(QueryParam.EQ,orgId));
        queryParam.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<PurchaseSettlementEntity> list = iPurchaseSettlementService.queryList(queryParam,false);
        BigDecimal res = new BigDecimal("0.00");
        if(ListUtil.isNotEmpty(list)){
            for (PurchaseSettlementEntity entity : list) {
                res = res.add(entity.getOffsetAmountInCurrentPeriod()).setScale(2,BigDecimal.ROUND_HALF_UP);
            }
        }
        return CommonResponse.success(res);
    }

    /*
    【收票登记】审批通过后，回写表体【结算信息】页签对应的【物资合同结算】单据数据，
    更新对应表头字段：累计发票核销金额(无税)、累计发票核销金额(含税)
    */
    @PostMapping(value = "updateSettlementtotalInvoiceVerify")
    public CommonResponse<String> updateSettlementtotalInvoiceVerifyMny(@RequestBody List<Map<String,String>> settleList){
        if(CollectionUtils.isEmpty(settleList)){
            return CommonResponse.error("参数不能为空！");
        }
        List<PurchaseSettlementEntity> entityList = new ArrayList<>();
        for(Map<String,String> settleMap:settleList){
            PurchaseSettlementEntity entity = iPurchaseSettlementService.selectById(Long.valueOf(settleMap.get("settleId")));
            if(entity == null){
                return CommonResponse.error("没有找到相应物资采购结算单！结算单编号为："+settleMap.get("settleCode"));
            }
            entity.setTotalInvoiceVerifyMny(settleMap.get("sumVerifyMny").equals("null")?BigDecimal.ZERO:new BigDecimal(settleMap.get("sumVerifyMny")));
            entity.setTotalInvoiceVerifyTaxMny(settleMap.get("sumVerifyTaxMny").equals("null")?BigDecimal.ZERO:new BigDecimal(settleMap.get("sumVerifyTaxMny")));
            entityList.add(entity);
        }
        entityList.forEach(e -> iPurchaseSettlementService.saveOrUpdate(e,false));
        return CommonResponse.success("更新物资采购结算单累计发票核销金额成功！");
    }

    /*
    当【收票登记】从审批通过撤销后，回写表体【结算信息】页签对应的【物资合同结算】单据数据，
    更新对应表头字段：累计发票核销金额(无税)、累计发票核销金额(含税)
     */
    @PostMapping(value = "callBackSettlementtotalInvoiceVerify")
    public CommonResponse<String> callBackSettlementtotalInvoiceVerify(@RequestBody List<Map<String,String>> settleList){
        if(CollectionUtils.isEmpty(settleList)){
            return CommonResponse.error("参数不能为空！");
        }
        List<PurchaseSettlementEntity> entityList = new ArrayList<>();
        for(Map<String,String> settleMap:settleList){
            PurchaseSettlementEntity entity = iPurchaseSettlementService.selectById(Long.valueOf(settleMap.get("settleId")));
            if(entity == null){
                return CommonResponse.error("没有找到相应物资采购结算单！结算单编号为："+settleMap.get("settleCode"));
            }
            entity.setTotalInvoiceVerifyMny(settleMap.get("alreadyVerifyMny").equals("null")?BigDecimal.ZERO:new BigDecimal(settleMap.get("alreadyVerifyMny")));
            entity.setTotalInvoiceVerifyTaxMny(settleMap.get("alreadyVerifyTaxMny").equals("null")?BigDecimal.ZERO:new BigDecimal(settleMap.get("alreadyVerifyTaxMny")));
            entityList.add(entity);
        }
        entityList.forEach(e -> iPurchaseSettlementService.saveOrUpdate(e,false));
        return CommonResponse.success("更新物资采购结算单累计发票核销金额成功！");
    }

}
