/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.material.bean.ContractRecordEntity;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.service.IContractChangeService;
import com.ejianc.business.material.service.IContractRecordService;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.vo.ContractRecordVO;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/changeRecord/"})
public class MaterialContractRecordController {
    @Autowired
    private IContractRecordService contractRecordService;
    @Autowired
    private IContractChangeService contractChangeService;
    @Autowired
    private IMaterialContractService materialContractService;

    @GetMapping(value={"queryRecords"})
    public CommonResponse<JSONObject> queryRecords(@RequestParam(value="id") Long id) {
        MaterialContractEntity contract;
        JSONObject data = new JSONObject();
        List list = new ArrayList();
        QueryParam queryParam = new QueryParam();
        queryParam.getOrderMap().put("effectiveDate", "desc");
        queryParam.getParams().put("material_contract_id", new Parameter("eq", (Object)id));
        List changeRecords = this.contractRecordService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)changeRecords)) {
            list = BeanMapper.mapList((Iterable)changeRecords, ContractRecordVO.class);
            ContractRecordVO lastRecord = (ContractRecordVO)list.get(0);
            data.put("baseAmountWithTax", (Object)lastRecord.getBaseTaxMoney());
            data.put("changingTaxMny", (Object)lastRecord.getChangingTaxMny());
            data.put("changeAmount", (Object)lastRecord.getChangingTaxMny().subtract(lastRecord.getAmountWithTax()));
            data.put("changeCount", (Object)list.size());
            data.put("totalChangeRate", (Object)lastRecord.calculateTotalChangeRatio());
            for (ContractRecordVO contractRecordVO : list) {
                String changeTime = new SimpleDateFormat("yyyyMMdd").format(contractRecordVO.getChangeDate());
                String historyBillCode = contractRecordVO.getBeforeContractName() + "-" + changeTime + "-" + contractRecordVO.getChangeVersion();
                contractRecordVO.setHistoryBillCode(historyBillCode);
            }
        }
        data.put("isChanging", (Object)(null != (contract = (MaterialContractEntity)((Object)this.materialContractService.selectById(id))).getChangeState() && MaterialContractVO.CONTRACT_CHANGE_STATE_CHANGING.equals(contract.getChangeState()) ? 1 : 0));
        data.put("contractId", (Object)contract.getId());
        data.put("id", (Object)contract.getId());
        data.put("settlementType", (Object)contract.getSettlementType());
        data.put("changeState", (Object)contract.getChangeState());
        data.put("changeRecords", list);
        data.put("orgId", (Object)contract.getPurchaseOrgId());
        return CommonResponse.success((String)"\u67e5\u8be2\u5408\u540c\u53d8\u66f4\u8bb0\u5f55\u6210\u529f\uff01", (Object)data);
    }

    @GetMapping(value={"queryDetail"})
    public CommonResponse<ContractRecordVO> queryDetail(@RequestParam(value="id") Long id) {
        ContractRecordEntity entity = (ContractRecordEntity)((Object)this.contractRecordService.selectById(id));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)entity), ContractRecordVO.class));
    }
}

