package com.ejianc.business.material.vo;


import java.math.BigDecimal;

/**
 * @author CJ
 * @Description: 物资合同-物资明细导出
 * @date 2024/1/25 15:15
 */
public class MaterialContractDetailSubExportVo {




    /**
     * 物资分类名称
     */
    private String materialTypeName;

    /**
     * 物资名称
     */
    private String materialName;

    /**
     * 规则/型号
     */
    private String spec;

    /**
     * 计量单位
     */
    private String measureUnit;

    /**
     * 数量
     */
    private BigDecimal count;

    /**
     * 单价
     */
    private BigDecimal unitPrice;

    /**
     * 金额
     */
    private BigDecimal totalAmount;

    /**
     * 备注
     */
    private String materialRemark;

    /**
     * 物资来源类型：1-物料档案，2-用料申请，3-询价单
     */
    private String sourceType;



    /**
     * 单价(含税)
     */
    private BigDecimal taxUnitPrice;
    /**
     * 金额(含税)
     */
    private BigDecimal taxTotalAmount;
    /**
     * 税额
     */
    private BigDecimal taxDetail;
    /**
     * 税率
     */
    private BigDecimal taxDetailRate;
    
    private BigDecimal sumNum;
    
    

    public BigDecimal getSumNum() {
		return sumNum;
	}

	public void setSumNum(BigDecimal sumNum) {
		this.sumNum = sumNum;
	}

	public BigDecimal getTaxUnitPrice() {
        return taxUnitPrice;
    }

    public void setTaxUnitPrice(BigDecimal taxUnitPrice) {
        this.taxUnitPrice = taxUnitPrice;
    }

    public BigDecimal getTaxTotalAmount() {
        return taxTotalAmount;
    }

    public void setTaxTotalAmount(BigDecimal taxTotalAmount) {
        this.taxTotalAmount = taxTotalAmount;
    }

    public BigDecimal getTaxDetail() {
        return taxDetail;
    }

    public void setTaxDetail(BigDecimal taxDetail) {
        this.taxDetail = taxDetail;
    }

    public BigDecimal getTaxDetailRate() {
        return taxDetailRate;
    }

    public void setTaxDetailRate(BigDecimal taxDetailRate) {
        this.taxDetailRate = taxDetailRate;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getMeasureUnit() {
        return measureUnit;
    }

    public void setMeasureUnit(String measureUnit) {
        this.measureUnit = measureUnit;
    }

    public BigDecimal getCount() {
        return count;
    }

    public void setCount(BigDecimal count) {
        this.count = count;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getMaterialRemark() {
        return materialRemark;
    }

    public void setMaterialRemark(String materialRemark) {
        this.materialRemark = materialRemark;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
}
