package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.equipment.api.ISettlementApi;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.bean.PurchaseSettlementEntity;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.service.IPurchaseSettlementService;
import com.ejianc.business.material.vo.*;
import com.ejianc.business.sub.api.ISubReportApi;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceReceiveRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2020/6/8 10:47
 */
@RestController
@RequestMapping("/materialContract/")
public class MaterialContractController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static volatile HttpServletRequest request;

    @Autowired
    private IMaterialContractService materialContractService;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IProjectApi iProjectApi;

    @Autowired
    private IInvoiceApi iInvoiceApi;

    @Autowired
    private IPayContractApi payContractApi;

    @Autowired
    private ISettlementApi settlementApi;

    @Autowired
    private ISubReportApi subReportApi;

    @Autowired
    private IPurchaseSettlementService purchaseSettlementService;

    @Value("${common.env.base-host}")
    public String BASE_HOST;
    
    @Autowired
    private MaterialContractMapper materialContractMapper;


    /***
     * @description: 合同/变更参数校验
     *
     * @param isJc
     * @param vo
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.ParamsCheckVO>
     * @author songlx
     * @date: 2021-06-08
     */
    // 【物资总计划量】控制【物资合同量】P-8N9Au207 集采不受控制
    // 总计划价格【物资总计划价】控制【物资合同价】P-2Ux27w08  集采不受控制
    // 结算历史价格区间【历史价】控制【物资合同价】P-126hYD10
    //控制方式 0：不控制，1、提醒，2、无法保存
    @PostMapping("checkParams/{isJc}")
    public CommonResponse<ParamsCheckVO> checkParams(@PathVariable(name = "isJc") Integer isJc,
                                                     @RequestBody MaterialPriceVO vo) {

        ParamsCheckVO paramsCheckVO = materialContractService.checkParams(isJc, vo.getContractId(), vo);

        return CommonResponse.success("参数校验成功！", paramsCheckVO);
    }


    /***
     * @description: 单据参数控制
     *      * 查询总计划单价和历史价格区间
     * @param vo
     * @return: com.ejianc.framework.core.response.CommonResponse<java.util.List < com.ejianc.business.material.vo.MaterialPriceVO>>
     * @author songlx
     * @date: 2021-05-26
     */
    @PostMapping("queryPrice/{isJc}")
    public CommonResponse<List<MaterialPriceVO>> queryPrice(@PathVariable(name = "isJc") Integer isJc,
                                                            @RequestBody MaterialPriceVO vo) {
        materialContractService.queryPrice(isJc, null, vo);
        return CommonResponse.success("查询成功！", vo.getDetail());
    }


    /**
     * 　* @Description: 物资合同分页列表查询, 查询范围：本下的所有合同+上级的审批通过的集采合同
     * 　* @param [queryParam]
     * 　* @return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
     * 　* @throws
     * 　* @author CJ
     * 　* @date 2020/6/8 11:22
     */
    @PostMapping(value = "pageList")
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        JSONObject resp = new JSONObject();
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("supplierName");
//        queryParam.getFuzzyFields().add("orgName");
        queryParam.getFuzzyFields().add("purchaseOrgName");
        queryParam.getFuzzyFields().add("projectCode");
        queryParam.getFuzzyFields().add("projectName");
        //查询不是补充协议的合同
        queryParam.getParams().put("supplement_flag",new Parameter(QueryParam.EQ,0));

        queryParam.getComplexParams().add(getPageQueryParam(null));

        IPage<MaterialContractEntity> pageData = materialContractService.queryPage(queryParam, false);

        //页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = materialContractService.countContractAmount(queryParam);

        resp.put("records", pageData.getRecords());
        resp.put("total", pageData.getTotal());
        resp.put("size", pageData.getSize());
        resp.put("current", pageData.getCurrent());
        resp.put("pages", pageData.getPages());
        resp.put("materialCount", contractAmountMap);

        return CommonResponse.success("合同分页列表查询成功！", resp);
    }

    public ComplexParam getPageQueryParam(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        if (null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentId(orgId);
        CommonResponse<List<OrgVO>> parentOrgResp = orgApi.findParentsByOrgId(orgId);
        if (!childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            throw new BusinessException("合同分页列表查询失败, 查询组织信息失败！");
        }

        List<Long> parentOrgIds = new ArrayList<>();
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        parentOrgIds.addAll(parentOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        parentOrgIds.remove(orgId);

        // 本下
        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("purchase_org_id", new Parameter(QueryParam.IN, childIds));
        c1.getComplexParams().add(c2);

        // 本上集采+已生效
        if (CollectionUtils.isNotEmpty(parentOrgIds)) {
            ComplexParam c3 = new ComplexParam();
            c3.setLogic(ComplexParam.OR);
            c3.getParams().put("depend_on_project", new Parameter(QueryParam.EQ, "0"));
            c3.getParams().put("purchase_org_id", new Parameter(QueryParam.IN, parentOrgIds));
            c1.getComplexParams().add(c3);
            c3.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        }

        // 本上代签+已生效
        if(CollectionUtils.isNotEmpty(parentOrgIds)) {
            ComplexParam c4 = new ComplexParam();
            c4.setLogic(ComplexParam.OR);
            c4.getParams().put("depend_on_project", new Parameter(QueryParam.EQ, "1"));
            c4.getParams().put("replace_sign_flag", new Parameter(QueryParam.EQ, 1));
            c4.getParams().put("purchase_org_id", new Parameter(QueryParam.IN, parentOrgIds));
            c4.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
            c1.getComplexParams().add(c4);
        }

        return c1;
    }

    /**
     * 　* @Description: 物资合同更新、保存
     * 　* @param [materialContractVO]
     * 　* @return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.MaterialContractVO>
     * 　* @throws
     * 　* @author CJ
     * 　* @date 2020/6/8 10:54
     */
    @PostMapping("saveOrUpdate")
    public CommonResponse<MaterialContractVO> save(@RequestBody MaterialContractVO materialContractVO) {
    	Integer count = materialContractMapper.countClosing(materialContractVO.getProjectId());
        if(count != 0){
            throw new BusinessException("本项目下存在尚未过审的成本关门预估单，请先过审！");
        }
        boolean checkResult = materialContractService.codeCheck(materialContractVO.getId(), materialContractVO.getCode());
        if (!checkResult) {
            return CommonResponse.error("保存失败，合同编码重复");
        }

        MaterialContractVO resp = materialContractService.save(materialContractVO);

        this.queryMaterialPrice(resp);
        return CommonResponse.success("保存成功！", resp);
    }
    

    /**
     * 　* @Description: 物资合同列表导出
     * 　* @param [queryParam, response]
     * 　* @return void
     * 　* @throws
     * 　* @author CJ
     * 　* @date 2020/6/8 10:55
     */
    @PostMapping("excelExport")
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        JSONObject resp = new JSONObject();
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("supplierName");
//        queryParam.getFuzzyFields().add("orgName");
        queryParam.getFuzzyFields().add("purchaseOrgName");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(-1);
        //查询不是补充协议的合同
        queryParam.getParams().put("supplement_flag",new Parameter(QueryParam.EQ,0));

        queryParam.getComplexParams().add(getPageQueryParam(null));


        IPage<MaterialContractEntity> pageData = materialContractService.queryPage(queryParam, false);
        Map<String, Object> beans = new HashMap<String, Object>();
        List<ContractExportVO> list = new ArrayList<>();
        List<MaterialContractEntity> data = pageData.getRecords();
        if (CollectionUtils.isNotEmpty(data)) {
            data.forEach(contract -> {
                ContractExportVO vo = BeanMapper.map(contract, ContractExportVO.class);
                vo.setCreateTime(DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", contract.getCreateTime()));
                vo.setSignDate(DateFormatUtil.formatDate("yyyy-MM-dd", contract.getSignDate()));
                vo.setChangeStateName(contract.getChangeState().equals(MaterialContractVO.CONTRACT_CHANGE_STATE_UNCHANGED) ? "未变更" : contract.getChangeState().equals(MaterialContractVO.CONTRACT_CHANGE_STATE_CHANGING) ? "变更中" : "已变更");
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(contract.getBillState()).getDescription());
                list.add(vo);
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("contract-export.xlsx", beans, response);
    }

    @PostMapping("delete")
    public CommonResponse<String> delete(@RequestBody List<MaterialContractVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            materialContractService.removeByIds(vos.stream().map(MaterialContractVO::getId).collect(Collectors.toList()), false);
        }
        return CommonResponse.success("删除成功！");
    }

    @GetMapping("queryDetail")
    public CommonResponse<MaterialContractVO> queryDetail(@RequestParam(value = "id") Long id) {
        MaterialContractVO vo = null;
        MaterialContractEntity dbEntity = materialContractService.selectById(id);
        if (null != dbEntity) {
            vo = BeanMapper.map(dbEntity, MaterialContractVO.class);
            this.queryMaterialPrice(vo);
        }

        return CommonResponse.success("查询物资合同详情成功！", vo);
    }


    @GetMapping("queryDetailAndPrice")
    public CommonResponse<MaterialContractVO> queryDetailAndPrice(@RequestParam(value = "id") Long id) {
        MaterialContractVO vo = null;
        MaterialContractEntity dbEntity = materialContractService.selectById(id);
        if (null != dbEntity) {
            vo = BeanMapper.map(dbEntity, MaterialContractVO.class);
            this.queryMaterialPrice(vo);

        }
        return CommonResponse.success("查询物资合同详情成功！", vo);
    }

    private void queryMaterialPrice(MaterialContractVO vo) {

        if (CollectionUtils.isNotEmpty(vo.getMaterialDetailList())) {
            for (MaterialContractDetailSubVO event:vo.getMaterialDetailList()){
                if(StringUtils.isEmpty(event.getMaterialId())){
                    return;
                }
            }
        }else{
            return;
        }

        //根据单据参数控制查询总计划量\价,历史价格区间
        List<MaterialContractDetailSubVO> materialDetailList = vo.getMaterialDetailList();
        if (CollectionUtils.isNotEmpty(materialDetailList)) {
            MaterialPriceVO priceVO = new MaterialPriceVO(vo.getProjectId());
            List<MaterialPriceVO> detail = new ArrayList<>();
            materialDetailList.forEach(item -> {
                MaterialPriceVO materialPriceVO = new MaterialPriceVO();
                materialPriceVO.setMaterialId(Long.valueOf(item.getMaterialId()));
                detail.add(materialPriceVO);
            });
            priceVO.setDetail(detail);
            //1集采 2项目自采
            Integer isJc = "1".equals(vo.getPurchaseMode()) ? 1 : 0;
            MaterialPriceVO materialPriceVO = materialContractService.queryPrice(isJc, vo.getId(), priceVO);
            List<MaterialPriceVO> dd = materialPriceVO.getDetail();
            if (CollectionUtils.isNotEmpty(dd)) {
                Map<Long, MaterialPriceVO> priceVOMap = dd.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account, (v1, v2) -> v2));
                for (MaterialContractDetailSubVO v : materialDetailList) {
                    String materialId = v.getMaterialId();
                    MaterialPriceVO p = priceVOMap.get(Long.valueOf(materialId));
                    if (null != p) {
                        v.setPlanNum(p.getPlanNum());
                        v.setPlanPrice(p.getPlanPrice());
                        v.setMinPrice(p.getMinPrice());
                        v.setMaxPrice(p.getMaxPrice());
                        v.setPriceArea(p.getPriceArea());
                    }
                }
            }
        }
    }

    /**
     * 物资合同列表参照
     *
     * @return
     */
    @GetMapping("contractListRefer")
    public CommonResponse<IPage<MaterialContractEntity>> contractListRefer(@RequestParam(required = false) String condition,
                                                                           @RequestParam(required = false) String searchText,
                                                                           @RequestParam int pageSize,
                                                                           @RequestParam int pageNumber,
                                                                           @RequestParam(required = false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("supplier_name");
        //按照合同审批通过时间倒序排列
        queryParam.getOrderMap().put("effective_date", QueryParam.DESC);
        //查询不是最终结算
        /** 根据结算类型过滤 结算单参照时，传settlementType为1-最终结算  返回数据时查询的是不等于1的数据*/
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("settlementType")) {
                Integer settlementType = Integer.valueOf(conditionMap.get("settlementType").toString());
                queryParam.getParams().put("settlementType", new Parameter(QueryParam.NE, settlementType));
            }
        }

        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);
        //只查询审批通过的合同
        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, billStateList));
        //查询不是补充协议的合同
        queryParam.getParams().put("supplement_flag",new Parameter(QueryParam.EQ,0));

        if (StringUtils.isNotBlank(searchText)) {
            queryParam.setSearchText(searchText);
        }

        Long orgId = InvocationInfoProxy.getOrgId();

        if (StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("mobileLeave")) {
                /** 移动端 有组织id 逻辑同pc端，没组织id 查租户下所有集采 */
                if (null != conditionMap.get("orgId")) {
                    orgId = Long.valueOf(conditionMap.get("orgId").toString());
                    queryParam.getComplexParams().add(getPageQueryParam(orgId));
                } else {
                    queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
                    queryParam.getParams().put("dependOnProject", new Parameter(QueryParam.EQ, "0"));
                }
            } else {
                if (null != conditionMap.get("orgId")) {
                    orgId = Long.valueOf(conditionMap.get("orgId").toString());
                }
                if (null != conditionMap.get("supplierId")) {
                    queryParam.getParams().put("supplier_id", new Parameter(QueryParam.EQ, Long.valueOf(conditionMap.get("supplierId").toString())));
                }
                if (StringUtils.isNotBlank(searchObject)) {
                    JSONObject search = JSONObject.parseObject(searchObject);
                    for (String key : search.keySet()) {
                        queryParam.getParams().put(key, new Parameter(QueryParam.LIKE, search.get(key).toString()));
                    }
                }
                queryParam.getComplexParams().add(getPageQueryParam(orgId));
            }
            /** 根据项目过滤 */
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
        } else {
            if (StringUtils.isNotBlank(searchObject)) {
                JSONObject search = JSONObject.parseObject(searchObject);
                for (String key : search.keySet()) {
                    queryParam.getParams().put(key, new Parameter(QueryParam.LIKE, search.get(key).toString()));
                }
            }
            queryParam.getComplexParams().add(getPageQueryParam(orgId));
        }
        IPage<MaterialContractEntity> pageData = materialContractService.queryPage(queryParam, false);

        return CommonResponse.success("查询合同列表成功！", pageData);
    }

    /**
     * 合同状态修改
     *
     * @param materialContractVO
     * @return
     */
    @PostMapping("changeState")
    public CommonResponse<String> changeState(@RequestBody MaterialContractVO materialContractVO) {
        MaterialContractEntity contract = materialContractService.selectById(materialContractVO.getId());
        contract.setState(materialContractVO.getState());
        contract.setStateName(materialContractVO.getStateName());
        materialContractService.saveOrUpdate(contract, false);

        return CommonResponse.success("修改合同状态成功！");
    }

    /**
     * 合同编码重复校验
     *
     * @return
     */
    @PostMapping("codeCheck")
    public CommonResponse<String> checkContractCode(@RequestBody MaterialContractVO contract) {
        boolean result = materialContractService.codeCheck(contract.getId(), contract.getCode());
        if (!result) {
            return CommonResponse.error("编码重复，请重新输入！");
        }
        return CommonResponse.success("编码可以使用！");
    }

    /**
     * 查询合同收票统计记录
     *
     * @param id 合同ID
     * @return
     */
    @RequestMapping("invoiceRecRecords")
    public CommonResponse<JSONObject> queryContractInvoiceRecRecords(@RequestParam(value = "id") Long id) {
        JSONObject data = new JSONObject();

//        QueryParam queryParam = new QueryParam();
//        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, id));
//        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
//        MaterialContractEntity contract = materialContractService.selectById(id);
//        if(!MaterialContractVO.CONTRACT_BELONG_PROJECT.equals(contract.getDependOnProject())) {
//            // 集采查询组织本下审批通过、已提交的结算
//            Long orgId = InvocationInfoProxy.getOrgId();
//            CommonResponse<List<OrgVO>> orgResp = orgApi.findChildrenByParentId(orgId);
//            if(!orgResp.isSuccess()) {
//                return CommonResponse.error("查询合同收票记录失败，获取组信息失败！");
//            }
//            List<Long> orgIds = orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
//            queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));
//        }

        //累计付款金额
        BigDecimal totalPayAmount = BigDecimal.ZERO.setScale(8);
        CommonResponse<SumPayMnyVO> payResp = payContractApi.getSumPayMnyVOList(id, InvocationInfoProxy.getOrgId());
        if (!payResp.isSuccess()) {
            return CommonResponse.error("查询合同收票记录失败，获合同付款信息失败！");
        }
        SumPayMnyVO payRecords = payResp.getData();
        if (null != payRecords.getSumPayMny()) {
            totalPayAmount = payRecords.getSumPayMny();
        }

        //累计结算金额
        BigDecimal totalSettlementAmount = getTotalSettleAmount(id);
        //欠收发票金额
        BigDecimal dueInInvoiceAmount = null;

        CommonResponse<InvoiceReceiveRecordVO> records = iInvoiceApi.getInvoiceReceiveRecord(id);
        if (!records.isSuccess()) {
            return CommonResponse.error("查询合同收票统计记录失败！");
        }
        InvoiceReceiveRecordVO irr = records.getData();
        //累计结算减去累计收票含税
        dueInInvoiceAmount = totalSettlementAmount.subtract(irr.getInvoiceTaxMny()!= null?irr.getInvoiceTaxMny():BigDecimal.ZERO);
        if (dueInInvoiceAmount.compareTo(BigDecimal.ZERO.setScale(8, BigDecimal.ROUND_HALF_UP)) < 0) {
            dueInInvoiceAmount = BigDecimal.ZERO;
        }

        //合同Id
        data.put("contractId", id);
        //累计税金
        data.put("totalTaxAmount", irr.getTaxMny());
        //累计收票金额（含税）
        data.put("totalInvoiceRecTaxAmount", irr.getInvoiceTaxMny());
        //累计收票金额
        data.put("totalInvoiceRecAmount", irr.getInvoiceMny());
        //收票记录列表
        data.put("invoiceRecRecords", irr.getInvoiceReceiveVOList());
        //累计结算金额
        data.put("cumulativePayAmount", totalSettlementAmount);
        //累计付款金额
        data.put("totalPayAmount", totalPayAmount);
        //欠收发票金额
        data.put("dueInInvoiceAmount", dueInInvoiceAmount);

        return CommonResponse.success("查询合同收票记录成功！", data);
    }

    /**
     * 合同付款记录查询
     *
     * @param id 合同Id
     * @return
     */
    @GetMapping("paymentRecords")
    public CommonResponse<JSONObject> queryPaymentRecords(@RequestParam(value = "id") Long id) {
        JSONObject data = new JSONObject();

        MaterialContractEntity contractEntity = materialContractService.selectById(id);

        //累计付款金额
        BigDecimal totalPayAmount = BigDecimal.ZERO.setScale(8);
        CommonResponse<SumPayMnyVO> payResp = payContractApi.getSumPayMnyVOList(id, InvocationInfoProxy.getOrgId());
        if (!payResp.isSuccess()) {
            return CommonResponse.error("查询合同付款记录失败，获合同付款信息失败！");
        }
        SumPayMnyVO payRecords = payResp.getData();
        if (null != payRecords.getSumPayMny()) {
            totalPayAmount = payRecords.getSumPayMny();
        }

        //累计结算金额
        BigDecimal totalSettlementAmount = getTotalSettleAmount(id);

        //合同Id
        data.put("contractId", id);
        //累计付款金额
        data.put("totalPayAmount", totalPayAmount);
        //累计结算金额
        data.put("totalSettlementAmount", totalSettlementAmount);
        //约定支付比例
        data.put("aggreedPaymentRatio", contractEntity.getAggreedPaymentRatio());
        //约定支付金额
        data.put("aggreedPaymentAmount", totalSettlementAmount.multiply(new BigDecimal((null != contractEntity.getAggreedPaymentRatio() ? contractEntity.getAggreedPaymentRatio() : 100) / 100).setScale(8, BigDecimal.ROUND_HALF_UP)));
        //累计已付比例
        Double totalPayRatio = 0d;
        if (totalSettlementAmount.compareTo(BigDecimal.ZERO.setScale(8)) != 0) {
            totalPayRatio = totalPayAmount.divide(totalSettlementAmount, 8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100).setScale(8)).doubleValue();
        }
        data.put("totalPayRatio", totalPayRatio);
        data.put("payRecords", payRecords.getContractVOList());

        return CommonResponse.success("查询合同付款记录成功！", data);
    }

    private BigDecimal getTotalSettleAmount(Long contractId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        MaterialContractEntity contract = materialContractService.selectById(contractId);
        if (!MaterialContractVO.CONTRACT_BELONG_PROJECT.equals(contract.getDependOnProject())) {
            // 集采查询组织本下审批通过、已提交的结算
            Long orgId = InvocationInfoProxy.getOrgId();
            CommonResponse<List<OrgVO>> orgResp = orgApi.findChildrenByParentId(orgId);
            if (!orgResp.isSuccess()) {
                throw new BusinessException("查询合同收票记录失败，获取组信息失败！");
            }
            List<Long> orgIds = orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
            queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));
        }

        return purchaseSettlementService.calculateTotalSettlement(queryParam);
    }

    @GetMapping("getOutContractTotalAmount")
    public CommonResponse<JSONObject> getOutContractTotalAmount(@RequestParam Integer type
            , @RequestParam(value = "orgId", required = false) Long orgId, HttpServletRequest req) {
        request = req;
        QueryParam queryParam = new QueryParam();
        /** 移动端  收入合同统计金额要去掉 补充协议的金额 2021年8月14日*/
        queryParam.getParams().put("supplement_flag",new Parameter("eq",0));//过滤补合同充协议

        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));//租户隔离
//        queryParam.getParams().put("dependOnProject", new Parameter(QueryParam.EQ, "1"));//属于项目
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));//单据状态已提交和审批通过

        List<Long> newIds = new ArrayList<>();
        if (orgId != null) {
            queryParam.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//            CommonResponse<List<ProjectRegisterVO>> listCommonResponse = iProjectApi.queryChildrenProjectByOrgId(orgId);
//            if (listCommonResponse.isSuccess()) {
//                List<ProjectRegisterVO> list = listCommonResponse.getData();
//                newIds = list.stream().map(ProjectRegisterVO::getId).collect(Collectors.toList());
//            }
        }else {
            queryParam.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

//        List<Long> projectIds = new ArrayList<>();
//        if (type != 1) {//全部项目的合同
//            CommonResponse<List<Long>> commonResponse = iProjectApi.getProjectIdsByProperties(type);
//            if (commonResponse.isSuccess()) {
//                projectIds = commonResponse.getData();
//                if (ListUtil.isNotEmpty(projectIds)) {
//                    // 根据组织过滤projectIds
//                    if (orgId != null) {
//                        projectIds = projectIds.stream().filter(newIds::contains).collect(Collectors.toList());
//                    }
//                    if (ListUtil.isNotEmpty(projectIds)) {
//                        queryParam.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));
//                    }
//                } else {
//                    JSONObject back = new JSONObject();
//                    back.put("contract", "0.00");
//                    back.put("settle", "0.00");
//                    back.put("invoiceTaxMny", "0.00");
//                    back.put("payApplyAmount", "0.00");
//                    return CommonResponse.success(back);
//                }
//            }
//        }else {
//            projectIds = newIds;
//        }
        List<MaterialContractEntity> contractEntities = materialContractService.queryList(queryParam, false);
        queryParam.getParams().remove("supplement_flag");
        queryParam.getParams().remove("dependOnProject");
//        queryParam.getParams().put("belongToProject", new Parameter(QueryParam.EQ, "1"));//属于项目
        List<PurchaseSettlementEntity> settlementEntities = purchaseSettlementService.queryList(queryParam, false);
        BigDecimal contract = new BigDecimal("0.00");
        BigDecimal settle = new BigDecimal("0.00");
        BigDecimal invoiceTaxMny = new BigDecimal("0.00");
        BigDecimal payApplyAmount = new BigDecimal("0.00");
        if (ListUtil.isNotEmpty(contractEntities)) {
            for (MaterialContractEntity c : contractEntities) {
                contract = contract.add(c.getAmountWithTax() == null ? new BigDecimal("0.00") : c.getAmountWithTax());
            }
        }
        if (ListUtil.isNotEmpty(settlementEntities)) {
            for (PurchaseSettlementEntity c : settlementEntities) {
                settle = settle.add(c.getCurrentSettlementAmountTax() == null ? new BigDecimal("0.00") : c.getCurrentSettlementAmountTax());
            }
        }
        logger.info("移动首页，查询支出结算，物资结算：{}，物资合同：{}", settle, contract);

        JSONObject back = getOtherContractAmount(orgId);
        contract = contract.add(back.getBigDecimal("contract")).divide(new BigDecimal("10000")).setScale(2, BigDecimal.ROUND_HALF_UP);
        settle = settle.add(back.getBigDecimal("settle")).divide(new BigDecimal("10000")).setScale(2, BigDecimal.ROUND_HALF_UP);
        invoiceTaxMny = invoiceTaxMny.add(back.getBigDecimal("invoiceTaxMny")).divide(new BigDecimal("10000")).setScale(2, BigDecimal.ROUND_HALF_UP);
        payApplyAmount = payApplyAmount.add(back.getBigDecimal("payApplyAmount")).divide(new BigDecimal("10000")).setScale(2, BigDecimal.ROUND_HALF_UP);
        back = new JSONObject();
        back.put("contract", contract);
        back.put("settle", settle);
        back.put("invoiceTaxMny", invoiceTaxMny);
        back.put("payApplyAmount", payApplyAmount);
        return CommonResponse.success(back);
    }

    private JSONObject getOtherContractAmount(Long orgId) {
        //创建一个固定数量的线程池
        ExecutorService threadPool = Executors.newFixedThreadPool(6);
        BigDecimal contract = new BigDecimal("0.00");
        BigDecimal settle = new BigDecimal("0.00");
        BigDecimal invoiceTaxMny = new BigDecimal("0.00");
        BigDecimal payApplyAmount = new BigDecimal("0.00");
        Callable<JSONObject> equipmentContractAmountNum = new PostDataCallable(BASE_HOST + "ejc-equipment-web/purchaseContract/getEquipmentContractTotalAmount", orgId);
        Future<JSONObject> future1 = threadPool.submit(equipmentContractAmountNum);
        Callable<JSONObject> subContractAmountNum = new PostDataCallable(BASE_HOST + "ejc-sub-web/contract/getSubContractTotalAmount", orgId);
        Future<JSONObject> future2 = threadPool.submit(subContractAmountNum);
        Callable<JSONObject> tax = new PostDataCallable(BASE_HOST + "ejc-tax-web/invoiceReceive/getTotalInvoiceTaxMnyByProjectIds", orgId);
        Future<JSONObject> future3 = threadPool.submit(tax);
        Callable<JSONObject> finance = new PostDataCallable(BASE_HOST + "ejc-finance-web/payContract/getTotalPayApplyAmountByProjectIds", orgId);
        Future<JSONObject> future4 = threadPool.submit(finance);
        /** 周转材租赁  */
        Callable<JSONObject> rmat = new PostDataCallable(BASE_HOST + "ejc-rmat-web/rentContract/getRmatContractTotalAmount", orgId);
        Future<JSONObject> future5 = threadPool.submit(rmat);
        /** 其他合同  */
        Callable<JSONObject> other = new PostDataCallable(BASE_HOST + "ejc-other-web/otherContract/getOtherContractTotalAmount", orgId);
        Future<JSONObject> future6 = threadPool.submit(other);

        // 同步pc端累计支出金额 看错需求了，先放这吧
//        payApplyAmount = materialContractService.queryTotalOutMoney(orgId);
        try {
            JSONObject c1 = future1.get();
            if (c1.getInteger("code") == 0) {

                JSONObject data = c1.getJSONObject("data");
                contract = contract.add(data.getBigDecimal("contract"));
                settle = settle.add(data.getBigDecimal("settle"));
                logger.info("移动首页，查询支出结算，设备结算c1：{}，设备合同：{}", data.getBigDecimal("settle"), data.getBigDecimal("contract"));
            }else {
                logger.info("移动首页，查询支出累计合同付款出错c1：{} ", c1);
            }
            JSONObject c2 = future2.get();
            if (c2.getInteger("code") == 0) {
                JSONObject data = c2.getJSONObject("data");
                contract = contract.add(data.getBigDecimal("contract"));
                settle = settle.add(data.getBigDecimal("settle"));
                logger.info("移动首页，查询支出结算，分包结算c2：{}，设备合同：{}", data.getBigDecimal("settle"), data.getBigDecimal("contract"));
            }else {
                logger.info("移动首页，查询支出累计合同付款出错c2：{} ", c2);
            }
            JSONObject c5 = future5.get();
            if (c5.getInteger("code") == 0) {
                JSONObject data = c5.getJSONObject("data");
                contract = contract.add(data.getBigDecimal("contract"));
                settle = settle.add(data.getBigDecimal("settle"));
                logger.info("移动首页，查询支出结算，周转材结算c5：{}，设备合同：{}", data.getBigDecimal("settle"), data.getBigDecimal("contract"));
            }else {
                logger.info("移动首页，查询支出累计合同付款出错c5：{} ", c5);
            }
            JSONObject c6 = future6.get();
            if (c6.getInteger("code") == 0) {
                JSONObject data = c6.getJSONObject("data");
                contract = contract.add(data.getBigDecimal("contract"));
                settle = settle.add(data.getBigDecimal("settle"));
                logger.info("移动首页，查询支出结算，其他合同结算c6：{}，设备合同：{}", data.getBigDecimal("settle"), data.getBigDecimal("contract"));
            }else {
                logger.info("移动首页，查询支出累计合同付款出错c6：{} ", c6);
            }
            JSONObject c3 = future3.get();
            if (c3.getInteger("code") == 0) {
                JSONObject data = c3.getJSONObject("data");
                invoiceTaxMny = invoiceTaxMny.add(data.getBigDecimal("invoiceTaxMny"));
                logger.info("移动首页，查询支出合同收票c3：{} ", data.getBigDecimal("invoiceTaxMny"));
            }else {
                logger.info("移动首页，查询支出累计合同付款出错c3：{} ", c3);
            }
            JSONObject c4 = future4.get();
            if (c4.getInteger("code") == 0) {
                JSONObject data = c4.getJSONObject("data");
                payApplyAmount = payApplyAmount.add(data.getBigDecimal("payApplyAmount"));
                logger.info("移动首页，查询支出累计合同付款c4：{} ", data.getBigDecimal("payApplyAmount"));
            }else {
                logger.info("移动首页，查询支出累计合同付款出错c4：{} ", c4);
            }
        } catch (Exception e) {
            logger.error("移动首页，查询支出合同统计出错：{} ", e.getMessage());
            e.printStackTrace();
        } finally {
            threadPool.shutdown();
        }
        JSONObject back = new JSONObject();
        back.put("contract", contract);
        back.put("settle", settle);
        back.put("invoiceTaxMny", invoiceTaxMny);
        back.put("payApplyAmount", payApplyAmount);
        return back;
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/9/22
     * @Description
     * @Param
     * @Return
     */
    class PostDataCallable implements Callable<JSONObject> {
        private String url;
        private Object data;

        public PostDataCallable(String url, Object data) {
            this.data = data;
            this.url = url;
        }

        @Override
        public JSONObject call() throws Exception {
            System.out.println(InvocationInfoProxy.getTenantid());
            String responseStr = ReferHttpClientUtils.postByJson(url, JSON.toJSONString(data), request);
            System.out.println(responseStr);
            return JSONObject.parseObject(responseStr);
        }

    }

    /**
     * 统计匹配条件的（属于项目的）物资合同含税现合同金额总值(单位：万元）
     *
     * @param param projectIds: 指定所属的项目的id列表
     * @return
     */
    @PostMapping(value = "analysisContract")
    public CommonResponse<BigDecimal> analysisContract(@RequestBody Map<String, Object> param) {
        QueryParam queryParam = new QueryParam();
        //查询本租户下的
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("dr", new Parameter(QueryParam.EQ, BaseVO.DR_UNDELETE));
        //属于项目
        queryParam.getParams().put("dependOnProject", new Parameter(QueryParam.EQ, 1));
        //已审批生效的
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));
        //在指定项目范围内的
        if (null != param && null != param.get("projectIds") && CollectionUtils.isNotEmpty((List<Long>) param.get("projectIds"))) {
            queryParam.getParams().put("projectId", new Parameter(QueryParam.IN, param.get("projectIds")));
        }
        Map<String, Object> result = materialContractService.countContractAmount(queryParam);
        String dataStr = null != result.get("curAmount") ? result.get("curAmount").toString() : "0";
        BigDecimal total = new BigDecimal(dataStr);

        return CommonResponse.success(total.divide(new BigDecimal(10000), 2, BigDecimal.ROUND_HALF_UP));
    }

}

