/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.ComparePriceEntity;
import com.ejianc.business.material.mapper.ComparePriceMapper;
import com.ejianc.business.material.service.IComparePriceSelectedSupplierService;
import com.ejianc.business.material.service.IComparePriceService;
import com.ejianc.business.material.vo.ComparePriceVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ComparePriceService
extends BaseServiceImpl<ComparePriceMapper, ComparePriceEntity>
implements IComparePriceService {
    @Autowired
    private IComparePriceSelectedSupplierService iComparePriceSelectedSupplierService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertOrUpdate(ComparePriceEntity entity) {
        Boolean success = super.saveOrUpdate((Object)entity, false);
        if (success.booleanValue() && !ListUtil.isEmpty(entity.getPriceSubEntities())) {
            entity.getPriceSubEntities().forEach(sub -> {
                QueryParam param = new QueryParam();
                param.getParams().put("comparePriceSubId", new Parameter("eq", (Object)sub.getId()));
                List suppliers = this.iComparePriceSelectedSupplierService.queryList(param, false);
                if (!ListUtil.isEmpty((List)suppliers)) {
                    this.iComparePriceSelectedSupplierService.removeByIds(suppliers.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
                }
                if (!ListUtil.isEmpty(sub.getSupplierEntities())) {
                    sub.getSupplierEntities().forEach(supplier -> {
                        supplier.setComparePriceSubId(sub.getId());
                        this.iComparePriceSelectedSupplierService.saveOrUpdate(supplier, false);
                    });
                }
            });
        }
        return true;
    }

    @Override
    public IPage<ComparePriceVO> queryForList(QueryParam param) {
        Page voPage = null;
        IPage entityPage = super.queryPage(param, false);
        if (entityPage != null) {
            voPage = new Page();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize((long)param.getPageSize());
            voPage.setRecords(BeanMapper.mapList((Iterable)entityPage.getRecords(), ComparePriceVO.class));
        }
        return voPage;
    }
}

