/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.utils;

import com.google.gson.Gson;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class InvoiceUtil {
    public String doRequest(String url, HashMap<String, String> payload) throws Exception {
        String appKey = "797C1874B2D545B698CA37EDA931A49B";
        String appSecret = "aade17295460272edc65dd0c9fe4e671";
        String method = "post";
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/json;charset=UTF-8");
        List<NameValuePair> params = InvoiceUtil.getParams(appKey);
        String splitor = "|";
        StringBuilder builder = new StringBuilder(method.toUpperCase() + "|");
        for (int i = 0; i < params.size(); ++i) {
            NameValuePair pair = params.get(i);
            String key = pair.getName();
            String value = pair.getValue();
            httpPost.addHeader(key, value);
            builder.append(key + "=" + value + "|");
        }
        String signString = builder.substring(0, builder.length() - 1);
        String signature = InvoiceUtil.getSignature(appSecret, signString);
        httpPost.addHeader("X-CS-Signature", signature);
        String json = new Gson().toJson(payload);
        httpPost.setEntity((HttpEntity)new StringEntity(json, "UTF-8"));
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
        HttpEntity entity = response.getEntity();
        String result = EntityUtils.toString((HttpEntity)entity);
        System.out.println("\u6d4b\u8bd5\uff1a" + result);
        return result;
    }

    private static List<NameValuePair> getParams(String appKey) {
        if (appKey == null) {
            throw new NullPointerException();
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("X-CS-Authorization", "HMAC-SHA256"));
        params.add((NameValuePair)new BasicNameValuePair("X-CS-Key", appKey));
        params.add((NameValuePair)new BasicNameValuePair("X-CS-Nonce", UUID.randomUUID().toString()));
        params.add((NameValuePair)new BasicNameValuePair("X-CS-Timestamp", "" + System.currentTimeMillis() / 1000L));
        params.add((NameValuePair)new BasicNameValuePair("X-CS-Version", "v2"));
        return params;
    }

    public static String getSignature(String key, String data) throws NoSuchAlgorithmException, InvalidKeyException {
        if (key == null || data == null) {
            throw new NullPointerException();
        }
        String HMAC_SHA256 = "HmacSHA256";
        Mac hMacSHA256 = Mac.getInstance("HmacSHA256");
        byte[] hmacKeyBytes = key.getBytes(StandardCharsets.UTF_8);
        SecretKeySpec secretKey = new SecretKeySpec(hmacKeyBytes, "HmacSHA256");
        hMacSHA256.init(secretKey);
        byte[] dataBytes = data.getBytes(StandardCharsets.UTF_8);
        byte[] res = hMacSHA256.doFinal(dataBytes);
        return Base64.getEncoder().encodeToString(res);
    }
}

