/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.ContractChangeEntity;
import com.ejianc.business.material.bean.MaterialSupplementEntity;
import com.ejianc.business.material.mapper.ContractChangeMapper;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.business.material.service.IContractChangeService;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.service.IMaterialSupplementService;
import com.ejianc.business.material.vo.ContractChangeVO;
import com.ejianc.business.material.vo.ContractDetailChangeVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/materialContractChange/"})
public class MaterialContractChangeController {
    @Autowired
    private IContractChangeService contractChangeService;
    @Autowired
    private IMaterialContractService materialContractService;
    @Autowired
    private IMaterialSupplementService materialSupplementService;
    @Autowired
    ICommonBusinessService contractChange;
    @Autowired
    ContractChangeMapper contractChangeMapper;
    @Autowired
    private MaterialContractMapper materialContractMapper;

    @GetMapping(value={"get"})
    public CommonResponse<ContractChangeVO> get(@RequestParam(value="id") Long id) {
        this.contractChange.afterApprovalProcessor(id, null, null);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01");
    }

    @PostMapping(value={"saveOrUpdate"})
    public CommonResponse<ContractChangeVO> save(@RequestBody ContractChangeVO contractChangeVO) {
        Integer count = this.contractChangeMapper.countClosing(contractChangeVO.getProjectId());
        if (count != 0) {
            Long contractId = contractChangeVO.getMaterialContractId();
            BigDecimal beforechangemny = contractChangeVO.getBeforeChangeMny();
            BigDecimal contractmny = contractChangeVO.getAmountWithoutTax();
            if (contractmny.compareTo(beforechangemny) == 1) {
                throw new BusinessException("\u672c\u9879\u76ee\u5df2\u5236\u4f5c\u6210\u672c\u5173\u95e8\u9884\u4f30\u5355\uff0c\u7981\u6b62\u589e\u5927\u5408\u540c\u989d\uff01");
            }
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("material_contract_id", new Parameter("eq", (Object)contractChangeVO.getMaterialContractId()));
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("bill_state", new Parameter("ne", (Object)BillStateEnum.COMMITED_STATE.getBillStateCode()));
        queryParam.getComplexParams().add(c1);
        queryParam.getParams().put("bill_state", new Parameter("ne", (Object)BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryParam.getParams().put("id", new Parameter("ne", (Object)contractChangeVO.getId()));
        List list = this.contractChangeService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5f53\u524d\u5408\u540c\u5b58\u5728\u672a\u5ba1\u6279\u901a\u8fc7\u7684\u53d8\u66f4\u8bb0\u5f55\uff01");
        }
        LambdaQueryWrapper lambdaQuery2 = Wrappers.lambdaQuery();
        lambdaQuery2.eq(MaterialSupplementEntity::getMainContractId, (Object)contractChangeVO.getMaterialContractId());
        lambdaQuery2.ne(MaterialSupplementEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdaQuery2.ne(MaterialSupplementEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int nums = this.materialSupplementService.count((Wrapper)lambdaQuery2);
        if (nums > 0) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae!");
        }
        boolean checkResult = this.materialContractService.codeCheck(contractChangeVO.getMaterialContractId(), contractChangeVO.getCode());
        if (!checkResult) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5408\u540c\u7f16\u7801\u91cd\u590d");
        }
        ContractChangeVO resp = this.contractChangeService.save(contractChangeVO);
        this.queryPrice(resp);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)resp);
    }

    @RequestMapping(value={"/checkmakedata"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> checkmakedata(@RequestParam(value="projectId") Long projectId) {
        Integer countaa = this.materialContractMapper.countClosing(projectId);
        if (countaa != 0) {
            throw new BusinessException("\u5f53\u524d\u9879\u76ee\u5df2\u5f55\u5165\u6210\u672c\u5173\u95e8\u9884\u4f30\u5355\uff0c\u65e0\u6cd5\u65b0\u589e\u5408\u540c\u53d8\u66f4\uff01");
        }
        Date endtime = this.materialContractMapper.getCostClosingTime(projectId);
        Date now = new Date();
        if (endtime != null && now.compareTo(endtime) == 1) {
            throw new BusinessException("\u5f53\u524d\u9879\u76ee\u5df2\u4e0d\u5728\u6210\u672c\u5173\u95e8\u671f\u9650\u5185\uff0c\u65e0\u6cd5\u65b0\u589e\u5408\u540c\u53d8\u66f4\uff01");
        }
        String message = "\u6821\u9a8c\u6210\u529f\uff0c\u5141\u8bb8\u5f55\u5165\uff01";
        return CommonResponse.success((String)message);
    }

    @GetMapping(value={"queryDetail"})
    public CommonResponse<ContractChangeVO> detail(@RequestParam(value="id") Long id) {
        ContractChangeVO vo = null;
        ContractChangeEntity e = (ContractChangeEntity)((Object)this.contractChangeService.selectById(id));
        if (e != null) {
            vo = (ContractChangeVO)BeanMapper.map((Object)((Object)e), ContractChangeVO.class);
            this.queryPrice(vo);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", vo);
    }

    private void queryPrice(ContractChangeVO vo) {
        if (CollectionUtils.isNotEmpty((Collection)vo.getMaterialDetailList())) {
            for (ContractDetailChangeVO event : vo.getMaterialDetailList()) {
                if (!StringUtils.isEmpty((CharSequence)event.getMaterialId())) continue;
                return;
            }
        } else {
            return;
        }
        List materialDetailList = vo.getMaterialDetailList();
        if (CollectionUtils.isNotEmpty((Collection)materialDetailList)) {
            MaterialPriceVO priceVO = new MaterialPriceVO(vo.getProjectId());
            ArrayList detail = new ArrayList();
            materialDetailList.forEach(item -> {
                MaterialPriceVO materialPriceVO = new MaterialPriceVO();
                materialPriceVO.setMaterialId(Long.valueOf(item.getMaterialId()));
                detail.add(materialPriceVO);
            });
            priceVO.setDetail(detail);
            Integer isJc = vo.getPurchaseMode().equals("1") ? 1 : 0;
            MaterialPriceVO materialPriceVO = this.materialContractService.queryPrice(isJc, vo.getMaterialContractId(), priceVO);
            List dd = materialPriceVO.getDetail();
            if (CollectionUtils.isNotEmpty((Collection)dd)) {
                Map<Long, MaterialPriceVO> priceVOMap = dd.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account, (v1, v2) -> v2));
                for (ContractDetailChangeVO v : materialDetailList) {
                    String materialId = v.getMaterialId();
                    MaterialPriceVO p = priceVOMap.get(Long.valueOf(materialId));
                    if (null == p) continue;
                    v.setPlanNum(p.getPlanNum());
                    v.setPlanPrice(p.getPlanPrice());
                    v.setMinPrice(p.getMinPrice());
                    v.setMaxPrice(p.getMaxPrice());
                    v.setPriceArea(p.getPriceArea());
                }
            }
        }
    }

    @PostMapping(value={"delete"})
    public CommonResponse<String> delete(@RequestBody List<ContractChangeVO> vos) {
        this.contractChangeService.deleteById(vos.get(0).getId(), false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

