/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.material.bean.OutStoreEntity;
import com.ejianc.business.material.bean.OutStoreSubEntity;
import com.ejianc.business.material.mapper.OutStoreMapper;
import com.ejianc.business.material.mapper.OutStoreSubMapper;
import com.ejianc.business.material.pub.MaterialStoreType;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.vo.OutStoreSubVO;
import com.ejianc.business.material.vo.OutStoreVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OutStoreService
extends BaseServiceImpl<OutStoreMapper, OutStoreEntity>
implements IOutStoreService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostDetailApi iCostDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private OutStoreSubMapper outStoreSubMapper;
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public IPage<OutStoreVO> queryForList(QueryParam queryParam, boolean isEs) {
        Page voPage = null;
        IPage entityPage = super.queryPage(queryParam, isEs);
        if (entityPage != null) {
            voPage = new Page();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize((long)queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList((Iterable)entityPage.getRecords(), OutStoreVO.class));
        }
        return voPage;
    }

    @Override
    public void processCost(OutStoreEntity entity) {
        String factor = "1";
        if (ListUtil.isNotEmpty(entity.getOutStoreSubEntities())) {
            ArrayList<CostDetailVO> list = new ArrayList<CostDetailVO>();
            boolean canPush = true;
            for (int i = 0; i < entity.getOutStoreSubEntities().size(); ++i) {
                CostDetailVO c;
                OutStoreSubEntity sub = entity.getOutStoreSubEntities().get(i);
                if (sub.getSubjectId() != null && sub.getSubjectId() > 0L) {
                    c = new CostDetailVO();
                    c.setSubjectId(sub.getSubjectId());
                    c.setSourceId(entity.getId());
                    c.setSourceDetailId(sub.getId());
                    c.setProjectId(entity.getProjectId());
                    c.setHappenTaxMny(sub.getAmount() == null ? new BigDecimal("0.00") : sub.getAmount().multiply(new BigDecimal(factor)));
                    if (sub.getAmount() == null) {
                        c.setHappenMny(new BigDecimal("0.00"));
                    } else {
                        BigDecimal rate = sub.getTaxRate() == null ? new BigDecimal("1.00") : new BigDecimal("1.00").add(sub.getTaxRate().divide(new BigDecimal("100.00"), 8, 4));
                        BigDecimal happenMny = sub.getAmount().divide(rate, 8, 4).multiply(new BigDecimal(factor));
                        c.setHappenMny(happenMny);
                    }
                } else {
                    canPush = false;
                    break;
                }
                c.setHappenDate(entity.getOutDate());
                c.setMemo(entity.getMemo());
                c.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                c.setSourceType(MaterialStoreType.getStoreTypeNameByCode((Integer)entity.getStoreType()));
                c.setSourceTabType(MaterialStoreType.getStoreTypeNameByCode((Integer)entity.getStoreType()) + "\u5b50\u8868");
                list.add(c);
            }
            if (canPush) {
                CommonResponse response = this.iCostDetailApi.saveSubject(list);
                this.logger.info("\u63a8\u9001\u6210\u672c" + MaterialStoreType.getStoreTypeNameByCode((Integer)entity.getStoreType()) + "\u7ed3\u679c:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
                entity.setRelationFlag("1");
            } else {
                CommonResponse response = this.iCostDetailApi.deleteSubject(entity.getId());
                this.logger.info("\u5220\u9664\u6210\u672c" + MaterialStoreType.getStoreTypeNameByCode((Integer)entity.getStoreType()) + "\u7ed3\u679c:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
                entity.setRelationFlag("0");
            }
        } else {
            this.iCostDetailApi.deleteSubject(entity.getId());
            entity.setRelationFlag("0");
        }
    }

    @Override
    public CommonResponse<List<JSONObject>> queryMaterialCostTopN(Integer topN, Integer type) {
        List<Long> orgIds = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        String startDate = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)DateUtil.beginOfYear((Date)new Date()));
        startDate = "'" + startDate + "'";
        List<OutStoreSubVO> outStoreSubEntities = this.outStoreSubMapper.queryMaterialCategoryCostTopN(topN, type, startDate, orgIds);
        ArrayList result = new ArrayList();
        this.logger.info("\u67e5\u8be2\u7269\u8d44\u5f00\u7d2f\u5e74\u7d2f\u6d88\u8017top n outStoreSubEntities \u6570\u91cf\uff1a" + (ListUtil.isNotEmpty(outStoreSubEntities) ? Integer.valueOf(outStoreSubEntities.size()) : "\u7a7a") + " \u5f53\u524dorgId\uff1a" + InvocationInfoProxy.getOrgId());
        if (ListUtil.isNotEmpty(outStoreSubEntities)) {
            outStoreSubEntities.forEach(en -> {
                JSONObject object = new JSONObject();
                object.put("materialCategoryName", (Object)en.getMaterialCategoryName());
                object.put("outStoreNumber", (Object)en.getOutStoreNumber());
                object.put("amount", (Object)en.getAmount());
                object.put("weight", (Object)(en.getUnitPrice().multiply(new BigDecimal("100")).setScale(0, 4) + "%"));
                result.add(object);
            });
        }
        return CommonResponse.success(result);
    }
}

