package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.PurchaseSettlementInvoiceDetailEntity;
import com.ejianc.business.material.service.IPurchaseSettlementInvoiceDetailService;
import com.ejianc.business.material.vo.PurchaseSettlementInvoiceDetailVO;
import com.ejianc.business.pub.tax.TaxCalculateUtil;
import com.ejianc.business.utils.InvoiceUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.mysql.fabric.xmlrpc.base.Array;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 采购结算单发票明细
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("purchaseSettlementInvoiceDetail")
public class PurchaseSettlementInvoiceDetailController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    
    @Autowired
    private IPurchaseSettlementInvoiceDetailService service; 
    @Autowired
    private IAttachmentApi attachmentApi; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PurchaseSettlementInvoiceDetailVO> saveOrUpdate(@RequestBody PurchaseSettlementInvoiceDetailVO saveorUpdateVO) {
    	PurchaseSettlementInvoiceDetailEntity entity = BeanMapper.map(saveorUpdateVO, PurchaseSettlementInvoiceDetailEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
//            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//            }else{
//                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//            }
        }
    	service.saveOrUpdate(entity, false);
    	PurchaseSettlementInvoiceDetailVO vo = BeanMapper.map(entity, PurchaseSettlementInvoiceDetailVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchaseSettlementInvoiceDetailVO> queryDetail(Long id) {
    	PurchaseSettlementInvoiceDetailEntity entity = service.selectById(id);
    	PurchaseSettlementInvoiceDetailVO vo = BeanMapper.map(entity, PurchaseSettlementInvoiceDetailVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchaseSettlementInvoiceDetailVO> vos) {
        service.removeByIds(vos.stream().map(PurchaseSettlementInvoiceDetailVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PurchaseSettlementInvoiceDetailVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<PurchaseSettlementInvoiceDetailEntity> page = service.queryPage(param,false);
        IPage<PurchaseSettlementInvoiceDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchaseSettlementInvoiceDetailVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PurchaseSettlementInvoiceDetailEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PurchaseSettlementInvoiceDetail-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refPurchaseSettlementInvoiceDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PurchaseSettlementInvoiceDetailVO>> refPurchaseSettlementInvoiceDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PurchaseSettlementInvoiceDetailEntity> page = service.queryPage(param,false);
        IPage<PurchaseSettlementInvoiceDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchaseSettlementInvoiceDetailVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    
    /**
     * @Description queryInvoice 发票OCR识别+查验
     * @param ids 附件ids
     */
    @RequestMapping(value = "/queryInvoice", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryInvoice(String ids) {
    	List<PurchaseSettlementInvoiceDetailVO> successList = new ArrayList<>();//成功的list
    	List<PurchaseSettlementInvoiceDetailVO> errorList = new ArrayList<>();//失败的list
    	InvoiceUtil invoiceUtil = new InvoiceUtil();
    	String[] list = ids.split(","); 
    	String host = "https://open.cs.zbj.com";//固定写死
	    String path = "/v2/invoice/ocr";//有多个选择调用的接口
    	for(String id :list) {
    		PurchaseSettlementInvoiceDetailVO purchaseSettlementInvoiceDetailVO = new PurchaseSettlementInvoiceDetailVO();
    		CommonResponse<AttachmentVO> attachmentVOResponse = attachmentApi.queryDetail(id);//根据附件id，查询附件信息
    		AttachmentVO attachmentVO = attachmentVOResponse.getData();
    		String imgurl="https://dev-ejc-attachment.oss-cn-beijing.aliyuncs.com/"+attachmentVO.getFilePath();
    		HashMap<String, String> bodys = new HashMap<String, String>();
    		bodys.put("img", "");
			bodys.put("url", imgurl);
			String results="";
			try {
				results = invoiceUtil.doRequest(host+path, bodys);
			} catch (Exception e) {
				e.printStackTrace();
				purchaseSettlementInvoiceDetailVO.setErrorMessage(id+"调用OCR识别接口失败！");
				errorList.add(purchaseSettlementInvoiceDetailVO);
				continue;
			}
			JSONObject object = JSONObject.parseObject(results);//{
	        String success = object.getString("success"); //ocr识别结果
	        if(!"true".equals(success)) {
	        	String description = object.getString("description")==null?"无":object.getString("description");//msg
	        	purchaseSettlementInvoiceDetailVO.setErrorMessage("OCR识别失败！描述：'"+description+"'");
	        	errorList.add(purchaseSettlementInvoiceDetailVO);
	        	continue;
	        }
	        String code = object.getString("code");//code：0 代表查验成功;ocr识别成功后续查验失败code：1013
	        if("1013".equals(code)) {
	        	String description = object.getString("description")==null?"无":object.getString("description");//描述
	        	purchaseSettlementInvoiceDetailVO.setErrorMessage("OCR识别成功但查验失败！描述：'"+description+"'");
	        	errorList.add(purchaseSettlementInvoiceDetailVO);
	        	continue;
	        }
	        JSONObject dataobject = JSONObject.parseObject(object.getString("data"));//识别的数据
	        String fphm =dataobject.getString("fphm");//发票号码
	        //校验是否存在该发票编号的数据
	        QueryParam queryParammx = new QueryParam();
	        queryParammx.getParams().put("invoice_number", new Parameter(QueryParam.EQ, fphm));
	        queryParammx.getParams().put("dr", new Parameter(QueryParam.EQ, "0"));
	        List<PurchaseSettlementInvoiceDetailEntity> Invoicelist = service.queryList(queryParammx);
	        if(Invoicelist.size()>1) {
	        	purchaseSettlementInvoiceDetailVO.setErrorMessage("发票号码已存在。");
	        	errorList.add(purchaseSettlementInvoiceDetailVO);
	        	continue;
	        }
	        purchaseSettlementInvoiceDetailVO.setInvoiceCode(dataobject.getString("fpdm"));//发票代码
	        purchaseSettlementInvoiceDetailVO.setInvoiceDate(dataobject.getDate("kprq"));//发票日期
	        purchaseSettlementInvoiceDetailVO.setTaxMny(dataobject.getBigDecimal("taxamount"));//税金 taxamount
	        //purchaseSettlementInvoiceDetailVO.setTaxRate(taxRate);//税率在明细上，如果多明细无法取值显示 taxRate
	        purchaseSettlementInvoiceDetailVO.setInvoiceNumber(fphm);//发票号码 
	        purchaseSettlementInvoiceDetailVO.setInvoiceTaxMny(dataobject.getBigDecimal("sumamount"));//发票价税合计  sumamount
	        purchaseSettlementInvoiceDetailVO.setInvoiceMny(purchaseSettlementInvoiceDetailVO.getInvoiceTaxMny().subtract(purchaseSettlementInvoiceDetailVO.getTaxMny()));//发票金额（不含税）
	        if(dataobject.getString("fplx").equals("01")||dataobject.getString("fplx").equals("02")||dataobject.getString("fplx").equals("08")||dataobject.getString("fplx").equals("20")) {
	        	purchaseSettlementInvoiceDetailVO.setInvoiceType("1");//发票类型 1、增值税专用发票，2、增值税普通发票，3、其他；
	        	purchaseSettlementInvoiceDetailVO.setInvoiceTypeName("增值税专用发");//发票类型名称 1、增值税专用发票，2、增值税普通发票，3、其他；
	        }else if(dataobject.getString("fplx").equals("04")||dataobject.getString("fplx").equals("10")||dataobject.getString("fplx").equals("11")||dataobject.getString("fplx").equals("14")||dataobject.getString("fplx").equals("21")) {
	        	purchaseSettlementInvoiceDetailVO.setInvoiceType("2");//发票类型 1、增值税专用发票，2、增值税普通发票，3、其他；
	        	purchaseSettlementInvoiceDetailVO.setInvoiceTypeName("增值税普通发票");//发票类型名称 1、增值税专用发票，2、增值税普通发票，3、其他；
	        }else {
	        	purchaseSettlementInvoiceDetailVO.setInvoiceType("3");//发票类型 1、增值税专用发票，2、增值税普通发票，3、其他；
	        	purchaseSettlementInvoiceDetailVO.setInvoiceTypeName("其他");//发票类型名称 1、增值税专用发票，2、增值税普通发票，3、其他；
	        }
			if(Invoicelist.size()>0) { 
				purchaseSettlementInvoiceDetailVO.setErrorMessage(fphm+"，该发票号码已存在！");
				errorList.add(purchaseSettlementInvoiceDetailVO);
			}else {
		        successList.add(purchaseSettlementInvoiceDetailVO);
			}
		        
    		
    	}
    	new TaxCalculateUtil<PurchaseSettlementInvoiceDetailVO>().calculate(successList);
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success(json);
    }
}
