/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.PurchaseSettlementInvoiceDetailEntity;
import com.ejianc.business.material.service.IPurchaseSettlementInvoiceDetailService;
import com.ejianc.business.material.vo.PurchaseSettlementInvoiceDetailVO;
import com.ejianc.business.pub.tax.TaxCalculateUtil;
import com.ejianc.business.utils.InvoiceUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"purchaseSettlementInvoiceDetail"})
public class PurchaseSettlementInvoiceDetailController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IPurchaseSettlementInvoiceDetailService service;
    @Autowired
    private IAttachmentApi attachmentApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PurchaseSettlementInvoiceDetailVO> saveOrUpdate(@RequestBody PurchaseSettlementInvoiceDetailVO saveorUpdateVO) {
        PurchaseSettlementInvoiceDetailEntity entity = (PurchaseSettlementInvoiceDetailEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), PurchaseSettlementInvoiceDetailEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse commonResponse = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
        }
        this.service.saveOrUpdate((Object)entity, false);
        PurchaseSettlementInvoiceDetailVO vo = (PurchaseSettlementInvoiceDetailVO)((Object)BeanMapper.map((Object)((Object)entity), PurchaseSettlementInvoiceDetailVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchaseSettlementInvoiceDetailVO> queryDetail(Long id) {
        PurchaseSettlementInvoiceDetailEntity entity = (PurchaseSettlementInvoiceDetailEntity)((Object)this.service.selectById(id));
        PurchaseSettlementInvoiceDetailVO vo = (PurchaseSettlementInvoiceDetailVO)((Object)BeanMapper.map((Object)((Object)entity), PurchaseSettlementInvoiceDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchaseSettlementInvoiceDetailVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PurchaseSettlementInvoiceDetailVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchaseSettlementInvoiceDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PurchaseSettlementInvoiceDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPurchaseSettlementInvoiceDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PurchaseSettlementInvoiceDetailVO>> refPurchaseSettlementInvoiceDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchaseSettlementInvoiceDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryInvoice"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryInvoice(String ids) {
        ArrayList<PurchaseSettlementInvoiceDetailVO> successList = new ArrayList<PurchaseSettlementInvoiceDetailVO>();
        ArrayList<PurchaseSettlementInvoiceDetailVO> errorList = new ArrayList<PurchaseSettlementInvoiceDetailVO>();
        InvoiceUtil invoiceUtil = new InvoiceUtil();
        String[] list = ids.split(",");
        String host = "https://open.cs.zbj.com";
        String path = "/v2/invoice/ocr";
        for (String id : list) {
            PurchaseSettlementInvoiceDetailVO purchaseSettlementInvoiceDetailVO = new PurchaseSettlementInvoiceDetailVO();
            CommonResponse attachmentVOResponse = this.attachmentApi.queryDetail(id);
            AttachmentVO attachmentVO = (AttachmentVO)attachmentVOResponse.getData();
            String imgurl = "https://dev-ejc-attachment.oss-cn-beijing.aliyuncs.com/" + attachmentVO.getFilePath();
            HashMap<String, String> bodys = new HashMap<String, String>();
            bodys.put("img", "");
            bodys.put("url", imgurl);
            String results = "";
            try {
                results = invoiceUtil.doRequest(host + path, bodys);
            }
            catch (Exception e) {
                e.printStackTrace();
                purchaseSettlementInvoiceDetailVO.setErrorMessage(id + "\u8c03\u7528OCR\u8bc6\u522b\u63a5\u53e3\u5931\u8d25\uff01");
                errorList.add(purchaseSettlementInvoiceDetailVO);
                continue;
            }
            JSONObject object = JSONObject.parseObject((String)results);
            String success = object.getString("success");
            if (!"true".equals(success)) {
                String description = object.getString("description") == null ? "\u65e0" : object.getString("description");
                purchaseSettlementInvoiceDetailVO.setErrorMessage("OCR\u8bc6\u522b\u5931\u8d25\uff01\u63cf\u8ff0\uff1a'" + description + "'");
                errorList.add(purchaseSettlementInvoiceDetailVO);
                continue;
            }
            String code = object.getString("code");
            if ("1013".equals(code)) {
                String description = object.getString("description") == null ? "\u65e0" : object.getString("description");
                purchaseSettlementInvoiceDetailVO.setErrorMessage("OCR\u8bc6\u522b\u6210\u529f\u4f46\u67e5\u9a8c\u5931\u8d25\uff01\u63cf\u8ff0\uff1a'" + description + "'");
                errorList.add(purchaseSettlementInvoiceDetailVO);
                continue;
            }
            JSONObject dataobject = JSONObject.parseObject((String)object.getString("data"));
            String fphm = dataobject.getString("fphm");
            QueryParam queryParammx = new QueryParam();
            queryParammx.getParams().put("invoice_number", new Parameter("eq", (Object)fphm));
            queryParammx.getParams().put("dr", new Parameter("eq", (Object)"0"));
            List Invoicelist = this.service.queryList(queryParammx);
            if (Invoicelist.size() > 1) {
                purchaseSettlementInvoiceDetailVO.setErrorMessage("\u53d1\u7968\u53f7\u7801\u5df2\u5b58\u5728\u3002");
                errorList.add(purchaseSettlementInvoiceDetailVO);
                continue;
            }
            purchaseSettlementInvoiceDetailVO.setInvoiceCode(dataobject.getString("fpdm"));
            purchaseSettlementInvoiceDetailVO.setInvoiceDate(dataobject.getDate("kprq"));
            purchaseSettlementInvoiceDetailVO.setTaxMny(dataobject.getBigDecimal("taxamount"));
            purchaseSettlementInvoiceDetailVO.setInvoiceNumber(fphm);
            purchaseSettlementInvoiceDetailVO.setInvoiceTaxMny(dataobject.getBigDecimal("sumamount"));
            purchaseSettlementInvoiceDetailVO.setInvoiceMny(purchaseSettlementInvoiceDetailVO.getInvoiceTaxMny().subtract(purchaseSettlementInvoiceDetailVO.getTaxMny()));
            if (dataobject.getString("fplx").equals("01") || dataobject.getString("fplx").equals("02") || dataobject.getString("fplx").equals("08") || dataobject.getString("fplx").equals("20")) {
                purchaseSettlementInvoiceDetailVO.setInvoiceType("1");
                purchaseSettlementInvoiceDetailVO.setInvoiceTypeName("\u589e\u503c\u7a0e\u4e13\u7528\u53d1");
            } else if (dataobject.getString("fplx").equals("04") || dataobject.getString("fplx").equals("10") || dataobject.getString("fplx").equals("11") || dataobject.getString("fplx").equals("14") || dataobject.getString("fplx").equals("21")) {
                purchaseSettlementInvoiceDetailVO.setInvoiceType("2");
                purchaseSettlementInvoiceDetailVO.setInvoiceTypeName("\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968");
            } else {
                purchaseSettlementInvoiceDetailVO.setInvoiceType("3");
                purchaseSettlementInvoiceDetailVO.setInvoiceTypeName("\u5176\u4ed6");
            }
            if (Invoicelist.size() > 0) {
                purchaseSettlementInvoiceDetailVO.setErrorMessage(fphm + "\uff0c\u8be5\u53d1\u7968\u53f7\u7801\u5df2\u5b58\u5728\uff01");
                errorList.add(purchaseSettlementInvoiceDetailVO);
                continue;
            }
            successList.add(purchaseSettlementInvoiceDetailVO);
        }
        new TaxCalculateUtil().calculate(successList);
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }
}

