package com.ejianc.business.material.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.ContractChangeEntity;
import com.ejianc.business.material.bean.ContractDetailChangeEntity;
import com.ejianc.business.material.bean.MaterialSupplementEntity;
import com.ejianc.business.material.mapper.ContractChangeMapper;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.business.material.service.IContractChangeService;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.service.IMaterialSupplementService;
import com.ejianc.business.material.vo.*;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description: 物资合同变更
 * @date 2020/6/12 11:43
 */
@RestController
@RequestMapping(value = "/materialContractChange/")
public class MaterialContractChangeController {

    @Autowired
    private IContractChangeService contractChangeService;

    @Autowired
    private IMaterialContractService materialContractService;


    @Autowired
    private IMaterialSupplementService materialSupplementService;

    @Autowired
    ICommonBusinessService contractChange;

    @Autowired
    ContractChangeMapper contractChangeMapper;

    @Autowired
    private MaterialContractMapper materialContractMapper;


    @GetMapping("get")
    public CommonResponse<ContractChangeVO> get(@RequestParam(value = "id") Long id) {
        contractChange.afterApprovalProcessor(id, null, null);

        return CommonResponse.success("查询成功！");
    }

    /**
     * 合同变更保存/更新
     *
     * @param contractChangeVO
     * @return
     */
    @PostMapping("saveOrUpdate")
    public CommonResponse<ContractChangeVO> save(@RequestBody ContractChangeVO contractChangeVO) {

        Integer count = contractChangeMapper.countClosing(contractChangeVO.getProjectId());
        if(count != 0){
            Long contractId = contractChangeVO.getMaterialContractId();
//            BigDecimal sourcemoney = contractChangeMapper.querysouremoney(contractId);
            BigDecimal beforechangemny = contractChangeVO.getBeforeChangeMny();//变更前金额
            BigDecimal contractmny = contractChangeVO.getAmountWithoutTax();
            if(contractmny.compareTo(beforechangemny) == 1){
                throw new BusinessException("本项目已制作成本关门预估单，禁止增大合同额！");
            }
        }
        //查询变更合同是否已有处在变更中的变更记录
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("material_contract_id", new Parameter(QueryParam.EQ, contractChangeVO.getMaterialContractId()));
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);
        c1.getParams().put("bill_state", new Parameter(QueryParam.NE, BillStateEnum.COMMITED_STATE.getBillStateCode()));
        queryParam.getComplexParams().add(c1);
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.NE, BillStateEnum.PASSED_STATE.getBillStateCode()));


        queryParam.getParams().put("id", new Parameter(QueryParam.NE, contractChangeVO.getId()));


        List<ContractChangeEntity> list = contractChangeService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(list)) {
            return CommonResponse.error("保存失败，当前合同存在未审批通过的变更记录！");
        }
        //补充协议与变更合同只能存在一条未生效的
        LambdaQueryWrapper<MaterialSupplementEntity> lambdaQuery2 = Wrappers.<MaterialSupplementEntity>lambdaQuery();
        lambdaQuery2.eq(MaterialSupplementEntity::getMainContractId, contractChangeVO.getMaterialContractId());
        lambdaQuery2.ne(MaterialSupplementEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdaQuery2.ne(MaterialSupplementEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int nums = materialSupplementService.count(lambdaQuery2);
        if(nums > 0){
            return CommonResponse.error("该合同已存在未生效的补充协议!");
        }

        boolean checkResult = materialContractService.codeCheck(contractChangeVO.getMaterialContractId(), contractChangeVO.getCode());
        if (!checkResult) {
            return CommonResponse.error("保存失败，合同编码重复");
        }

        ContractChangeVO resp = contractChangeService.save(contractChangeVO);
        this.queryPrice(resp);
        return CommonResponse.success("保存成功！", resp);
    }

    @RequestMapping(value = "/checkmakedata", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> checkmakedata(@RequestParam(value = "projectId") Long projectId) {
        Integer countaa = materialContractMapper.countClosing(projectId);
        if(countaa != 0){
            throw new BusinessException("当前项目已录入成本关门预估单，无法新增合同变更！");
        }

//        Date starttime = materialContractMapper.getCompletionTime(contractChangeVO.getProjectId());//获取预估单完工日期
        Date endtime = materialContractMapper.getCostClosingTime(projectId);//获取成本关门期限
        Date now = new Date();
        if(endtime != null){
            if(now.compareTo(endtime) == 1){
                throw new BusinessException("当前项目已不在成本关门期限内，无法新增合同变更！");
            }
        }

        String message = "校验成功，允许录入！";
        return CommonResponse.success(message);
    }

    /**
     * 合同变更详情查询
     *
     * @param id
     * @return
     */
    @GetMapping("queryDetail")
    public CommonResponse<ContractChangeVO> detail(@RequestParam(value = "id") Long id) {
        ContractChangeVO vo = null;
        ContractChangeEntity e = contractChangeService.selectById(id);
        if (e != null) {
            vo = BeanMapper.map(e, ContractChangeVO.class);
            this.queryPrice(vo);
        }

        return CommonResponse.success("查询成功！", vo);
    }

    private void queryPrice(ContractChangeVO vo) {

        if (CollectionUtils.isNotEmpty(vo.getMaterialDetailList())) {
            for (ContractDetailChangeVO event:vo.getMaterialDetailList()){
                if(StringUtils.isEmpty(event.getMaterialId())){
                    return;
                }
            }
        }else{
            return;
        }

        //根据单据参数控制查询总计划量\价,历史价格区间
        List<ContractDetailChangeVO> materialDetailList = vo.getMaterialDetailList();

        if (CollectionUtils.isNotEmpty(materialDetailList)) {
            MaterialPriceVO priceVO = new MaterialPriceVO(vo.getProjectId());
            List<MaterialPriceVO> detail = new ArrayList<>();
            materialDetailList.forEach(item -> {
                MaterialPriceVO materialPriceVO = new MaterialPriceVO();
                materialPriceVO.setMaterialId(Long.valueOf(item.getMaterialId()));
                detail.add(materialPriceVO);
            });
            priceVO.setDetail(detail);
            Integer isJc = vo.getPurchaseMode().equals("1") ? 1 : 0;
            MaterialPriceVO materialPriceVO = materialContractService.queryPrice(isJc, vo.getMaterialContractId(), priceVO);
            List<MaterialPriceVO> dd = materialPriceVO.getDetail();
            if (CollectionUtils.isNotEmpty(dd)) {
                Map<Long, MaterialPriceVO> priceVOMap = dd.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account, (v1, v2) -> v2));
                for (ContractDetailChangeVO v : materialDetailList) {
                    String materialId = v.getMaterialId();
                    MaterialPriceVO p = priceVOMap.get(Long.valueOf(materialId));
                    if (null != p) {
                        v.setPlanNum(p.getPlanNum());
                        v.setPlanPrice(p.getPlanPrice());
                        v.setMinPrice(p.getMinPrice());
                        v.setMaxPrice(p.getMaxPrice());
                        v.setPriceArea(p.getPriceArea());
                    }
                }
            }
        }
    }

    /**
     * 合同变更删除
     *
     * @param vos
     * @return
     */
    @PostMapping("delete")
    public CommonResponse<String> delete(@RequestBody List<ContractChangeVO> vos) {
        contractChangeService.deleteById(vos.get(0).getId(), false);
        return CommonResponse.success("删除成功！");
    }
}
