package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/10 采购结算单 主表
 * @Description PurchaseSettlementEntity
 */
@TableName("ejc_material_purchase_settlement")
public class PurchaseSettlementEntity extends BaseEntity {
    /**
     * 单据状态
     */
    @TableField(value = "bill_state")
    private Integer billState;

    /**
     * 结算编号
     */
    @TableField(value = "bill_code")
    private String billCode;

    /**
     * 合同名称
     */
    @TableField(value = "contract_name")
    private String contractName;

    /**
     * 合同id
     */
    @TableField(value = "contract_id")
    private Long contractId;

    /**
     * 合同采购方式
     */
    @TableField(value = "purchase_method")
    private String purchaseMethod;

    /**
     * 属于项目 ？ 1是，0不是
     */
    @TableField(value = "belong_to_project")
    private String belongToProject;

    /**
     * 项目名称
     */
    @TableField(value = "project_name")
    private String projectName;

    /**
     * 所属项目编码
     */
    @TableField(value = "project_code")
    private String projectCode;

    /**
     * 项目名称参照
     */
    @TableField(value = "project_id")
    private Long projectId;

    /**
     * 所属组织名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 所属组织参照
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 结算日期
     */
    @TableField(value = "settlement_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settlementDate;

    /**
     * 本期结算金额（含税）
     */
    @TableField(value = "current_settlement_amount_tax")
    private BigDecimal currentSettlementAmountTax;

    /**
     * 累计预付款
     */
    @TableField(value = "accumulated_advance_payment")
    private BigDecimal accumulatedAdvancePayment;

    /**
     * 本期冲抵金额
     */
    @TableField(value = "offset_amount_in_current_period")
    private BigDecimal offsetAmountInCurrentPeriod;

    /**
     * 剩余冲抵金额
     */
    @TableField(value = "remaining_offset_amount")
    private BigDecimal remainingOffsetAmount;

    /**
     * 备注
     */
    @TableField(value = "memo")
    private String memo;

    /**
     * 编制人
     */
    @TableField(value = "creator_name")
    private String creatorName;

    /**
     * 供应商id
     */
    @TableField(value = "supplier_id")
    private Long supplierId;

    /**
     * 供应商名称
     */
    @TableField(value = "supplier_name")
    private String supplierName;

    /**
     * 合同金额
     */
    @TableField(value = "contract_amount")
    private BigDecimal contractAmount;

    /**
     * 税率
     */
    @TableField(value = "taxRate")
    private BigDecimal taxRate;

    /**
     * 本期结算金额（不含税）
     */
    @TableField(value = "current_settlement_amount")
    private BigDecimal currentSettlementAmount;

    /**
     * 税金
     */
    @TableField(value = "tax")
    private BigDecimal tax;

    /**
     * 已结算金额
     */
    @TableField(value = "settled_amount")
    private BigDecimal settledAmount;

    /**
     * 已结算比例
     */
    @TableField(value = "settled_proportion")
    private BigDecimal settledProportion;

    /**
     * 累计已申请金额(资金返写，累计值)
     */
    @TableField(value = "current_apply_amount")
    private BigDecimal currentApplyAmount;

    /**
     * 剩余可以申请金额 = 本期结算金额（含税）-累计已申请金额-本期抵扣金额
     * 初始化时候，此值=本期结算金额（含税）-本期抵扣金额
     */
    @TableField(value = "remain_can_apply_amount")
    private BigDecimal remainCanApplyAmount;

    /**
     * 本期已付金额(资金返写，累计值)
     */
    @TableField(value = "current_paid_amount")
    private BigDecimal currentPaidAmount;

    /**
     * 已付金额(该合同截止到本期已付金额)
     */
    @TableField(value = "paid_amount")
    private BigDecimal paidAmount;

    /**
     * 已付比例
     */
    @TableField(value = "paid_proportion")
    private BigDecimal paidProportion;


    /**
     * 成本关联科目状态(1:是，0：否)
     */
    @TableField(value = "relation_flag")
    private String relationFlag = "0";

    /**
     * 成本分摊状态(1:是，0：否)
     */
    @TableField(value = "proportion_flag")
    private String proportionFlag = "0";
    /**
     * 结算类型(0:过程结算，1:最终结算)
     */
    @TableField("settlement_type")
    private Integer settlementType;

    /**
     * 是否票到：0-货到票未到，1-货到票到
     */
    @TableField("invoice_arrive_flag")
    private Integer invoiceArriveFlag;
    
    /**
     * 累计发票核销金额(无税)
     */
    @TableField("total_invoice_verify_mny")
    private BigDecimal totalInvoiceVerifyMny;

    /**
     * 累计发票核销金额(含税)
     */
    @TableField("total_invoice_verify_tax_mny")
    private BigDecimal totalInvoiceVerifyTaxMny;
    
    
    @TableField(exist = false)
    @SubEntity(serviceName = "purchaseSettlementMaterialDetailService")
    private List<PurchaseSettlementMaterialDetailEntity> materialDetails = new ArrayList<>();

    @TableField(exist = false)
    @SubEntity(serviceName = "purchaseSettlementOtherFeeService")
    private List<PurchaseSettlementOtherFeeEntity> feeEntities = new ArrayList<>();

    @TableField(exist = false)
    @SubEntity(serviceName = "purchaseSettlementInvoiceDetailService")
    private List<PurchaseSettlementInvoiceDetailEntity> invoiceDetails = new ArrayList<>();

    /**
     * 来源主键
     */
    @TableField("source_id")
    private String sourceId;

    /**
     * 部门主键
     */
    @TableField("dept_id")
    private Long deptId;

    /**
     * 部门名称
     */
    @TableField("dept_name")
    private String deptName;
    
    /**
     * 是否执行建造合同 0-否，1-是
     */
    @TableField("excute_construct_state")
    private String excuteConstructState;
    
    /**
     * 结算状态：0-未结算，1-已结算
     */
    @TableField("settlement_status")
    private String settlementStatus;
    
    /**
     * 累计结算金额(含税)
     */
    @TableField("sum_settle_mny")
    private BigDecimal sumSettleMny;
    
    /**
     * 累计结算金额(不含税)
     */
    @TableField("sum_settle_tax_mny")
    private BigDecimal sumSettleTaxMny;
    
    
    
    public BigDecimal getSumSettleMny() {
		return sumSettleMny;
	}

	public void setSumSettleMny(BigDecimal sumSettleMny) {
		this.sumSettleMny = sumSettleMny;
	}

	public BigDecimal getSumSettleTaxMny() {
		return sumSettleTaxMny;
	}

	public void setSumSettleTaxMny(BigDecimal sumSettleTaxMny) {
		this.sumSettleTaxMny = sumSettleTaxMny;
	}

	public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getExcuteConstructState() {
        return excuteConstructState;
    }

    public void setExcuteConstructState(String excuteConstructState) {
        this.excuteConstructState = excuteConstructState;
    }

    public String getSettlementStatus() {
        return settlementStatus;
    }

    public void setSettlementStatus(String settlementStatus) {
        this.settlementStatus = settlementStatus;
    }

    public Integer getSettlementType() {
        return settlementType;
    }

    public void setSettlementType(Integer settlementType) {
        this.settlementType = settlementType;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getPurchaseMethod() {
        return purchaseMethod;
    }

    public void setPurchaseMethod(String purchaseMethod) {
        this.purchaseMethod = purchaseMethod;
    }

    public String getBelongToProject() {
        return belongToProject;
    }

    public void setBelongToProject(String belongToProject) {
        this.belongToProject = belongToProject;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Date getSettlementDate() {
        return settlementDate;
    }

    public void setSettlementDate(Date settlementDate) {
        this.settlementDate = settlementDate;
    }

    public BigDecimal getCurrentSettlementAmountTax() {
        return currentSettlementAmountTax;
    }

    public void setCurrentSettlementAmountTax(BigDecimal currentSettlementAmountTax) {
        this.currentSettlementAmountTax = currentSettlementAmountTax;
    }

    public BigDecimal getAccumulatedAdvancePayment() {
        return accumulatedAdvancePayment;
    }

    public void setAccumulatedAdvancePayment(BigDecimal accumulatedAdvancePayment) {
        this.accumulatedAdvancePayment = accumulatedAdvancePayment;
    }

    public BigDecimal getOffsetAmountInCurrentPeriod() {
        return offsetAmountInCurrentPeriod;
    }

    public void setOffsetAmountInCurrentPeriod(BigDecimal offsetAmountInCurrentPeriod) {
        this.offsetAmountInCurrentPeriod = offsetAmountInCurrentPeriod;
    }

    public BigDecimal getRemainingOffsetAmount() {
        return remainingOffsetAmount;
    }

    public void setRemainingOffsetAmount(BigDecimal remainingOffsetAmount) {
        this.remainingOffsetAmount = remainingOffsetAmount;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getCreatorName() {
        return creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BigDecimal getContractAmount() {
        return contractAmount;
    }

    public void setContractAmount(BigDecimal contractAmount) {
        this.contractAmount = contractAmount;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getCurrentSettlementAmount() {
        return currentSettlementAmount;
    }

    public void setCurrentSettlementAmount(BigDecimal currentSettlementAmount) {
        this.currentSettlementAmount = currentSettlementAmount;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public BigDecimal getSettledAmount() {
        return settledAmount;
    }

    public void setSettledAmount(BigDecimal settledAmount) {
        this.settledAmount = settledAmount;
    }

    public BigDecimal getSettledProportion() {
        return settledProportion;
    }

    public void setSettledProportion(BigDecimal settledProportion) {
        this.settledProportion = settledProportion;
    }

    public BigDecimal getCurrentApplyAmount() {
        return currentApplyAmount;
    }

    public void setCurrentApplyAmount(BigDecimal currentApplyAmount) {
        this.currentApplyAmount = currentApplyAmount;
    }

    public BigDecimal getRemainCanApplyAmount() {
        return remainCanApplyAmount;
    }

    public void setRemainCanApplyAmount(BigDecimal remainCanApplyAmount) {
        this.remainCanApplyAmount = remainCanApplyAmount;
    }

    public BigDecimal getCurrentPaidAmount() {
        return currentPaidAmount;
    }

    public void setCurrentPaidAmount(BigDecimal currentPaidAmount) {
        this.currentPaidAmount = currentPaidAmount;
    }

    public BigDecimal getPaidAmount() {
        return paidAmount;
    }

    public void setPaidAmount(BigDecimal paidAmount) {
        this.paidAmount = paidAmount;
    }

    public BigDecimal getPaidProportion() {
        return paidProportion;
    }

    public void setPaidProportion(BigDecimal paidProportion) {
        this.paidProportion = paidProportion;
    }

    public List<PurchaseSettlementMaterialDetailEntity> getMaterialDetails() {
        return materialDetails;
    }

    public void setMaterialDetails(List<PurchaseSettlementMaterialDetailEntity> materialDetails) {
        this.materialDetails = materialDetails;
    }

    public List<PurchaseSettlementOtherFeeEntity> getFeeEntities() {
        return feeEntities;
    }

    public void setFeeEntities(List<PurchaseSettlementOtherFeeEntity> feeEntities) {
        this.feeEntities = feeEntities;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }
    
    public Integer getInvoiceArriveFlag() {
        return invoiceArriveFlag;
    }

    public void setInvoiceArriveFlag(Integer invoiceArriveFlag) {
        this.invoiceArriveFlag = invoiceArriveFlag;
    }

    public BigDecimal getTotalInvoiceVerifyMny() {
        return totalInvoiceVerifyMny;
    }

    public void setTotalInvoiceVerifyMny(BigDecimal totalInvoiceVerifyMny) {
        this.totalInvoiceVerifyMny = totalInvoiceVerifyMny;
    }

    public BigDecimal getTotalInvoiceVerifyTaxMny() {
        return totalInvoiceVerifyTaxMny;
    }

    public void setTotalInvoiceVerifyTaxMny(BigDecimal totalInvoiceVerifyTaxMny) {
        this.totalInvoiceVerifyTaxMny = totalInvoiceVerifyTaxMny;
    }

    public List<PurchaseSettlementInvoiceDetailEntity> getInvoiceDetails() {
        return invoiceDetails;
    }

    public void setInvoiceDetails(List<PurchaseSettlementInvoiceDetailEntity> invoiceDetails) {
        this.invoiceDetails = invoiceDetails;
    }
}
