package com.ejianc.business.material.mapper;

import java.util.List;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.business.material.bean.OutStoreSubEntity;
import com.ejianc.business.material.vo.OutStoreSubVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;

@Mapper
public interface OutStoreSubMapper extends BaseCrudMapper<OutStoreSubEntity> {

	Long countOutStoreMaterial(@Param("storeId") Long storeId,@Param("outDate") String outDate,@Param("storeType") String storeType,@Param("searchText") String searchText);
	
	List<OutStoreSubVO> queryOutStoreMaterialList(@Param("startLine") Integer startLine,@Param("pageSize") Integer pageSize,@Param("storeId") Long storeId,@Param("outDate") String outDate,@Param("storeType") String storeType,@Param("searchText") String searchText);

	List<OutStoreSubVO> queryMaterialCostTopN(@Param("topN") Integer topN,@Param("type") Integer type,@Param("startDate") String startDate,@Param("orgIds") List<Long> orgIds);

	List<OutStoreSubVO> queryMaterialCostTopNByProjectId(@Param("topN") Integer topN,@Param("projectId") Long projectId);
	
	// 按物资分类查询
	List<OutStoreSubVO> queryMaterialCategoryCostTopN(@Param("topN") Integer topN,@Param("type") Integer type,@Param("startDate") String startDate,@Param("orgIds") List<Long> orgIds);


}
