package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.InstoreMaterialEntity;
import com.ejianc.business.material.bean.OutStoreSubEntity;
import com.ejianc.business.material.bean.StoreEntity;
import com.ejianc.business.material.mapper.StoreMapper;
import com.ejianc.business.material.service.IInstoreMaterialService;
import com.ejianc.business.material.service.IOutStoreSubService;
import com.ejianc.business.material.service.IStoreService;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.StoreVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;


@Service
public class StoreService  extends BaseServiceImpl<StoreMapper, StoreEntity> implements IStoreService {

    @Autowired
    IInstoreMaterialService instoreMaterialService;
    @Autowired
    IOutStoreSubService iOutStoreSubService;

    @Override
    public IPage<StoreVO> queryForList(QueryParam queryParam, boolean isEs) {
        IPage<StoreVO> voPage = null;
        IPage<StoreEntity> entityPage = super.queryPage(queryParam,isEs);
        if(entityPage!=null){
            voPage = new Page<>();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize(queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList(entityPage.getRecords(),StoreVO.class));
        }
        return voPage;
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/13 根据入库子表计算该入库子表出库时候可用数量
     * @Description calculateCanUseNum
     * @Param [inStoreSubId, materialId]
     * @Return java.math.BigDecimal
     */
    @Override
    public BigDecimal calculateCanUseNum(Long inStoreSubId, Long materialId,Long outSubId) {
        InstoreMaterialEntity inEntity = instoreMaterialService.selectById(inStoreSubId);
        if(inEntity == null ){
            throw new BusinessException("没有找到该物资入库记录！");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceSubId",new Parameter(QueryParam.EQ,inStoreSubId));
        List<OutStoreSubEntity> subs = iOutStoreSubService.queryList(queryParam,false);
        BigDecimal canUseNum = inEntity.getInstoreNumber();
        final BigDecimal[] cannotUseNum = {new BigDecimal("0.00")};
        if(!ListUtil.isEmpty(subs)){
            subs.forEach(s->{
                if(outSubId ==null || !Objects.equals(outSubId,s.getId())){
                    cannotUseNum[0] = cannotUseNum[0].add(s.getOutStoreNumber());
                }
            });
        }
        canUseNum = canUseNum.subtract(cannotUseNum[0]).setScale(4,BigDecimal.ROUND_HALF_UP);
        return canUseNum ;
    }

	@Override
	public CommonResponse<String> delete(List<StoreVO> vos) {
		//校验仓库中是否存在入库的物资，若存在物资则不能删除
		List<Long> ids = vos.stream().map(StoreVO::getId).collect(Collectors.toList());
    	QueryWrapper<InstoreMaterialEntity> queryWrapper = new QueryWrapper<>();
    	queryWrapper.eq("dr", 0);
    	queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
    	queryWrapper.in("store_id", ids);
		List<InstoreMaterialVO> list = instoreMaterialService.querylist(queryWrapper);
    	if(list!=null&&list.size()>0){
    		String message = "";
    		List<StoreEntity> entitys = (List<StoreEntity>) this.listByIds(list.stream().map(InstoreMaterialVO::getStoreId).collect(Collectors.toList()));
    		for(StoreEntity entity : entitys){
				if(message.length()>0){
					message += ("、" + entity.getName());
				}else{
					message += entity.getName();
				}
    		}
    		if(message.length()>0){
    			return CommonResponse.error("以下仓库："+message+"存在物资数据，不能删除！！！");
    		}
    	}
    	this.removeByIds(ids,true);
		return CommonResponse.success("删除仓库成功");
	}

    @Override
    public StoreVO queryNewestStoreByOrgId(Long orgId) {
        QueryParam param = new QueryParam();
        param.getParams().put("orgId",new Parameter(QueryParam.EQ,orgId));
        //启用的仓库
        param.getParams().put("state",new Parameter(QueryParam.EQ,1));
        param.getOrderMap().put("createTime",QueryParam.DESC);
        List<StoreEntity> list = queryList(param,false);
        if(ListUtil.isNotEmpty(list)){
            return BeanMapper.map(list.get(0),StoreVO.class);
        }
        return null;
    }
}
