package com.ejianc.business.utils;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import com.google.gson.Gson;

public class InvoiceUtil {

	public String doRequest(String url, HashMap<String,String> payload)throws Exception {
		//八戒财税上面创建的应用的两个参数
		String appKey = "797C1874B2D545B698CA37EDA931A49B";
		String appSecret = "aade17295460272edc65dd0c9fe4e671";
		String method = "post";
		
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/json;charset=UTF-8");

        List<NameValuePair> params = getParams(appKey);

        final String splitor = "|";
        StringBuilder builder = new StringBuilder(method.toUpperCase() + splitor);
        for (int i = 0; i < params.size(); i++) {
            NameValuePair pair = params.get(i);
            String key = pair.getName();
            String value = pair.getValue();
            httpPost.addHeader(key, value);
            builder.append(key + "=" + value + splitor);
        }

        String signString = builder.substring(0, builder.length() - 1);
        String signature = getSignature(appSecret, signString);
        httpPost.addHeader("X-CS-Signature", signature);

        String json = new Gson().toJson(payload);
        httpPost.setEntity(new StringEntity(json, "UTF-8"));

        CloseableHttpResponse response = httpclient.execute(httpPost);
        HttpEntity entity = response.getEntity();
        String result = EntityUtils.toString(entity);
        System.out.println("测试："+result);
        return result;
    }
	
	 /**
     * 获取公共参数
     *
     * @param appKey 授权应用的appKey
     * @return 签名字符串
     */
    private static List<NameValuePair> getParams(String appKey) {
        if (appKey == null) {
            throw new NullPointerException();
        }

        List<NameValuePair> params = new ArrayList<NameValuePair>();

        params.add(new BasicNameValuePair("X-CS-Authorization", "HMAC-SHA256"));
        params.add(new BasicNameValuePair("X-CS-Key", appKey));
        params.add(new BasicNameValuePair("X-CS-Nonce", UUID.randomUUID().toString()));
        params.add(new BasicNameValuePair("X-CS-Timestamp", "" + System.currentTimeMillis() / 1000L));
        params.add(new BasicNameValuePair("X-CS-Version", "v2"));
        return params;
    }

    /**
     * 获取签名字符串 跟据公共参数的集合，按名称升序排列后用‘|’拼接
     *
     * @param appKey    授权应用的appKey
     * @param 请求的Http方法
     * @return 签名字符串
     */
    public static String getSignature(final String key, final String data)
            throws NoSuchAlgorithmException, InvalidKeyException {
        if (key == null || data == null) {
            throw new NullPointerException();
        }
        final String HMAC_SHA256 = "HmacSHA256";
        final Mac hMacSHA256 = Mac.getInstance(HMAC_SHA256);
        byte[] hmacKeyBytes = key.getBytes(StandardCharsets.UTF_8);
        final SecretKeySpec secretKey = new SecretKeySpec(hmacKeyBytes, HMAC_SHA256);
        hMacSHA256.init(secretKey);
        byte[] dataBytes = data.getBytes(StandardCharsets.UTF_8);
        byte[] res = hMacSHA256.doFinal(dataBytes);
        return Base64.getEncoder().encodeToString(res);
    }
}
