package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * @author CJ
 * @Description: 合同变更记录子实体-物资明细
 * @date 2020/6/12 15:50
 */
@TableName(value = "ejc_material_contract_detail_record")
public class ContractDetailRecordEntity extends BaseEntity {

    private static final long serialVersionUID = -5544629591271868477L;

    /**
     * 物资分类Id
     */
    @TableField(value = "material_type_id")
    private Long materialTypeId;

    /**
     * 物资分类名称
     */
    @TableField(value = "material_type_name")
    private String materialTypeName;

    /**
     * 物资名称
     */
    @TableField(value = "material_name")
    private String materialName;

    /**
     * 规则/型号
     */
    @TableField(value = "spec")
    private String spec;

    /**
     * 计量单位
     */
    @TableField(value = "measure_unit")
    private String measureUnit;

    /**
     * 品牌
     */
    @TableField(value = "supplier_name")
    private java.lang.String supplierName;

    /**
     * 数量
     */
    @TableField(value = "count")
    private BigDecimal count;

    /**
     * 单价
     */
    @TableField(value = "unit_price")
    private BigDecimal unitPrice;

    /**
     * 金额
     */
    @TableField(value = "total_amount")
    private BigDecimal totalAmount;

    /**
     * 备注
     */
    @TableField(value = "material_remark")
    private String materialRemark;

    /**
     * 物资来源类型：1-物料档案，2-用料申请，3-询价单
     */
    @TableField(value = "source_type")
    private String sourceType;

    /**
     * 物资来源单据Id
     */
    @TableField(value = "source_Id")
    private String sourceId;

    /**
     * 物资Id
     */
    @TableField(value = "material_id")
    private String materialId;

    /**
     * 物资合同Id
     */
    @TableField(value = "material_contract_id")
    private Long materialContractId;

    //其他字段
    /**
     * 变更项对应主表主键
     */
    @TableField(value = "change_id")
    private Long changeId;

    /**
     * 变更项子表主键Id
     */
    @TableField(value = "change_bid")
    private Long changBid;

    /**
     * 对应变更前子表主键
     */
    @TableField(value = "contract_detail_id")
    private Long contractDetailId;

    /**
     * 变更类型
     */
    @TableField(value = "change_type")
    private Integer changeType;

    public String getMaterialId() {
        return materialId;
    }

    public void setMaterialId(String materialId) {
        this.materialId = materialId;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getMeasureUnit() {
        return measureUnit;
    }

    public void setMeasureUnit(String measureUnit) {
        this.measureUnit = measureUnit;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BigDecimal getCount() {
        return count;
    }

    public void setCount(BigDecimal count) {
        this.count = count;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getMaterialRemark() {
        return materialRemark;
    }

    public void setMaterialRemark(String materialRemark) {
        this.materialRemark = materialRemark;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Long getMaterialContractId() {
        return materialContractId;
    }

    public void setMaterialContractId(Long materialContractId) {
        this.materialContractId = materialContractId;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Long getChangBid() {
        return changBid;
    }

    public void setChangBid(Long changBid) {
        this.changBid = changBid;
    }

    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }

    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }
}
