package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/1  用料申请子实体
 * @Description UseApplySubEntity
 */

@TableName("ejc_material_apply_sub")
public class UseApplySubEntity  extends BaseEntity {

    private static final long serialVersionUID = 2779265683203439571L;

    /**
     * 主表id
     */
    @TableField(value = "pid")
    private Long pid;

    /**
     * 物资分类名称
     */
    @TableField(value = "material_type_name")
    private String materialTypeName;


    /**
     * 物资分类id
     */
    @TableField(value = "material_type_id")
    private Long materialTypeId;

    /**
     * 物资名称
     */
    @TableField(value = "material_name")
    private String materialName;

    /**
     * 物资id
     */
    @TableField(value = "material_id")
    private Long materialId;

    /**
     * 规格型号
     */
    @TableField(value = "model")
    private String model;

    /**
     * 计量单位
     */
    @TableField(value = "unit")
    private String unit;

    /**
     * 申请数量
     */
    @TableField(value = "apply_num")
    private BigDecimal applyNum;

    /**
     * 暂估单价
     */
    @TableField(value = "estimate_price")
    private BigDecimal estimatePrice;

    /**
     * 暂估金额
     */
    @TableField(value = "estimate_money")
    private BigDecimal estimateMoney;

    /**
     * 计划进场日期
     */
    @TableField(value = "sub_plan_enter_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date subPlanEnterDate;

    /**
     * 备注
     */
    @TableField(value = "memo")
    private String memo;

    @TableField(value="material_info")
    private java.lang.String materialInfo; // 采购物资名称
    @TableField(value="supplier_id")
    private java.lang.Long supplierId; // 供应商品牌id
    @TableField(value="supplier_name")
    private java.lang.String supplierName; // 供应商品牌
    @TableField(value="model_id")
    private java.lang.Long modelId; // 规格型号id
    @TableField(value="thickness")
    private java.lang.String thickness; // 厚度
    @TableField(value="colour")
    private java.lang.String colour; // 色号/容重

    @TableField(value="order_num")
    private java.math.BigDecimal orderNum; // 订货量
    @TableField(value="plan_num")
    private java.math.BigDecimal planNum; // 进度量
    @TableField(value="total_num")
    private java.math.BigDecimal totalNum; // 总量
    @TableField(value="is_finish")
    private Integer isFinish; // 是否完成1是0否

    @TableField(value="sum_apply_num")
    private java.math.BigDecimal sumApplyNum; // 累计申请量

    @TableField(value="master_plan_num")
    private java.math.BigDecimal masterPlanNum; // 总计划量

    @TableField(value="source_type")
    private String sourceType;//物资来源类型：1-总计划，2-物资档案，3-批次计划，4-导入

    @TableField(value="source_id")
    private Long sourceId;//物资来源单据Id

    public BigDecimal getMasterPlanNum() {
        return masterPlanNum;
    }

    public void setMasterPlanNum(BigDecimal masterPlanNum) {
        this.masterPlanNum = masterPlanNum;
    }

    public BigDecimal getSumApplyNum() {
        return sumApplyNum;
    }

    public void setSumApplyNum(BigDecimal sumApplyNum) {
        this.sumApplyNum = sumApplyNum;
    }

    public String getMaterialInfo() {
        return materialInfo;
    }

    public void setMaterialInfo(String materialInfo) {
        this.materialInfo = materialInfo;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Long getModelId() {
        return modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public String getThickness() {
        return thickness;
    }

    public void setThickness(String thickness) {
        this.thickness = thickness;
    }

    public String getColour() {
        return colour;
    }

    public void setColour(String colour) {
        this.colour = colour;
    }


    public BigDecimal getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(BigDecimal orderNum) {
        this.orderNum = orderNum;
    }

    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }

    public BigDecimal getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(BigDecimal totalNum) {
        this.totalNum = totalNum;
    }

    public Integer getIsFinish() {
        return isFinish;
    }

    public void setIsFinish(Integer isFinish) {
        this.isFinish = isFinish;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public BigDecimal getApplyNum() {
        return applyNum;
    }

    public void setApplyNum(BigDecimal applyNum) {
        this.applyNum = applyNum;
    }

    public BigDecimal getEstimatePrice() {
        return estimatePrice;
    }

    public void setEstimatePrice(BigDecimal estimatePrice) {
        this.estimatePrice = estimatePrice;
    }

    public BigDecimal getEstimateMoney() {
        return estimateMoney;
    }

    public void setEstimateMoney(BigDecimal estimateMoney) {
        this.estimateMoney = estimateMoney;
    }

    public Date getSubPlanEnterDate() {
        return subPlanEnterDate;
    }

    public void setSubPlanEnterDate(Date subPlanEnterDate) {
        this.subPlanEnterDate = subPlanEnterDate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
}
