package com.ejianc.business.material.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.material.service.IStatisticsService;
import com.ejianc.business.material.vo.MaterialCostVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Controller
@RequestMapping("/statistics/")
public class StatisticsController {

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IStatisticsService statisticsService;

    /**
     * @Author mrsir_wxp
     * @Date 2021/3/2  查询物资入库明细列表分页
     * @Description queryInStoreDetailsPageList
     * @Param [param]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage < com.alibaba.fastjson.JSONObject>>
     */
    @RequestMapping(value = "queryInStoreDetailsPageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> queryInStoreDetailsPageList(@RequestBody QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("m.contractName");
        fuzzyFields.add("m.supplierName");
        fuzzyFields.add("m.orgName");
        fuzzyFields.add("m.storeName");
        fuzzyFields.add("s.materialCategoryName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("s.materialSpec");
        fuzzyFields.add("s.materialUnit");
        /** 数据隔离 本下 */
        List<Long> orgIds = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));
        return CommonResponse.success(statisticsService.queryInStoreDetailsPageList(param));
    }

    /**
     * @Author mrsir_wxp
     * @Date 2021-3-4 导出资入库明细列表
     * @Description excelExport
     * @Param [queryParam, response]
     * @Return void
     */
    @RequestMapping(value = "excelExportInStoreDetailsList", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportInStoreDetailsList(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageSize(10000000);
        param.setPageIndex(1);
        CommonResponse<IPage<JSONObject>> voPage = queryInStoreDetailsPageList(param);
        List<JSONObject> list = voPage.getData().getRecords();
        if (ListUtil.isNotEmpty(list)) {
            for (int i = 0; i < list.size(); i++) {
                Map<String, Object> vo = list.get(i);
                vo.put("instoreDate", DateFormatUtil.formatDate("yyyy-MM-dd", (Date) vo.get("instoreDate")));
                vo.put("amount", ComputeUtil.scaleTwo(ComputeUtil.toBigDecimal(vo.get("amount"))));
                vo.put("unitPrice", ComputeUtil.scaleTwo(ComputeUtil.toBigDecimal(vo.get("unitPrice"))));
                vo.put("instoreNumber", ComputeUtil.scale(ComputeUtil.toBigDecimal(vo.get("instoreNumber")), 4));
            }
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("inStoreDetailListStatisticsExport.xlsx", beans, response);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2021/3/4  查询物资出库明细列表分页
     * @Description queryOutStoreDetailsPageList
     * @Param [param]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage < com.alibaba.fastjson.JSONObject>>
     */
    @RequestMapping(value = "queryOutStoreDetailsPageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> queryOutStoreDetailsPageList(@RequestBody QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("useFor");
        fuzzyFields.add("memo");
        fuzzyFields.add("orgName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialSpec");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialUnit");
        fuzzyFields.add("supplierName");
        /** 数据隔离 本下 */
        List<Long> orgIds = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));
        return CommonResponse.success(statisticsService.queryOutStoreDetailsPageList(param));
    }

    /**
     * @Author mrsir_wxp
     * @Date 2021-3-4 导出资出库明细列表
     * @Description excelExport
     * @Param [queryParam, response]
     * @Return void
     */
    @RequestMapping(value = "excelExportOutStoreDetailsList", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportOutStoreDetailsList(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageSize(10000000);
        param.setPageIndex(1);
        CommonResponse<IPage<JSONObject>> voPage = queryOutStoreDetailsPageList(param);
        List<JSONObject> list = voPage.getData().getRecords();
        if (ListUtil.isNotEmpty(list)) {
            for (int i = 0; i < list.size(); i++) {
                Map<String, Object> vo = list.get(i);
                vo.put("outDate", DateFormatUtil.formatDate("yyyy-MM-dd", (Date) vo.get("outDate")));
                vo.put("amount", ComputeUtil.scaleTwo(ComputeUtil.toBigDecimal(vo.get("amount"))));
                vo.put("unitPrice", ComputeUtil.scaleTwo(ComputeUtil.toBigDecimal(vo.get("unitPrice"))));
                vo.put("outStoreNumber", ComputeUtil.scale(ComputeUtil.toBigDecimal(vo.get("outStoreNumber")), 4));
            }
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("outStoreDetailListStatisticsExport.xlsx", beans, response);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2021/3/4  查询物资出入库汇总列表分页
     * @Description queryOutStoreDetailsPageList
     * @Param [param]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage < com.alibaba.fastjson.JSONObject>>
     */
    @RequestMapping(value = "queryInOutStorePageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> queryInOutStorePageList(@RequestBody QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("m.useFor");
        fuzzyFields.add("m.memo");
        fuzzyFields.add("m.orgName");
        fuzzyFields.add("m.storeName");
        fuzzyFields.add("s.materialCategoryName");
        fuzzyFields.add("s.materialSpec");
        fuzzyFields.add("s.materialName");
        fuzzyFields.add("s.materialUnit");
        /** 数据隔离 本下 */
        List<Long> orgIds = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));
        return CommonResponse.success(statisticsService.queryInOutStorePageList(param));
    }

    /**
     * @Author mrsir_wxp
     * @Date 2021-3-9 导出物资出入库汇总列表
     * @Description excelExport
     * @Param [queryParam, response]
     * @Return void
     */
    @RequestMapping(value = "excelExportInAndOutStoreList", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportInAndOutStoreList(@RequestBody QueryParam param, HttpServletResponse response) throws IOException {
        param.setPageSize(100000);
        param.setPageIndex(1);
        CommonResponse<IPage<JSONObject>> voPage = queryInOutStorePageList(param);
        List<JSONObject> list = voPage.getData().getRecords();
        if (ListUtil.isNotEmpty(list)) {
            ServletOutputStream outputStream = response.getOutputStream();
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet = workbook.createSheet();
            sheet.createFreezePane(0, 2, 0, 2);
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 10));

            //首行标题
            XSSFRow row = sheet.createRow(0);
            CellStyle style = workbook.createCellStyle();
            style.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
            style.setFillPattern(CellStyle.SOLID_FOREGROUND);
            style.setAlignment(CellStyle.ALIGN_CENTER);
            XSSFCell cell = row.createCell(0);
            cell.setCellValue("物资出入库汇总");
            cell.setCellStyle(style);
            //第二行数据
            row = sheet.createRow(1);
            cell = row.createCell(0);
            cell.setCellValue("所属组织");
            cell.setCellStyle(style);
            cell = row.createCell(1);
            cell.setCellValue("仓库");
            cell.setCellStyle(style);
            cell = row.createCell(2);
            cell.setCellValue("物资分类");
            cell.setCellStyle(style);
            cell = row.createCell(3);
            cell.setCellValue("物资名称");
            cell.setCellStyle(style);
            cell = row.createCell(4);
            cell.setCellValue("规格型号");
            cell.setCellStyle(style);
            cell = row.createCell(5);
            cell.setCellValue("计量单位");
            cell.setCellStyle(style);
            cell = row.createCell(6);
            cell.setCellValue("供应商");
            cell.setCellStyle(style);
            cell = row.createCell(7);
            cell.setCellValue("采购价");
            cell.setCellStyle(style);
            cell = row.createCell(8);
            cell.setCellValue("入库数量");
            cell.setCellStyle(style);
            cell = row.createCell(9);
            cell.setCellValue("出库数量");
            cell.setCellStyle(style);
            cell = row.createCell(10);
            cell.setCellValue("结存量");
            cell.setCellStyle(style);
            for (int i = 0; i < 11; i++) {
                sheet.autoSizeColumn(i);
                sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 35 / 10);
            }
            for (int i = 0; i < list.size(); i++) {
                Map<String, Object> vo = list.get(i);
                row = sheet.createRow(i + 2);
                if ((int) vo.get("newKeyRowSpan") > 0) {
                    cell = row.createCell(0);
                    cell.setCellValue(vo.get("orgName") == null ? "" : vo.get("orgName").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("newKeyRowSpan")) - 1, 0, 0));
                    cell = row.createCell(1);
                    cell.setCellValue(vo.get("storeName") == null ? "" : vo.get("storeName").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("newKeyRowSpan")) - 1, 1, 1));
                    cell = row.createCell(2);
                    cell.setCellValue(vo.get("materialCategoryName") == null ? "" : vo.get("materialCategoryName").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("newKeyRowSpan")) - 1, 2, 2));
                    cell = row.createCell(3);
                    cell.setCellValue(vo.get("materialName") == null ? "" : vo.get("materialName").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("newKeyRowSpan")) - 1, 3, 3));
                    cell = row.createCell(4);
                    cell.setCellValue(vo.get("materialSpec") == null ? "" : vo.get("materialSpec").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("newKeyRowSpan")) - 1, 4, 4));
                    cell = row.createCell(5);
                    cell.setCellValue(vo.get("materialUnit") == null ? "" : vo.get("materialUnit").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("newKeyRowSpan")) - 1, 5, 5));
                    cell = row.createCell(9);
                    cell.setCellValue(vo.get("outStoreNumber") == null ? "" : vo.get("outStoreNumber").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("newKeyRowSpan")) - 1, 9, 9));
                    cell = row.createCell(10);
                    cell.setCellValue(vo.get("surplusNumber") == null ? "" : vo.get("surplusNumber").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("newKeyRowSpan")) - 1, 10, 10));
                }

                cell = row.createCell(6);
                cell.setCellValue(vo.get("supplierName") != null ? vo.get("supplierName").toString() : null);
                if (null != vo.get("supplyRowSpan") && (int) vo.get("supplyRowSpan") > 0) {
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("supplyRowSpan")) - 1, 6, 6));
                }

                cell = row.createCell(7);
                cell.setCellValue(vo.get("unitPrice") != null ? vo.get("unitPrice").toString() : null);
                cell = row.createCell(8);
                cell.setCellValue(vo.get("instoreNumber") != null ? vo.get("instoreNumber").toString() : null);
                if (null != vo.get("priceRowSpan") && (int) vo.get("priceRowSpan") > 0) {
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("priceRowSpan")) - 1, 7, 7));

                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("priceRowSpan")) - 1, 8, 8));
                }
            }
            workbook.write(outputStream);
        }

    }

    /**
     * @Author mrsir_wxp
     * @Date 2021/3/13  查询物资计划与出入库对比分页
     * @Description queryPlanInOutStorePageList
     * @Param [param]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage < com.alibaba.fastjson.JSONObject>>
     */
    @RequestMapping(value = "queryPlanInOutStorePageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> queryPlanInOutStorePageList(@RequestBody QueryParam param) {
        return CommonResponse.success(statisticsService.queryPlanInOutStorePageList(param));
    }

    /**
     * @Author mrsir_xuannl
     * @Date 2021-11-1 导出项目材料用量对比列表
     * @Description excelExport
     * @Param [queryParam, response]
     * @Return void
     */
    @RequestMapping(value = "excelExportDosageComparisonList", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportDosageComparisonList(@RequestBody QueryParam param, HttpServletResponse response) throws IOException {
        param.setPageSize(100000);
        param.setPageIndex(1);
        CommonResponse<IPage<JSONObject>> voPage = queryPlanInOutStorePageList(param);
        List<JSONObject> list = voPage.getData().getRecords();
        if (ListUtil.isNotEmpty(list)) {
            ServletOutputStream outputStream = response.getOutputStream();
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet = workbook.createSheet();
            /** 冻结前三行 */
            sheet.createFreezePane(0, 3, 0, 3);
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 7));

            //首行标题
            XSSFRow row = sheet.createRow(0);
            CellStyle style = workbook.createCellStyle();
            style.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
            style.setFillPattern(CellStyle.SOLID_FOREGROUND);
            style.setAlignment(CellStyle.ALIGN_CENTER);
            style.setBorderLeft((short) 1);
            style.setBorderRight((short) 1);
            style.setBorderBottom((short) 1);
            style.setBorderTop((short) 1);
            XSSFCell cell = row.createCell(0);
            cell.setCellValue("项目材料用量对比");
            cell.setCellStyle(style);
            for (int i = 1; i < 8; i++) {
                cell = row.createCell(i);
                cell.setCellStyle(style);
            }
            //第二行数据
            row = sheet.createRow(1);

            cell = row.createCell(0);
            cell.setCellValue("物资");
            cell.setCellStyle(style);
            sheet.addMergedRegion(new CellRangeAddress(1, 1, 0, 3));
            cell = row.createCell(1);
            cell.setCellStyle(style);
            cell = row.createCell(2);
            cell.setCellStyle(style);
            cell = row.createCell(3);
            cell.setCellStyle(style);
            cell = row.createCell(4);
            cell.setCellValue("总计划");
            cell.setCellStyle(style);
            sheet.addMergedRegion(new CellRangeAddress(1, 1, 4, 4));
            cell = row.createCell(5);
            cell.setCellValue("用料申请");
            cell.setCellStyle(style);
            sheet.addMergedRegion(new CellRangeAddress(1, 1, 5, 5));
            cell = row.createCell(6);
            cell.setCellValue("材料入库");
            cell.setCellStyle(style);
            sheet.addMergedRegion(new CellRangeAddress(1, 1, 6, 6));
            cell = row.createCell(7);
            cell.setCellValue("材料出库");
            cell.setCellStyle(style);
            sheet.addMergedRegion(new CellRangeAddress(1, 1, 7, 7));

            row = sheet.createRow(2);
            cell = row.createCell(0);
            cell.setCellValue("分类");
            cell.setCellStyle(style);
            cell = row.createCell(1);
            cell.setCellValue("物资名称");
            cell.setCellStyle(style);
            cell = row.createCell(2);
            cell.setCellValue("规格型号");
            cell.setCellStyle(style);
            cell = row.createCell(3);
            cell.setCellValue("计量单位");
            cell.setCellStyle(style);
            cell = row.createCell(4);
            cell.setCellValue("计划数量");
            cell.setCellStyle(style);
            cell = row.createCell(5);
            cell.setCellValue("申请数量");
            cell.setCellStyle(style);
            cell = row.createCell(6);
            cell.setCellValue("入库数量");
            cell.setCellStyle(style);
            cell = row.createCell(7);
            cell.setCellValue("出库数量");
            cell.setCellStyle(style);

            for (int i = 0; i < 8; i++) {
                sheet.autoSizeColumn(i);
                sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 35 / 8);
            }
            for (int i = 0; i < list.size(); i++) {
                Map<String, Object> vo = list.get(i);
                row = sheet.createRow(i + 3);
                if ((int) vo.get("materialRowSpan") > 0) {
                    cell = row.createCell(0);
                    cell.setCellValue(vo.get("materialCategoryName") == null ? "" : vo.get("materialCategoryName").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 0, 0));

                    cell = row.createCell(1);
                    cell.setCellValue(vo.get("materialName") == null ? "" : vo.get("materialName").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 1, 1));
                    cell = row.createCell(2);
                    cell.setCellValue(vo.get("materialSpec") == null ? "" : vo.get("materialSpec").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 2, 2));
                    cell = row.createCell(3);
                    cell.setCellValue(vo.get("materialUnit") == null ? "" : vo.get("materialUnit").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 3, 3));

                    if (vo.get("pNum") != null) {
                        cell = row.createCell(4);
                        cell.setCellValue(Double.parseDouble(vo.get("pNum").toString()));
                        sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 4, 4));
                    } else {
                        cell = row.createCell(4);
                        sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 4, 4));
                    }
                    if (vo.get("aNum") != null) {
                        cell = row.createCell(5);
                        cell.setCellValue(Double.parseDouble(vo.get("aNum").toString()));
                        sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 5, 5));
                    } else {
                        cell = row.createCell(5);
                        sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 5, 5));
                    }
                    if (vo.get("oNum") != null) {
                        cell = row.createCell(7);
                        cell.setCellValue(Double.parseDouble(vo.get("oNum").toString()));
                        sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 7, 7));
                    } else {
                        cell = row.createCell(7);
                        sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 7, 7));
                    }
                }
                if ((int) vo.get("iUnitPriceRowSpan") > 0) {
                    if (vo.get("iNum") != null) {
                        cell = row.createCell(6);
                        cell.setCellValue(Double.parseDouble(vo.get("iNum").toString()));
                        sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("iUnitPriceRowSpan")) - 1, 6, 6));
                    } else {
                        cell = row.createCell(6);
                        sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("iUnitPriceRowSpan")) - 1, 6, 6));
                    }
                }
            }
            workbook.write(outputStream);
        }
    }

    /**
     * @Author mrsir_wxp
     * @Date 2021-3-9 导出物资出入库汇总列表
     * @Description excelExport
     * @Param [queryParam, response]
     * @Return void
     */
    @RequestMapping(value = "excelExportPlanInAndOutStoreList", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportPlanInAndOutStoreList(@RequestBody QueryParam param, HttpServletResponse response) throws IOException {
        param.setPageSize(100000);
        param.setPageIndex(1);
        CommonResponse<IPage<JSONObject>> voPage = queryPlanInOutStorePageList(param);
        List<JSONObject> list = voPage.getData().getRecords();
        ServletOutputStream outputStream = response.getOutputStream();
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet();
        /** 冻结前三行 */
        sheet.createFreezePane(0, 3, 0, 3);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 13));

        //首行标题
        XSSFRow row = sheet.createRow(0);
        CellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
        style.setFillPattern(CellStyle.SOLID_FOREGROUND);
        style.setAlignment(CellStyle.ALIGN_CENTER);
        style.setBorderLeft((short) 1);
        style.setBorderRight((short) 1);
        style.setBorderBottom((short) 1);
        style.setBorderTop((short) 1);
        XSSFCell cell = row.createCell(0);
        cell.setCellValue("计划与出入库对比");
        cell.setCellStyle(style);
        for (int i = 1; i < 14; i++) {
            cell = row.createCell(i);
            cell.setCellStyle(style);
        }
        //第二行数据
        row = sheet.createRow(1);

        cell = row.createCell(0);
        cell.setCellValue("物质");
        cell.setCellStyle(style);
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 0, 3));
        cell = row.createCell(1);
        cell.setCellStyle(style);
        cell = row.createCell(2);
        cell.setCellStyle(style);
        cell = row.createCell(3);
        cell.setCellStyle(style);
        cell = row.createCell(4);
        cell.setCellValue("总计划");
        cell.setCellStyle(style);
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 4, 6));
        cell = row.createCell(5);
        cell.setCellStyle(style);
        cell = row.createCell(6);
        cell.setCellStyle(style);
        cell = row.createCell(7);
        cell.setCellValue("用料申请");
        cell.setCellStyle(style);
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 7, 8));
        cell = row.createCell(8);
        cell.setCellStyle(style);
        cell = row.createCell(9);
        cell.setCellValue("材料入库");
        cell.setCellStyle(style);
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 9, 11));
        cell = row.createCell(10);
        cell.setCellStyle(style);
        cell = row.createCell(11);
        cell.setCellStyle(style);
        cell = row.createCell(12);
        cell.setCellValue("材料出库");
        cell.setCellStyle(style);
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 12, 13));
        cell = row.createCell(13);
        cell.setCellStyle(style);

        row = sheet.createRow(2);
        cell = row.createCell(0);
        cell.setCellValue("分类");
        cell.setCellStyle(style);
        cell = row.createCell(1);
        cell.setCellValue("物资名称");
        cell.setCellStyle(style);
        cell = row.createCell(2);
        cell.setCellValue("规格型号");
        cell.setCellStyle(style);
        cell = row.createCell(3);
        cell.setCellValue("计量单位");
        cell.setCellStyle(style);
        cell = row.createCell(4);
        cell.setCellValue("计划数量");
        cell.setCellStyle(style);
        cell = row.createCell(5);
        cell.setCellValue("暂估单价");
        cell.setCellStyle(style);
        cell = row.createCell(6);
        cell.setCellValue("暂估金额");
        cell.setCellStyle(style);
        cell = row.createCell(7);
        cell.setCellValue("申请数量");
        cell.setCellStyle(style);
        cell = row.createCell(8);
        cell.setCellValue("申请金额");
        cell.setCellStyle(style);
        cell = row.createCell(9);
        cell.setCellValue("入库数量");
        cell.setCellStyle(style);
        cell = row.createCell(10);
        cell.setCellValue("入库单价");
        cell.setCellStyle(style);
        cell = row.createCell(11);
        cell.setCellValue("入库金额");
        cell.setCellStyle(style);
        cell = row.createCell(12);
        cell.setCellValue("出库数量");
        cell.setCellStyle(style);
        cell = row.createCell(13);
        cell.setCellStyle(style);
        cell.setCellValue("出库金额");

        for (int i = 0; i < 13; i++) {
            sheet.autoSizeColumn(i);
            sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 35 / 13);
        }
        for (int i = 0; i < list.size(); i++) {
            Map<String, Object> vo = list.get(i);
            row = sheet.createRow(i + 3);
            if ((int) vo.get("materialRowSpan") > 0) {
                cell = row.createCell(0);
                cell.setCellValue(vo.get("materialCategoryName") == null ? "" : vo.get("materialCategoryName").toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 0, 0));

                cell = row.createCell(1);
                cell.setCellValue(vo.get("materialName") == null ? "" : vo.get("materialName").toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 1, 1));
                cell = row.createCell(2);
                cell.setCellValue(vo.get("materialSpec") == null ? "" : vo.get("materialSpec").toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 2, 2));
                cell = row.createCell(3);
                cell.setCellValue(vo.get("materialUnit") == null ? "" : vo.get("materialUnit").toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 3, 3));

                if (vo.get("pNum") != null) {
                    cell = row.createCell(4);
                    cell.setCellValue(vo.get("pNum").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 4, 4));
                    cell = row.createCell(5);
                    cell.setCellValue(vo.get("pPrice")!=null ? vo.get("pPrice").toString():null);
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 5, 5));
                    cell = row.createCell(6);
                    cell.setCellValue(vo.get("pAmount").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 6, 6));
                } else {
                    cell = row.createCell(4);
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 4, 4));
                    cell = row.createCell(5);
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 5, 5));
                    cell = row.createCell(6);
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 6, 6));
                }
                if (vo.get("aNum") != null) {
                    cell = row.createCell(7);
                    cell.setCellValue(vo.get("aNum").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 7, 7));
                    cell = row.createCell(8);
                    cell.setCellValue(vo.get("aAmount").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 8, 8));
                } else {
                    cell = row.createCell(7);
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 7, 7));
                    cell = row.createCell(8);
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 8, 8));
                }
                if (vo.get("oNum") != null) {
                    cell = row.createCell(12);
                    cell.setCellValue(vo.get("oNum").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 12, 12));
                    cell = row.createCell(13);
                    cell.setCellValue(vo.get("oAmount").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 13, 13));
                } else {
                    cell = row.createCell(12);
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 12, 12));
                    cell = row.createCell(13);
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("materialRowSpan")) - 1, 13, 13));
                }
            }
            if ((int) vo.get("iUnitPriceRowSpan") > 0) {
                if (vo.get("iNum") != null) {
                    cell = row.createCell(9);
                    cell.setCellValue(vo.get("iNum").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("iUnitPriceRowSpan")) - 1, 9, 9));
                    cell = row.createCell(10);
                    cell.setCellValue(vo.get("iUnitPrice") !=null ? vo.get("iUnitPrice").toString() :null);
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("iUnitPriceRowSpan")) - 1, 10, 10));
                    cell = row.createCell(11);
                    cell.setCellValue(vo.get("iAmount").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("iUnitPriceRowSpan")) - 1, 11, 11));
                } else {
                    cell = row.createCell(9);
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("iUnitPriceRowSpan")) - 1, 9, 9));
                    cell = row.createCell(10);
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("iUnitPriceRowSpan")) - 1, 10, 10));
                    cell = row.createCell(11);
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.get("iUnitPriceRowSpan")) - 1, 11, 11));
                }
            }
        }
        workbook.write(outputStream);


    }


    /**
     * @Author mrsir_wxp
     * @Date 2021/3/22 根据项目查询物资看板
     * @Description queryMaterialViewBoardByProjectId
     * @Param [projectId]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
     */
    @RequestMapping(value = "queryMaterialViewBoardByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryMaterialViewBoardByProjectId(@RequestParam Long projectId) {
        return statisticsService.queryMaterialViewBoardByProjectId(projectId);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2021/3/22 根据项目查询材料成本
     * @Description queryMaterialViewBoardByProjectId
     * @Param [projectId]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
     */
    @RequestMapping(value = "queryMaterialCostByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialCostVO> queryMaterialCostByProjectId(@RequestParam Long projectId) {
        return statisticsService.queryMaterialCostByProjectId(projectId);
    }
}
