package com.ejianc.business.material.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.ejianc.business.material.bean.InstoreBillEntity;
import com.ejianc.business.material.bean.InstoreBillMaterialEntity;
import com.ejianc.business.material.vo.InstoreBillMaterialVO;
import com.ejianc.business.material.vo.InstoreBillVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Mapper
public interface InstoreBillMaterialMapper extends BaseCrudMapper<InstoreBillMaterialEntity> {

    Long queryStoreCanUseNumPageDataCount(@Param("searchText") String searchText,
                                          @Param("outDate") String outDate,
                                          @Param("storeId") Long storeId);

    InstoreBillMaterialVO censusStorematerial(@Param("storeId") Long storeId);

    List<InstoreBillMaterialVO> queryStoreCanUseNumPageData(@Param("searchText") String searchText,
                                                        @Param("outDate") String outDate,
                                                        @Param("storeId") Long storeId,
                                                        @Param("startLine") Integer startLine,
                                                        @Param("pageSize") Integer pageSize);

    Long countStorematerialList(@Param("storeId") Long storeId, @Param("searchText") String searchText);

    List<InstoreBillMaterialVO> storematerialList(@Param("storeId") Long storeId, @Param("searchText") String searchText,
                                              @Param("startLine") Integer startLine, @Param("pageSize") Integer pageSize);

    BigDecimal countAmount(@Param(Constants.WRAPPER) QueryWrapper<InstoreBillEntity> queryWrapper);

    Long queryUsableSubMaterialCount(@Param("searchText") String searchText,
                                     @Param("outDate") String outDate,
                                     @Param("storeId") Long storeId,
                                     @Param("materialIds") List<Long> materialIds, @Param("map") HashMap<String, String> map);

    List<InstoreBillMaterialVO> queryUsableSubMaterialPageList(@Param("searchText") String searchText,
                                                           @Param("outDate") String outDate,
                                                           @Param("storeId") Long storeId,
                                                           @Param("startLine") Integer startLine,
                                                           @Param("pageSize") Integer pageSize,
                                                           @Param("materialIds") List<Long> materialIds, @Param("map") HashMap<String, String> map);

    List<InstoreBillMaterialVO> querySubMaterialStoreInfo(@Param("storeId") Long storeId, @Param("outDate") Date outDate,
                                                      @Param("materialId") Long materialId, @Param("inventory") double inventory);

    Map<String, BigDecimal> queryStoreLeftMoneyAndMaterialTypeNumByProjectId(@Param("projectId") Long projectId);

    /**
     * @param projectId
     * @param materialIds
     * @description: 根据项目查询已经生效的入库数量
     * @return: java.util.List<com.ejianc.business.material.vo.MaterialPriceVO>
     * @author songlx
     * @date: 2021-05-27
     */
    List<MaterialPriceVO> queryMaterialInstoreCount(@Param(value = "projectId") Long projectId, @Param(value = "materialIds") List<Long> materialIds);

    List<InstoreBillMaterialVO> instoreNumCount(Map<String, Object> queryParam);

    List<InstoreBillVO> amountSum(List<Long> projectIds);

    List<MaterialPriceVO> queryReturnInStoreCount(Long projectId, List<Long> materialIds);
}
