package com.ejianc.business.material.mapper;

import com.ejianc.business.material.bean.MaterialContractDetailSubEntity;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.controller.SqlParam;
import com.ejianc.business.material.vo.MaterialContractDetailSubVO;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.MaterialReportVo;
import com.ejianc.business.material.vo.warn.MaterialWarnVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

@Mapper
public interface MaterialContractMapper extends BaseCrudMapper<MaterialContractEntity> {

    /**
     * 查询所有满足预警条件的项目合同
     *
     * @param sqlParamList
     * @return
     */
    List<Map<String, Object>> queryAllWarnContracts(@Param(value = "sqlParamList") List<SqlParam> sqlParamList);

    List<MaterialContractVO> queryContractTaxWarnContract(@Param(value = "sqlParamList") List<SqlParam> sqlParamList);

    List<MaterialWarnVo> materialProjectOutMny(@Param(value = "tenantIds") List<Long> tenantIds);

    List<MaterialReportVo> getMonthMaterialMny(@Param(value = "projectId") Long projectId, @Param(value = "lastDay") Integer lastDay);

    List<MaterialContractVO> queryWarnContracts(@Param(value = "tenantAllIds") List<Long> tenantAllIds);

    List<MaterialContractVO> queryWarnPrePayContracts(@Param(value = "tenantAllIds") List<Long> tenantAllIds);


    /***
     * @description: 根据项目id查询该项目物资总计划明细价格
     *
     * @param projectId
     * @return: java.util.List<com.ejianc.business.material.vo.MaterialPriceVO>
     * @author songlx
     * @date: 2021-05-25
     */
    List<MaterialPriceVO> queryPlanPriceByProjectId(@Param(value = "projectId") Long projectId, @Param(value = "materialIds") List<Long> materialIds);


    /***
     * @description: 根据租户id查询该物资结算价格区间
     *
     * @param tenantId tenantId
     * @return: java.util.List<com.ejianc.business.material.vo.MaterialPriceVO>
     * @author songlx
     * @date: 2021-05-25
     */
    List<MaterialPriceVO> querySettlePriceByTenantId(@Param(value = "tenantId") Long tenantId, @Param(value = "materialIds") List<Long> materialIds);

    /**
     * @description:  查询已生效的合同物资数量
     *
     * @param contractId
     * @param projectId
     * @param materialIds
     * @return: java.util.List<com.ejianc.business.material.vo.MaterialPriceVO>
     * @author songlx
     * @date: 2021-05-26
     */
    List<MaterialPriceVO> queryMaterialContractCount(@Param(value = "contractId") Long contractId,@Param(value = "projectId") Long projectId, @Param(value = "materialIds") List<Long> materialIds);

    /***
     * @description:  查询该物资结算价格区间
     *
     * @param projectId
     * @param contractId
     * @param orgId
     * @param materialIds
     * @return: java.util.List<com.ejianc.business.material.vo.MaterialPriceVO>
     * @author songlx
     * @date: 2021-05-27
     */
    List<MaterialPriceVO> querySettlePriceByParam(@Param(value = "projectId") Long projectId,
                                                       @Param(value = "contractId") Long contractId,
                                                       @Param(value = "orgId") Long orgId,
                                                       @Param(value = "materialIds") List<Long> materialIds);

    List<MaterialContractDetailSubVO> queryListByMaterial(Map<String, Object> queryParam);
}
