package com.ejianc.business.material.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.OutStoreEntity;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.OutStoreVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.material.vo.PickRegisterDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

public interface IOutStoreService extends IBaseService<OutStoreEntity> {
    IPage<OutStoreVO> queryForList(QueryParam queryParam, boolean isEs);

    void processCost(OutStoreEntity entity);

    /**
     * @Author mrsir_wxp
     * @Date 2021/2/21 查询物资开累年累消耗top n
     * @Description queryMaterialCostTopN
     * @Param topN 消耗前几位
     * @Param type 1、开累，2、年累  默认年累top5
     * @Return java.util.List<com.alibaba.fastjson.JSONObject>
     */
    CommonResponse<List<JSONObject>> queryMaterialCostTopN(Integer topN, Integer type);
    /**
     * @param vo
     * @description: 物资出库数量>=总计划数量X%校验
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.finance.vo.ParamsCheckVO>
     * @author jiangyikai
     * @date: 2022-04-11
     */
    ParamsCheckVO checkParams(MaterialPriceVO vo);

    List<PickRegisterDetailVO> queryPickDeductList(Page<PickRegisterDetailVO> page, QueryWrapper wrapper, Long projectId, Long supplierId);
}
