package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.bean.InstoreMaterialEntity;
import com.ejianc.business.material.mapper.InstoreMaterialMapper;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.business.material.service.IInstoreMaterialService;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.service.IUseApplyService;
import com.ejianc.business.material.vo.*;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;


@Service("instoreMaterialService")
public class InstoreMaterialService extends BaseServiceImpl<InstoreMaterialMapper, InstoreMaterialEntity> implements IInstoreMaterialService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private InstoreMaterialMapper instoreMaterialMapper;


    @Autowired
    private IParamConfigApi paramConfigApi;

    //总计划量
    private static String PARAM_PLAN_COUNT = "P-D80E4406";
    //用料申请量
    private static String PARAM_APPLY_COUNT = "P-Zm16p834";

    @Autowired
    private MaterialContractMapper materialContractMapper;
    @Autowired
    IOutStoreService iOutStoreService;
    @Autowired
    private IUseApplyService useApplyService;


    @Override
    public List<InstoreMaterialVO> querylist(QueryWrapper<InstoreMaterialEntity> queryWrapper) {
        List<InstoreMaterialEntity> list = this.list(queryWrapper);
        return BeanMapper.mapList(list, InstoreMaterialVO.class);
    }

    @Override
    public BigDecimal countAmount(QueryParam param) {
        QueryWrapper<InstoreEntity> queryWrapper = super.changeToQueryWrapper(param);
        queryWrapper.eq("dr", 0);
        return instoreMaterialMapper.countAmount(queryWrapper);
    }

    @Override
    public IPage<InstoreMaterialVO> queryStoreCanUseNumPageData(String searchText, String searchObject,String outDate, Long storeId, Integer pageNum, Integer pageSize) {
        IPage<InstoreMaterialVO> page = new Page<>();
        page.setCurrent(pageNum);
        page.setPages(pageSize);
        page.setSize(pageSize);
        String materialTypeName="";
        String materialName="";
        String materialSpec="";
        String materialUnit="";
        if(StringUtils.isNotBlank(searchObject)){
            JSONObject search = JSONObject.parseObject(searchObject);
            if(search.get("materialCategoryName")!=null){
               materialTypeName = search.get("materialCategoryName").toString();
            }
            if(search.get("materialName")!=null){
               materialName = search.get("materialName").toString();
            }
            if(search.get("materialSpec")!=null){
               materialSpec = search.get("materialSpec").toString();
            }
            if(search.get("materialUnit")!=null){
              materialUnit = search.get("materialUnit").toString();
            }
        }

        Long count = instoreMaterialMapper.queryStoreCanUseNumPageDataCount(searchText, outDate, storeId, materialTypeName,materialName,materialSpec,materialUnit);
        page.setTotal(count);
        List<InstoreMaterialVO> records =
                instoreMaterialMapper.queryStoreCanUseNumPageData(searchText, outDate, storeId, (pageNum - 1) * pageSize, pageSize, materialTypeName,materialName,materialSpec,materialUnit);
        page.setRecords(records);
        return page;
    }

    @Override
    public IPage<InstoreMaterialVO> storematerialList(Long storeId, String searchText, Integer pageNumber, Integer pageSize) {
        IPage<InstoreMaterialVO> page = new Page<>();
        Long count = instoreMaterialMapper.countStorematerialList(storeId, searchText);
        if (count > 0) {
            Integer startLine = null;
            if (pageNumber != null) {
                startLine = ((pageNumber > 0 ? pageNumber : 1) - 1) * pageSize;
                page.setCurrent(pageNumber);
                page.setSize(pageSize);
            }
            List<InstoreMaterialVO> list = instoreMaterialMapper.storematerialList(storeId, searchText, startLine, pageSize);
            page.setRecords(list);
        }
        page.setTotal(count);
        return page;
    }

    @Override
    public InstoreMaterialVO censusStorematerial(Long storeIid) {
        return instoreMaterialMapper.censusStorematerial(storeIid);
    }

    @Override
    public IPage<InstoreMaterialVO> queryUsableSubMaterialList(String searchText, String outDate, Long storeId, Integer pageNumber, Integer pageSize, List<Long> materialIds, HashMap<String, String> map) {
        IPage<InstoreMaterialVO> page = new Page<>();
        page.setCurrent(pageNumber);
        page.setPages(pageSize);
        page.setSize(pageSize);
        Long count = instoreMaterialMapper.queryUsableSubMaterialCount(searchText, outDate, storeId, materialIds, map);
        page.setTotal(count);
        List<InstoreMaterialVO> records =
                instoreMaterialMapper.queryUsableSubMaterialPageList(searchText, outDate, storeId, (pageNumber - 1) * pageSize, pageSize, materialIds, map);
        page.setRecords(records);
        return page;
    }

    @Override
    public List<InstoreMaterialVO> querySubMaterialStoreInfo(Long storeId, Date checkDate, Long materialId, double inventory) {
        return instoreMaterialMapper.querySubMaterialStoreInfo(storeId, checkDate, materialId, inventory);
    }

    /**
     * @param vo
     * @description: 参数校验
     * @return: com.ejianc.business.finance.vo.ParamsCheckVO
     * @author songlx
     * @date: 2021-05-27
     */
    @Override
    public ParamsCheckVO checkParams(MaterialPriceVO vo) {
        List<MaterialPriceVO> detailList = vo.getDetail();
        Map<Long, MaterialPriceVO> numMap = new HashMap<>();
        detailList.forEach(detail->{
            MaterialPriceVO materialPriceVO = numMap.get(detail.getMaterialId());
            if(materialPriceVO != null){
                materialPriceVO.setNum(ComputeUtil.safeAdd(materialPriceVO.getNum(),detail.getNum()));
            }else{
                numMap.put(detail.getMaterialId(),detail);
            }
        });
        vo.setDetail(new ArrayList<>(numMap.values()));
        Integer controlType = 0;
        String[] paramsArray = {"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        List<MaterialPriceVO> detail = vo.getDetail();
        paramsCheckVO.setWarnType(paramsArray[0]);
        if (CollectionUtils.isEmpty(detail)) {
            return paramsCheckVO;
        }
        //【总计划量】控制【材料入库量】
        CommonResponse<BillParamVO> countParamByCode = paramConfigApi.getBillParamByCode(PARAM_PLAN_COUNT);

        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
        if (countParamByCode.isSuccess() && null != countParamByCode.getData()) {
            BillParamVO billParamVO = countParamByCode.getData();
            if (0 != billParamVO.getControlType()) {
                List<Long> materialIds = detail.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
                //获取已生效的量
                List<MaterialPriceVO> vos = instoreMaterialMapper.queryMaterialInstoreCount(vo.getId(), vo.getProjectId(), materialIds);
                //获取计划数量
                List<MaterialPriceVO> materialPriceVOS = materialContractMapper.queryPlanPriceByProjectId(vo.getProjectId(), materialIds);
                if (CollectionUtils.isNotEmpty(materialPriceVOS)) {
                    Map<Long, MaterialPriceVO> priceVOMap = materialPriceVOS.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account, (v1, v2) -> v2));
                    for (MaterialPriceVO v : detail) {
                        Long materialId = v.getMaterialId();
                        MaterialPriceVO p = priceVOMap.get(materialId);
                        if (null != p) {
                            v.setPlanNum(p.getPlanNum());
                            v.setPlanPrice(p.getPlanPrice());
                        }
                    }
                }
                Map<Long, BigDecimal> numVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));

                BigDecimal roleValue = billParamVO.getRoleValue();
                BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                for (MaterialPriceVO d : detail) {
                    BigDecimal num = d.getNum();
                    BigDecimal planNum = d.getPlanNum();
                    BigDecimal hasNum = numVOMap.get(d.getMaterialId()) != null ? numVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                    BigDecimal allNum = hasNum.add(num);
                    //百分比数量
                    BigDecimal _planNum = planNum.multiply(divide);
                    if (allNum.compareTo(_planNum) > 0) {
                        controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "instoreNumber");
                        paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : "" ));
                        paramsCheckDsVO.setWarnName("材料入库数量大于总计划数量");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次入库数量：").append(num.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("，已入库数量：").append(hasNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("，总计划数量*").append(roleValue).append("%: ").append(_planNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("。超出数量：").append(allNum.subtract(_planNum).setScale(2, BigDecimal.ROUND_HALF_UP));
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                }
            }
        } else {
            logger.info(countParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }

        //【用料申请】控制【材料入库量】
        CommonResponse<BillParamVO> applyParamByCode = paramConfigApi.getBillParamByCode(PARAM_APPLY_COUNT);
        if (applyParamByCode.isSuccess() && null != applyParamByCode.getData()) {
            BillParamVO billParamVO = applyParamByCode.getData();
            if (0 != billParamVO.getControlType()) {
                List<Long> materialIds = detail.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
                //获取已生效的量
                List<MaterialPriceVO> vos = instoreMaterialMapper.queryMaterialInstoreCount(vo.getId(), vo.getProjectId(), materialIds);
                //获取用料申请量
                List<MaterialApplyCountVO> applyCountVOS = useApplyService.queryMaterialApplyCount(vo.getProjectId(), materialIds);

                Map<Long, BigDecimal> numVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));
                Map<Long, BigDecimal> applyVOMap = applyCountVOS.stream().collect(Collectors.toMap(MaterialApplyCountVO::getMaterialId, MaterialApplyCountVO::getApplyNum));
                BigDecimal roleValue = billParamVO.getRoleValue();
                BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                for (MaterialPriceVO d : detail) {
                    BigDecimal num = d.getNum();
                    BigDecimal applyNum = applyVOMap.get(d.getMaterialId()) != null ? applyVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                    BigDecimal hasNum = numVOMap.get(d.getMaterialId()) != null ? numVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                    BigDecimal allNum = ComputeUtil.safeAdd(hasNum,num);
                    //百分比数量
                    BigDecimal _applyNum = applyNum.multiply(divide);
                    if (allNum.compareTo(_applyNum) > 0) {
                        controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "instoreNumber");
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                        paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                        paramsCheckDsVO.setWarnName("项目入库数量超项目用料申请量");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次入库数量：").append(num.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("，含本次累计入库数量：").append(allNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("，用料申请数量*").append(roleValue).append("%: ").append(_applyNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("。超出数量：").append(ComputeUtil.safeSub(allNum,_applyNum).setScale(2, BigDecimal.ROUND_HALF_UP));
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                }
            }
        }else {
            logger.info(countParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        paramsCheckVO.setWarnType(paramsArray[controlType]);
        paramsCheckVO.setDataSource(checkDsVOS);
        //直入直出暂时不做出库校验
   /*     if(vo.getStraight()){
            //出库校验
            ParamsCheckVO paramsOutCheckVO = iOutStoreService.checkParams(vo);
            if (paramsOutCheckVO!=null){
                List<ParamsCheckDsVO> dataSource = paramsOutCheckVO.getDataSource();
                if (CollectionUtils.isNotEmpty(dataSource)){
                    Map<String, Integer> map = new HashMap<>();
                    for (int i = 0; i < paramsArray.length; i++) {
                        map.put(paramsArray[i],i);
                    }
                    //入库预警级别大于出库 使用入库的
                    if ( map.get(paramsCheckVO.getWarnType())>map.get(paramsOutCheckVO.getWarnType())){
                        paramsCheckVO.setWarnType(paramsCheckVO.getWarnType());
                    }
                    //出库预警级别大于入库 使用出库的
                    if (map.get(paramsCheckVO.getWarnType())<map.get(paramsOutCheckVO.getWarnType())){
                        paramsCheckVO.setWarnType(paramsOutCheckVO.getWarnType());
                    }
                    paramsCheckVO.getDataSource().addAll(dataSource);
                }
            }
        }*/

        return paramsCheckVO;
    }
}
