package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.bean.InstoreMaterialEntity;
import com.ejianc.business.material.bean.OutStoreEntity;
import com.ejianc.business.material.bean.OutStoreSubEntity;
import com.ejianc.business.material.pub.MaterialStoreState;
import com.ejianc.business.material.pub.MaterialStoreType;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.service.IUseApplyService;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.OutStoreVO;
import com.ejianc.business.material.vo.UseApplyFinishVO;
import com.ejianc.business.plan.api.IBudgetPlanApi;
import com.ejianc.business.plan.vo.RecalculateVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("straightInout")
public class StraightInoutBpmService implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String OUT_STORE_BILL_CODE = "MATERIAL-OUTSTORE";

    @Autowired
    IInstoreService iInstoreService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
	IOutStoreService iOutStoreService;
    @Autowired
    private InstoreMaterialService instoreMaterialService;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private ICostDetailApi iCostDetailApi;

    @Autowired
    IBudgetPlanApi budgetPlanApi;

    @Autowired
    IUseApplyService useApplyService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 提交完回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
    	logger.info("审批通过后的回调开始-------------------billId：{}，state：{}，billTypeCode：{}",billId,state,billTypeCode);

        InstoreEntity entity = iInstoreService.selectById(billId);
        if(entity==null){
            CommonResponse.error("没有找到相关入库单！");
        }
        logger.info("审批通过后的回调，修改InstoreEntity状态------"+entity.getBillState());
        List<OutStoreSubEntity> outStoreSubEntities = new ArrayList<>();
        if(!ListUtil.isEmpty(entity.getInstoreMaterialList())){
        	OutStoreSubEntity subEntity = new OutStoreSubEntity();
        	for(InstoreMaterialEntity sub : entity.getInstoreMaterialList()){
                sub.setStoreState(MaterialStoreState.STORED.getCode());
                subEntity = BeanMapper.map(sub, OutStoreSubEntity.class);
                subEntity.setStoreState(MaterialStoreState.USED.getCode());
                subEntity.setId(null);
                subEntity.setOutStoreNumber(sub.getInstoreNumber());
                subEntity.setSourceMainId(entity.getId());
                subEntity.setSourceSubId(sub.getId());
                subEntity.setStoreType(MaterialStoreType.STRAIGHT_OUT_STORE.getCode());
                subEntity.setOutDate(entity.getInstoreDate());
                outStoreSubEntities.add(subEntity);
        	}
        }
        /** 领料退库 & 直入直出 成本处理*/
        processCostState(entity,1);
        iInstoreService.saveOrUpdate(entity,false);

        OutStoreEntity outentity = BeanMapper.map(entity, OutStoreEntity.class);
        /** 直入直出直接使用入库单编号作为出库单编号 */
        outentity.setStraightInId(entity.getId());
        outentity.setId(null);
        outentity.setOutStoreSubEntities(outStoreSubEntities);
        outentity.setOutDate(entity.getInstoreDate());
        outentity.setOutMoney(entity.getTotalAmount());
        outentity.setOutNum(entity.getTotalCount());
        outentity.setMaterialNames(entity.getMaterialName());
        outentity.setStoreType(MaterialStoreType.STRAIGHT_OUT_STORE.getCode());
        /**
         * 这个地方 用劳务队伍的id和名称替换供应商的id和name 原因 出库明细那个领料队伍-用的供应商的字段 之前加字段 不应该占用供应商 这个字段
         */
        outentity.setSupplierId(entity.getLabourArmyId());
        outentity.setSupplierName(entity.getLabourArmy());
        logger.info("直入直出 保存 出库单详情--------------->outentity.getBillState(){}",outentity.getBillState());
        iOutStoreService.saveOrUpdate(outentity,false);

        if (null != entity && entity.getProjectId() != null) {

            RecalculateVO cal = RecalculateVO.intsance(entity.getProjectId(), null);
            CommonResponse<RecalculateVO> info = budgetPlanApi.getInfo(cal);
            //如果有计划信息
            if (info.isSuccess()) {
                RecalculateVO data = info.getData();
                Map<String, Object> queryParam = data.getQueryParam();
                if (queryParam != null && queryParam.size() > 0) {
                    List<InstoreMaterialVO> instoreMaterialVOS = iInstoreService.instoreNumCount(queryParam);
                    List<UseApplyFinishVO> useApplySubVOS = useApplyService.materialFinishCount(queryParam);
                    if(CollectionUtils.isNotEmpty(instoreMaterialVOS)){
                        cal.setInstoreMaterialVOS(instoreMaterialVOS);
                        cal.setUseApplyFinishVOS(useApplySubVOS);
                        CommonResponse<RecalculateVO> recal = budgetPlanApi.recal(cal);
                        logger.info("直入直出审批通过回写施工计划返回信息:" + recal.getMsg());
                    }
                }
            } else {
                CommonResponse<RecalculateVO> recalculateVOCommonResponse = budgetPlanApi.recal3(entity.getProjectId());
                logger.info("无施工计划入库更新:"+recalculateVOCommonResponse.getMsg());
                logger.info("直入直出审批通过查询施工计划返回信息:" + info.getMsg());
            }
        }
        
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
    	logger.info("弃审后的回调开始-------------------");
        InstoreEntity entity = iInstoreService.selectById(billId);
        if(entity==null){
            CommonResponse.error("没有找到相关入库单！");
        }
        //直入的引用校验
        CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()) {
            logger.info("直入直出单据【billId-{}】,【billTypeCode-{}】执行撤回操作校验结束，未通过校验，原因：{}",billId,billTypeCode, resp.getMsg());
            return CommonResponse.error(resp.getMsg());
        }
        QueryWrapper<OutStoreEntity> queryWrapper = new QueryWrapper<OutStoreEntity>();
        queryWrapper.eq("straight_in_id", billId);
		List<OutStoreEntity> vos = iOutStoreService.list(queryWrapper );
		List<Long> outStoreIds = vos.stream().map(OutStoreEntity::getId).collect(Collectors.toList());
        //校验直出的有没有被领料退库
		
		//根据直出的id查询领料退库的物资表中是否存在直出的物资数据
		QueryWrapper<InstoreMaterialEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("dr", 0);
		wrapper.eq("source_type", "pickReturn");
		wrapper.in("source_main_id", outStoreIds);
		List<InstoreMaterialVO> pickReturn = instoreMaterialService.querylist(wrapper);
		if(pickReturn!=null&&pickReturn.size()>0){
			return CommonResponse.error("该单据已被下游单据（领料退库引用）");
		}
		
        if(!ListUtil.isEmpty(entity.getInstoreMaterialList())){
            entity.getInstoreMaterialList().forEach(sub->{
                sub.setStoreState(MaterialStoreState.STORING.getCode());
            });
        }
        /** 领料退库 & 直入直出 成本处理*/
        processCostState(entity,0);
        iInstoreService.saveOrUpdate(entity,false);
		logger.info("删除出库数据--------");
    	iOutStoreService.removeByIds(outStoreIds,true);

        if (null != entity && entity.getProjectId() != null) {

            RecalculateVO cal = RecalculateVO.intsance(entity.getProjectId(), null);
            CommonResponse<RecalculateVO> info = budgetPlanApi.getInfo(cal);
            //如果有计划信息
            if (info.isSuccess()) {
                RecalculateVO data = info.getData();
                Map<String, Object> queryParam = data.getQueryParam();
                if (queryParam != null && queryParam.size() > 0) {
                    List<InstoreMaterialVO> instoreMaterialVOS = iInstoreService.instoreNumCount(queryParam);
                    List<UseApplyFinishVO> useApplySubVOS = useApplyService.materialFinishCount(queryParam);
                    if(CollectionUtils.isNotEmpty(instoreMaterialVOS)){
                        cal.setInstoreMaterialVOS(instoreMaterialVOS);
                        cal.setUseApplyFinishVOS(useApplySubVOS);
                        CommonResponse<RecalculateVO> recal = budgetPlanApi.recal(cal);
                        logger.info("直入直出弃审回写施工计划返回信息:" + recal.getMsg());
                    }
                }
            } else {
                CommonResponse<RecalculateVO> recalculateVOCommonResponse = budgetPlanApi.recal3(entity.getProjectId());
                logger.info("无施工计划入库更新:"+recalculateVOCommonResponse.getMsg());
                logger.info("直入直出弃审查询施工计划返回信息:" + info.getMsg());
            }
        }
		logger.info("删除出库数据成功--------");
        return CommonResponse.success();
    }
    /** 成本处理  */
    public void processCostState(InstoreEntity entity,Integer process){
        if(process == 1){//审批通过
            iInstoreService.processCost(entity);
        }else {//弃审
            iCostDetailApi.deleteSubject(entity.getId());
            entity.setRelationFlag("0");
        }
    }
}
