package com.ejianc.business.plan.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.ejianc.business.plan.bean.MaterialMasterPlanSubEntity;
import com.ejianc.business.plan.vo.MaterialMasterPlanSubVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2021/3/2 17:07
 */
@Mapper
public interface MaterialMasterPlanSubMapper extends BaseCrudMapper<MaterialMasterPlanSubEntity> {
    /**
     * 根据总计划Id删除对应所有材料清单
     *
     * @param id
     */
    void delByPlanId(@Param(value = "planId") Long id);

    void delByPlanIdAndDetailIds(@Param(value = "delDetailIds") List<Long> delDetailIds, @Param(value = "planId") Long planId);
    /**
     * 分页查询总计划明细，供参照使用
     * @param page
     * @param wrapper
     * @return
     */
    List<MaterialMasterPlanSubVO> queryPlanSubList(IPage<MaterialMasterPlanSubVO> page,@Param(Constants.WRAPPER) QueryWrapper wrapper);

    /**
     * 根据项目下的物资明细 查询该明细总计划数量
     * @param param
     * @return
     */
    List<MaterialMasterPlanSubVO> queryMasterPlanSubNum(Map<String, Object> param);
}
