package com.ejianc.business.material.service;

import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.controller.SqlParam;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.MaterialReportVo;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.material.vo.warn.MaterialWarnVo;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 *
 * 物资合同数据处理服务接口
 *
 * @author CJ
 */
public interface IMaterialContractService extends IBaseService<MaterialContractEntity> {

    List<MaterialContractVO> queryContractTaxWarnContract(List<SqlParam> sqlParamList);
    /**
    　* @Description: 物资合同保存更新
    　* @param [materialContractVO]
    　* @return com.ejianc.business.material.vo.MaterialContractVO
    　* @throws
    　* @author CJ
    　* @date 2020/6/8 11:08
    　*/
    MaterialContractVO save(MaterialContractVO materialContractVO);

    /**
    　* @Description: 统计页面原合同总金额，现合同总金额
    　* @param [queryParam]
    　* @return java.util.Map<java.lang.String,java.math.BigDecimal>
    　* @throws
    　* @author CJ
    　* @date 2020/6/8 11:28
    　*/
    Map<String, Object> countContractAmount(QueryParam queryParam);

    /**
    　* @Description: 合同编码重复校验
    　* @param [id, code]
    　* @return boolean
    　* @throws
    　* @author CJ
    　* @date 2020/6/16 16:13
    　*/
    boolean codeCheck(Long id, String code);

    void checkContract(Long id);

    /**
     * 查询所有满足预警条件的项目合同
     *
     * @param sqlParamList
     * @return
     */
    List<Map<String, Object>> queryAllWarnContracts(List<SqlParam> sqlParamList);

    List<MaterialWarnVo> materialProjectOutMny(List<Long> tenantIds);

    List<MaterialReportVo> getMonthMaterialMny(Long projectId, Integer lastDay);

    MaterialReportVo getMaterialContract(Long projectId);

    List<MaterialContractVO> queryWarnContracts(List<Long> tenantAllIds);

    List<MaterialContractVO> queryWarnPrePayContracts(List<Long> tenantAllIds);


    /***
     * @description: 根据项目id查询该项目物资总计划明细价格\物资结算价格区间
     *
     * @param vo
     * @param queryFlag
     * @return: com.ejianc.business.material.vo.MaterialPriceVO
     * @author songlx
     * @date: 2021-05-26
     */
    MaterialPriceVO queryPrice(Integer isJc, Long contractId, MaterialPriceVO vo);

    ParamsCheckVO checkParams(Integer isJc, Long contractId, MaterialPriceVO vo);

}
